/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.coff;

import com.oracle.truffle.llvm.parser.coff.CoffFile;
import com.oracle.truffle.llvm.parser.coff.ExportTable;
import com.oracle.truffle.llvm.parser.coff.PEFile;
import com.oracle.truffle.llvm.runtime.ExportSymbolsMapper;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.graalvm.collections.Pair;

public class PEExportSymbolsMapper
extends ExportSymbolsMapper {
    List<Pair<String, String>> mappings;

    public PEExportSymbolsMapper(PEFile peFile) {
        CoffFile file = peFile.getCoffFile();
        this.mappings = new ArrayList<Pair<String, String>>();
        HashMap<Integer, String> symbolMappings = new HashMap<Integer, String>();
        for (CoffFile.ImageSymbol imageSymbol : peFile.getCoffFile().getSymbols()) {
            if (!imageSymbol.hasValidSectionNumber()) continue;
            CoffFile.ImageSectionHeader sectionHeader = file.getSectionByNumber(imageSymbol.sectionNumber);
            symbolMappings.put(imageSymbol.value + sectionHeader.virtualAddress, imageSymbol.name);
        }
        for (Pair pair : peFile.getExportTable().getExports()) {
            ExportTable.Export export = (ExportTable.Export)pair.getRight();
            if (export instanceof ExportTable.ExportRVA) {
                ExportTable.ExportRVA rvaExport = (ExportTable.ExportRVA)export;
                String symbol = (String)symbolMappings.get(rvaExport.getRVA());
                if (symbol != null) {
                    this.mappings.add((Pair<String, String>)Pair.create((Object)((String)pair.getLeft()), (Object)symbol));
                    continue;
                }
                this.mappings.add((Pair<String, String>)Pair.create((Object)((String)pair.getLeft()), (Object)((String)pair.getLeft())));
                continue;
            }
            if (!(export instanceof ExportTable.ExportName)) continue;
            ExportTable.ExportName nameExport = (ExportTable.ExportName)export;
            LLVMContext.llvmLogger().warning(String.format("This library exports '%s' as '%s', but this is not yet supported. The entry will be ignored.", pair.getRight(), nameExport.getName()));
        }
    }

    @Override
    public void registerExports(LLVMScope fileScope, LLVMScope publicFileScope) {
        for (Pair<String, String> pair : this.mappings) {
            LLVMSymbol symbol = fileScope.get((String)pair.getRight());
            if (symbol != null) {
                publicFileScope.register(((String)pair.getLeft()).equals(symbol.getName()) ? symbol : new LLVMAlias((String)pair.getLeft(), symbol, true));
                continue;
            }
            LLVMContext.llvmLogger().warning(String.format("Could not map %s to %s. Target symbol not found, ignoring export.", pair.getLeft(), pair.getRight()));
        }
    }
}

