/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.asm.amd64;

import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMArgNodeGen;
import com.oracle.truffle.llvm.runtime.types.Type;

class Argument {
    private final boolean input;
    private final boolean output;
    private final boolean memory;
    private final Type type;
    private final int index;
    private final int inIndex;
    private final int outIndex;
    private final String source;
    private final String register;
    private final boolean anonymous;

    Argument(boolean input, boolean output, boolean memory, boolean anonymous, Type type, int index, int inIndex, int outIndex, String source, String register) {
        this.input = input;
        this.output = output;
        this.memory = memory;
        this.anonymous = anonymous;
        this.type = type;
        this.index = index;
        this.inIndex = inIndex;
        this.outIndex = outIndex;
        this.source = source;
        this.register = register;
    }

    public boolean isInput() {
        return this.input;
    }

    public boolean isOutput() {
        return this.output;
    }

    public boolean isMemory() {
        return this.memory;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public Type getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public int getInIndex() {
        assert (this.isInput());
        return this.inIndex;
    }

    public int getOutIndex() {
        assert (this.isOutput());
        return this.outIndex;
    }

    public String getRegister() {
        assert (this.isRegister());
        return this.register;
    }

    public boolean isRegister() {
        return this.register != null;
    }

    public LLVMExpressionNode getAddress() {
        assert (this.isMemory());
        if (this.output) {
            return LLVMArgNodeGen.create(this.outIndex);
        }
        return LLVMArgNodeGen.create(this.inIndex);
    }

    public String toString() {
        return String.format("Argument[IDX=%d,I=%s(%s),O=%s(%s),M=%s,T=%s,R=%s,S=%s]", this.index, this.input, this.inIndex, this.output, this.outIndex, this.memory, this.type, this.register, this.source);
    }
}

