/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.pointer.CommonPointerLibraries;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class, receiverType=LLVMPointerImpl.class), @ExportLibrary(value=LLVMAsForeignLibrary.class, receiverType=LLVMPointerImpl.class, useForAOT=true, useForAOTPriority=1)})
abstract class NativePointerLibraries
extends CommonPointerLibraries {
    NativePointerLibraries() {
    }

    @ExportMessage
    static boolean isNull(LLVMPointerImpl receiver) {
        return receiver.isNull();
    }

    @ExportMessage
    static boolean isForeign(LLVMPointerImpl receiver) {
        return false;
    }

    @ExportMessage(library=InteropLibrary.class)
    static boolean isPointer(LLVMPointerImpl receiver) {
        return true;
    }

    @ExportMessage(library=InteropLibrary.class)
    static long asPointer(LLVMPointerImpl receiver) {
        return receiver.asNative();
    }

    @ExportMessage
    static int identityHashCode(LLVMPointerImpl receiver) {
        return Long.hashCode(receiver.asNative());
    }

    @ExportMessage
    static String toDisplayString(LLVMPointerImpl receiver, boolean allowSideEffects) {
        return NativePointerLibraries.formatNativePointer(receiver.asNative());
    }

    @CompilerDirectives.TruffleBoundary
    private static String formatNativePointer(long raw) {
        return "0x" + Long.toHexString(raw);
    }

    @ExportMessage
    @ImportStatic(value={LLVMLanguage.class})
    static class Execute {
        Execute() {
        }

        @Specialization(limit="5", guards={"value.asNative() == cachedAddress", "cachedDescriptor != null", "isSingleContext($node)"})
        static Object doNativeCached(LLVMPointerImpl value, Object[] args, @Cached(value="value.asNative()") long cachedAddress, @Cached(value="getDescriptor(value)") LLVMFunctionDescriptor cachedDescriptor, @CachedLibrary(value="cachedDescriptor") InteropLibrary interop) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            return interop.execute((Object)cachedDescriptor, args);
        }

        @Specialization(replaces={"doNativeCached"})
        static Object doNative(LLVMPointerImpl value, Object[] args, @CachedLibrary(limit="5") InteropLibrary interop) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            LLVMFunctionDescriptor descriptor = LLVMContext.get((Node)interop).getFunctionDescriptor(value);
            if (descriptor != null) {
                return interop.execute((Object)descriptor, args);
            }
            throw UnsupportedMessageException.create();
        }

        static LLVMFunctionDescriptor getDescriptor(LLVMNativePointer value) {
            return LLVMContext.get(null).getFunctionDescriptor(value);
        }
    }

    @ExportMessage
    @ImportStatic(value={LLVMLanguage.class})
    static class IsExecutable {
        IsExecutable() {
        }

        @Specialization
        static boolean doNative(LLVMPointerImpl receiver, @CachedLibrary(value="receiver") InteropLibrary library) {
            return LLVMContext.get((Node)library).getFunctionDescriptor(receiver) != null;
        }
    }
}

