/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.interop.LLVMNegatedForeignObject;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;

@NodeChildren(value={@NodeChild(value="base", type=LLVMExpressionNode.class), @NodeChild(value="offset", type=LLVMExpressionNode.class)})
public abstract class LLVMGetElementPtrNode
extends LLVMExpressionNode {
    final long typeWidth;
    final Type targetType;

    public LLVMGetElementPtrNode(long typeWidth, Type targetType) {
        this.typeWidth = typeWidth;
        this.targetType = targetType;
    }

    public abstract LLVMExpressionNode getBase();

    public abstract LLVMExpressionNode getOffset();

    public final long getTypeWidth() {
        return this.typeWidth;
    }

    protected static boolean isNegated(Object obj, Object negatedObj) {
        if (negatedObj instanceof LLVMNegatedForeignObject) {
            return ((LLVMNegatedForeignObject)negatedObj).getForeign() == obj;
        }
        return false;
    }

    @Specialization(guards={"isNegated(addr.getObject(), val.getObject())"})
    protected LLVMPointer doPointerDiff(LLVMManagedPointer addr, LLVMManagedPointer val) {
        return LLVMNativePointer.create(addr.getOffset() + val.getOffset());
    }

    @Specialization(guards={"isNegated(val.getObject(), addr.getObject())"})
    protected LLVMPointer doPointerDiffRev(LLVMManagedPointer addr, LLVMManagedPointer val) {
        return LLVMNativePointer.create(val.getOffset() + addr.getOffset());
    }

    @Specialization
    protected LLVMPointer doInt(LLVMPointer addr, int val) {
        return addr.increment(this.typeWidth * (long)val);
    }

    @Specialization
    protected LLVMPointer doLong(LLVMPointer addr, long val) {
        return addr.increment(this.typeWidth * val);
    }

    @Specialization
    protected LLVMPointer doNativePointer(LLVMPointer addr, LLVMNativePointer val) {
        return addr.increment(this.typeWidth * val.asNative());
    }
}

