/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

public abstract class LLVMX86_ConversionNode {

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMX86_Movmskpd
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(LLVMDoubleVector vector) {
            if (vector.getLength() != 2) {
                throw CompilerDirectives.shouldNotReachHere((String)"expected a <2 x double> vector");
            }
            return (vector.getValue(1) < 0.0 ? 1 : 0) << 1 | (vector.getValue(0) < 0.0 ? 1 : 0);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMX86_Pmovmskb128
    extends LLVMBuiltin {
        private static final int VECTOR_LENGTH = 16;

        @Specialization
        @ExplodeLoop
        protected int doIntrinsic128(LLVMI8Vector vector) {
            if (vector.getLength() != 16) {
                throw CompilerDirectives.shouldNotReachHere((String)"expected a <16 x i8> vector");
            }
            int result = 0;
            for (int i = 0; i < 16; ++i) {
                byte currentByte = vector.getValue(i);
                int mostSignificantBit = (currentByte & 0xFF) >> 7;
                result |= mostSignificantBit << i;
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected int doIntrinsic32(float vector) {
            int result = 0;
            int v = Float.floatToRawIntBits(vector);
            for (int i = 0; i < 4; ++i) {
                int currentByte = v >> i * 8 & 0xFF;
                int mostSignificantBit = currentByte >> 7;
                result |= mostSignificantBit << i;
            }
            return result;
        }

        @Specialization
        @ExplodeLoop
        protected int doIntrinsic64(double vector) {
            int result = 0;
            long v = Double.doubleToRawLongBits(vector);
            for (int i = 0; i < 8; ++i) {
                int currentByte = (int)(v >> i * 8) & 0xFF;
                int mostSignificantBit = currentByte >> 7;
                result |= mostSignificantBit << i;
            }
            return result;
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMX86_ConversionDoubleToIntNode
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(LLVMDoubleVector vector) {
            if (vector.getLength() != 2) {
                throw CompilerDirectives.shouldNotReachHere((String)"cvtsd2si requires a double[2] as parameter");
            }
            return Math.toIntExact(Math.round(vector.getValue(0)));
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMX86_ConversionFloatToIntNode
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(LLVMFloatVector vector) {
            if (vector.getLength() != 4) {
                throw CompilerDirectives.shouldNotReachHere((String)"cvtss2si requires a float[4] as parameter");
            }
            return Math.round(vector.getValue(0));
        }
    }
}

