/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.bit;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.bit.CountLeadingZeroesNodeFactory;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;

public abstract class CountLeadingZeroesNode {
    public static LLVMBuiltin.TypedBuiltinFactory getFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case I8: {
                return LLVMBuiltin.TypedBuiltinFactory.simple2(CountLeadingZeroesNodeFactory.CountLeadingZeroesI8NodeGen::create);
            }
            case I16: {
                return LLVMBuiltin.TypedBuiltinFactory.simple2(CountLeadingZeroesNodeFactory.CountLeadingZeroesI16NodeGen::create);
            }
            case I32: {
                return LLVMBuiltin.TypedBuiltinFactory.simple2(CountLeadingZeroesNodeFactory.CountLeadingZeroesI32NodeGen::create);
            }
            case I64: {
                return LLVMBuiltin.TypedBuiltinFactory.simple2(CountLeadingZeroesNodeFactory.CountLeadingZeroesI64NodeGen::create);
            }
        }
        return null;
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class CountLeadingZeroesI64Node
    extends LLVMBuiltin {
        @Specialization
        protected long doI64(long val, boolean isZeroUndefined) {
            return Long.numberOfLeadingZeros(val);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class CountLeadingZeroesI32Node
    extends LLVMBuiltin {
        @Specialization
        protected int doI32(int val, boolean isZeroUndefined) {
            return Integer.numberOfLeadingZeros(val);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class CountLeadingZeroesI16Node
    extends LLVMBuiltin {
        @Specialization
        protected short doI16(short val, boolean isZeroUndefined) {
            return (byte)(Integer.numberOfLeadingZeros(val & 0xFFFF) - 32 + 16);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class CountLeadingZeroesI8Node
    extends LLVMBuiltin {
        @Specialization
        protected byte doI8(byte val, boolean isZeroUndefined) {
            return (byte)(Integer.numberOfLeadingZeros(val & 0xFF) - 32 + 8);
        }
    }
}

