/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;

@NodeChildren(value={@NodeChild(value="name", type=LLVMExpressionNode.class), @NodeChild(value="value", type=LLVMExpressionNode.class)})
public abstract class LLVMPolyglotExport
extends LLVMIntrinsic {
    @Node.Child
    LLVMReadStringNode readString = LLVMReadStringNodeGen.create();
    @Node.Child
    LLVMDataEscapeNode escape = LLVMDataEscapeNodeFactory.LLVMPointerDataEscapeNodeGen.create();

    @Specialization
    @GenerateAOT.Exclude
    protected Object doExport(Object name, Object value, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
        String symbolName = this.readString.executeWithTarget(name);
        Object escaped = this.escape.executeWithTarget(value);
        try {
            interop.writeMember(this.getContext().getEnv().getPolyglotBindings(), symbolName, escaped);
        }
        catch (InteropException ex) {
            exception.enter();
            throw new LLVMPolyglotException(this, ex.getMessage());
        }
        return null;
    }
}

