/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.except.LLVMNativePointerException;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMNativeCallUtils;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMNativeDispatchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMNativeDispatchNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import com.oracle.truffle.nfi.api.NativePointerLibrary;
import com.oracle.truffle.nfi.api.SignatureLibrary;

public abstract class LLVMDispatchNode
extends LLVMNode {
    protected static final int INLINE_CACHE_SIZE = 5;
    protected final FunctionType type;
    @CompilerDirectives.CompilationFinal
    LLVMFunction aotFixedIntrinsicFunction;
    @CompilerDirectives.CompilationFinal
    protected Source signatureSource;
    @CompilerDirectives.CompilationFinal
    private ContextExtension.Key<NativeContextExtension> nativeCtxExtKey;
    @Node.Child
    private LLVMNode.AOTInitHelper aotInitHelper;
    @CompilerDirectives.CompilationFinal
    private boolean aot;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected LLVMDispatchNode(FunctionType type, LLVMFunction llvmFunction) {
        this.type = type;
        LLVMContext context = LLVMLanguage.getContext();
        if (context != null && context.isAOTCacheStore()) {
            this.aotInitHelper = new LLVMNode.AOTInitHelper((language, root) -> {
                if (llvmFunction != null && llvmFunction.getFixedCode() != null && llvmFunction.getFixedCode().isIntrinsicFunctionSlowPath()) {
                    this.aotFixedIntrinsicFunction = llvmFunction;
                    llvmFunction.getFixedCode().getIntrinsicSlowPath().cachedCallTarget(type);
                }
                this.aot = true;
                this.aotInitHelper = null;
            });
            try {
                this.nativeCtxExtKey = context.getLanguage().lookupContextExtension(NativeContextExtension.class);
                if (this.nativeCtxExtKey == null || type.getNumberOfArguments() <= 0) return;
                NativeContextExtension nativeContextExtension = this.nativeCtxExtKey.get(context);
                this.signatureSource = nativeContextExtension.getNativeSignatureSourceSkipStackArg(type);
                return;
            }
            catch (NativeContextExtension.UnsupportedNativeTypeException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.aotInitHelper = new LLVMNode.AOTInitHelper((language, root) -> {
                this.aot = true;
                this.aotInitHelper = null;
            });
        }
    }

    @Override
    public String toString() {
        return this.getShortString("type", "signature");
    }

    @Idempotent
    boolean haveNativeCtxExt() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getLanguage().lookupContextExtension(NativeContextExtension.class) != null;
    }

    NativeContextExtension getNativeCtxExt() {
        if (this.nativeCtxExtKey == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeCtxExtKey = this.getLanguage().lookupContextExtension(NativeContextExtension.class);
        }
        return this.nativeCtxExtKey.get(this.getContext());
    }

    private Source getSignatureSource() {
        if (this.signatureSource == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            try {
                this.signatureSource = this.getNativeCtxExt().getNativeSignatureSourceSkipStackArg(this.type);
            }
            catch (NativeContextExtension.UnsupportedNativeTypeException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }
        return this.signatureSource;
    }

    public abstract Object executeDispatch(Object var1, Object[] var2);

    protected DirectCallNode createCallNode(LLVMFunctionCode code) {
        if (code.isLLVMIRFunction()) {
            return DirectCallNode.create((CallTarget)code.getLLVMIRFunctionSlowPath());
        }
        if (code.isIntrinsicFunctionSlowPath()) {
            return DirectCallNode.create((CallTarget)code.getIntrinsicSlowPath().cachedCallTarget(this.type));
        }
        return null;
    }

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"code == cachedFunctionCode"})
    protected static Object doDirectCodeFast(LLVMFunctionCode code, Object[] arguments, @Cached(value="code") LLVMFunctionCode cachedFunctionCode, @Cached(value="createCallNode(cachedFunctionCode)") DirectCallNode callNode) {
        assert (callNode != null) : "inconsistent behavior of LLVMLookupDispatchTargetSymbolNode";
        return callNode.call(arguments);
    }

    @Specialization(replaces={"doDirectCodeFast"}, guards={"code.isLLVMIRFunction()"})
    protected static Object doIndirectCode(LLVMFunctionCode code, Object[] arguments, @Cached LLVMFunctionCode.ResolveFunctionNode resolve, @Cached(value="create()") IndirectCallNode callNode) {
        return callNode.call((CallTarget)code.getLLVMIRFunction(resolve), arguments);
    }

    @Specialization(limit="INLINE_CACHE_SIZE", replaces={"doDirectCodeFast"}, guards={"descriptor == cachedDescriptor", "callNode != null", "isSingleContext($node)"})
    protected static Object doDirectFunction(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached(value="descriptor") LLVMFunctionDescriptor cachedDescriptor, @Cached(value="cachedDescriptor.getFunctionCode()") LLVMFunctionCode cachedFunctionCode, @Cached(value="createCallNode(cachedFunctionCode)") DirectCallNode callNode) {
        return callNode.call(arguments);
    }

    @Specialization(limit="INLINE_CACHE_SIZE", replaces={"doDirectFunction"}, guards={"descriptor.getFunctionCode() == cachedFunctionCode", "callNode != null"})
    protected static Object doDirectCode(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached(value="descriptor.getFunctionCode()") LLVMFunctionCode cachedFunctionCode, @Cached(value="createCallNode(cachedFunctionCode)") DirectCallNode callNode) {
        return callNode.call(arguments);
    }

    @Specialization(replaces={"doDirectCodeFast", "doDirectCode"}, guards={"descriptor.getFunctionCode().isLLVMIRFunction()"})
    protected static Object doIndirect(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached LLVMFunctionCode.ResolveFunctionNode resolve, @Cached(value="create()") IndirectCallNode callNode) {
        return callNode.call((CallTarget)descriptor.getFunctionCode().getLLVMIRFunction(resolve), arguments);
    }

    @Specialization(replaces={"doDirectCodeFast", "doDirectCode"}, guards={"descriptor.getFunctionCode().isIntrinsicFunction(resolve)"})
    protected Object doIndirectIntrinsic(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached LLVMFunctionCode.ResolveFunctionNode resolve, @Cached(value="create()") IndirectCallNode callNode) {
        RootCallTarget intrinsicCallTarget;
        if (this.aotFixedIntrinsicFunction != null && this.aotFixedIntrinsicFunction.getFixedCodeAssumption().isValid()) {
            intrinsicCallTarget = this.aotFixedIntrinsicFunction.getFixedCode().getIntrinsic(resolve).cachedCallTarget(this.type);
        } else {
            LLVMFunctionCode.Intrinsic intrinsic = descriptor.getFunctionCode().getIntrinsic(resolve);
            intrinsicCallTarget = this.aot ? intrinsic.cachedCallTargetSlowPath(this.type) : intrinsic.cachedCallTarget(this.type);
        }
        return callNode.call((CallTarget)intrinsicCallTarget, arguments);
    }

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"descriptor == cachedDescriptor", "cachedFunctionCode.isNativeFunctionSlowPath()", "haveNativeCtxExt()", "isSingleContext($node)"})
    @GenerateAOT.Exclude
    protected Object doCachedNativeFunction(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached(value="descriptor") LLVMFunctionDescriptor cachedDescriptor, @Cached(value="cachedDescriptor.getFunctionCode()") LLVMFunctionCode cachedFunctionCode, @Cached(value="createToNativeNodes()") LLVMNativeConvertNode[] toNative, @Cached(value="createFromNativeNode()") LLVMNativeConvertNode fromNative, @Cached(value="bindSymbol(cachedFunctionCode)") Object cachedBoundFunction, @CachedLibrary(value="cachedBoundFunction") InteropLibrary nativeCall, @Cached(value="nativeCallStatisticsEnabled()") boolean statistics) {
        Object[] nativeArgs = LLVMDispatchNode.prepareNativeArguments(arguments, toNative);
        Object returnValue = LLVMNativeCallUtils.callNativeFunction(statistics, nativeCall, cachedBoundFunction, nativeArgs, cachedDescriptor);
        return fromNative.executeConvert(returnValue);
    }

    @Specialization(replaces={"doCachedNativeFunction"}, guards={"descriptor.getFunctionCode() == cachedFunctionCode", "cachedFunctionCode.isNativeFunctionSlowPath()", "isSingleContext($node)"})
    @GenerateAOT.Exclude
    protected Object doCachedNativeCode(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached(value="descriptor.getFunctionCode()") LLVMFunctionCode cachedFunctionCode, @Cached(value="createToNativeNodes()") LLVMNativeConvertNode[] toNative, @Cached(value="createFromNativeNode()") LLVMNativeConvertNode fromNative, @Cached(value="bindSymbol(cachedFunctionCode)") Object cachedBoundFunction, @CachedLibrary(value="cachedBoundFunction") InteropLibrary nativeCall, @Cached(value="nativeCallStatisticsEnabled()") boolean statistics) {
        Object[] nativeArgs = LLVMDispatchNode.prepareNativeArguments(arguments, toNative);
        Object returnValue = LLVMNativeCallUtils.callNativeFunction(statistics, nativeCall, cachedBoundFunction, nativeArgs, descriptor);
        return fromNative.executeConvert(returnValue);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object doBind(NativeContextExtension ctxExt, LLVMFunctionCode functionCode, Source signatureSource) {
        return ctxExt.bindSignature(functionCode, signatureSource);
    }

    protected final Object bindSymbol(LLVMFunctionCode functionCode) {
        assert (functionCode.getNativeFunctionSlowPath() != null) : functionCode.getLLVMFunction().getName();
        return LLVMDispatchNode.doBind(this.getNativeCtxExt(), functionCode, this.getSignatureSource());
    }

    @Specialization(replaces={"doCachedNativeCode"}, guards={"descriptor.getFunctionCode().isNativeFunction(resolve)", "haveNativeCtxExt()"})
    @GenerateAOT.Exclude
    protected Object doNative(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached(value="createToNativeNodes()") LLVMNativeConvertNode[] toNative, @Cached(value="createFromNativeNode()") LLVMNativeConvertNode fromNative, @CachedLibrary(limit="3") InteropLibrary interop, @Cached LLVMFunctionCode.ResolveFunctionNode resolve, @Cached(value="nativeCallStatisticsEnabled()") boolean statistics) {
        Object[] nativeArgs = LLVMDispatchNode.prepareNativeArguments(arguments, toNative);
        Object boundSymbol = this.bindSymbol(descriptor.getFunctionCode());
        Object returnValue = LLVMNativeCallUtils.callNativeFunction(statistics, interop, boundSymbol, nativeArgs, descriptor);
        return fromNative.executeConvert(returnValue);
    }

    boolean isPointerReturnType() {
        return this.type.getReturnType() instanceof PointerType;
    }

    @Specialization(guards={"signatureSource != null", "descriptor.getFunctionCode().isNativeFunction(resolve)"})
    protected Object doNativeAOT(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached(value="createToNativeNodes()") LLVMNativeConvertNode[] toNative, @Cached(value="createFromNativeNode()") LLVMNativeConvertNode fromNative, @Cached(value="isPointerReturnType()") boolean isPointerReturnType, @CachedLibrary(limit="1") SignatureLibrary signatureLibrary, @CachedLibrary(limit="1") NativePointerLibrary nativePointerLibrary, @Cached LLVMFunctionCode.ResolveFunctionNode resolve) {
        try {
            Object signature = this.getNativeCtxExt().createSignature(this.signatureSource);
            Object nativeFunction = descriptor.getFunctionCode().getNativeFunction(resolve);
            Object[] nativeArgs = LLVMDispatchNode.prepareNativeArguments(arguments, toNative);
            Object returnValue = signatureLibrary.call(signature, nativeFunction, nativeArgs);
            if (isPointerReturnType && nativePointerLibrary.isPointer(returnValue)) {
                returnValue = nativePointerLibrary.asPointer(returnValue);
            }
            return fromNative.executeConvert(returnValue);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @ExplodeLoop
    private static Object[] prepareNativeArguments(Object[] arguments, LLVMNativeConvertNode[] toNative) {
        Object[] nativeArgs = new Object[arguments.length - 1];
        for (int i = 1; i < arguments.length; ++i) {
            nativeArgs[i - 1] = toNative[i - 1].executeConvert(arguments[i]);
        }
        return nativeArgs;
    }

    protected LLVMNativeConvertNode[] createToNativeNodes() {
        LLVMNativeConvertNode[] ret = new LLVMNativeConvertNode[this.type.getNumberOfArguments() - 1];
        for (int i = 1; i < this.type.getNumberOfArguments(); ++i) {
            ret[i - 1] = LLVMNativeConvertNode.createToNative(this.type.getArgumentType(i));
        }
        return ret;
    }

    protected LLVMNativeConvertNode createFromNativeNode() {
        CompilerAsserts.neverPartOfCompilation();
        return LLVMNativeConvertNode.createFromNative(this.type.getReturnType());
    }

    @Specialization(guards={"foreigns.isForeign(receiver)", "interopLibrary.isExecutable(foreignFunction)"})
    @GenerateAOT.Exclude
    protected Object doForeignExecutable(Object receiver, Object[] arguments, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") NativeTypeLibrary natives, @CachedLibrary(limit="3") InteropLibrary interopLibrary, @Bind(value="foreigns.asForeign(receiver)") Object foreignFunction, @Cached(value="create(type)") LLVMLookupDispatchForeignNode lookupDispatchForeignNode) {
        return lookupDispatchForeignNode.execute(foreignFunction, natives.getNativeType(receiver), arguments);
    }

    @Specialization(guards={"foreigns.isForeign(receiver)", "!interopLibrary.isExecutable(foreignFunction)", "interopLibrary.isPointer(foreignFunction)"})
    @GenerateAOT.Exclude
    protected Object doForeignPointer(Object receiver, Object[] arguments, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interopLibrary, @Bind(value="foreigns.asForeign(receiver)") Object foreignFunction, @Cached(value="createCachedNativeDispatch()") LLVMNativeDispatchNode dispatchNode, @Cached BranchProfile exception) {
        try {
            return dispatchNode.executeDispatch(LLVMNativePointer.create(interopLibrary.asPointer(foreignFunction)), arguments);
        }
        catch (UnsupportedMessageException | IllegalStateException e) {
            exception.enter();
            throw new LLVMNativePointerException(dispatchNode, "Invalid native function pointer", e);
        }
    }

    @Specialization(guards={"haveNativeCtxExt()"})
    @GenerateAOT.Exclude
    protected static Object doNativeFunction(LLVMNativePointer pointer, Object[] arguments, @Cached(value="createCachedNativeDispatch()") LLVMNativeDispatchNode dispatchNode, @Cached BranchProfile exception) {
        try {
            return dispatchNode.executeDispatch(pointer, arguments);
        }
        catch (IllegalStateException e) {
            exception.enter();
            throw new LLVMNativePointerException(dispatchNode, "Invalid native function pointer", e);
        }
    }

    @Specialization(guards={"!haveNativeCtxExt()"})
    @GenerateAOT.Exclude
    protected Object doInvalidNativeFunction(LLVMNativePointer pointer, Object[] arguments) {
        throw new LLVMNativePointerException(this, "Invalid native function pointer", null);
    }

    protected LLVMNativeDispatchNode createCachedNativeDispatch() {
        return LLVMNativeDispatchNodeGen.create(this.type, this.getSignatureSource());
    }

    static abstract class LLVMLookupDispatchForeignNode
    extends LLVMNode {
        private final boolean isVoidReturn;
        private final int argumentCount;
        private final FunctionType type;

        LLVMLookupDispatchForeignNode(FunctionType type) {
            this.type = type;
            this.isVoidReturn = type.getReturnType() instanceof VoidType;
            this.argumentCount = type.getNumberOfArguments();
        }

        abstract Object execute(Object var1, Object var2, Object[] var3);

        @Specialization(guards={"functionType == cachedType"}, limit="5")
        @GenerateAOT.Exclude
        protected Object doCachedType(Object function, LLVMInteropType.Function functionType, Object[] arguments, @Cached(value="functionType") LLVMInteropType.Function cachedType, @CachedLibrary(value="function") InteropLibrary crossLanguageCall, @Cached(value="createLLVMDataEscapeNodes()") LLVMDataEscapeNode[] dataEscapeNodes, @Cached(value="createToLLVMNode()") ForeignToLLVM toLLVMNode, @Cached BranchProfile exception) {
            return this.doGeneric(function, cachedType, arguments, crossLanguageCall, dataEscapeNodes, toLLVMNode, exception);
        }

        @Specialization(replaces={"doCachedType"}, limit="0")
        @GenerateAOT.Exclude
        protected Object doGeneric(Object function, LLVMInteropType.Function functionType, Object[] arguments, @CachedLibrary(value="function") InteropLibrary crossLanguageCall, @Cached(value="createLLVMDataEscapeNodes()") LLVMDataEscapeNode[] dataEscapeNodes, @Cached(value="createToLLVMNode()") ForeignToLLVM toLLVMNode, @Cached BranchProfile exception) {
            try {
                Object[] args = this.getForeignArguments(dataEscapeNodes, arguments, functionType, exception);
                Object ret = crossLanguageCall.execute(function, args);
                if (!this.isVoidReturn && functionType != null) {
                    LLVMInteropType retType = functionType.getReturnType();
                    if (retType instanceof LLVMInteropType.Value) {
                        return toLLVMNode.executeWithType(ret, ((LLVMInteropType.Value)retType).baseType);
                    }
                    exception.enter();
                    throw new LLVMPolyglotException(this, "Cannot call polyglot function with structured return type.");
                }
                return toLLVMNode.executeWithTarget(ret);
            }
            catch (InteropException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        boolean isNotFunctionType(Object functionType) {
            return !(functionType instanceof LLVMInteropType.Function);
        }

        @Specialization(guards={"isNotFunctionType(functionType)"}, limit="5")
        @GenerateAOT.Exclude
        protected Object doUnknownType(Object function, Object functionType, Object[] arguments, @CachedLibrary(value="function") InteropLibrary crossLanguageCall, @Cached(value="createLLVMDataEscapeNodes()") LLVMDataEscapeNode[] dataEscapeNodes, @Cached(value="createToLLVMNode()") ForeignToLLVM toLLVMNode, @Cached BranchProfile exception) {
            return this.doGeneric(function, null, arguments, crossLanguageCall, dataEscapeNodes, toLLVMNode, exception);
        }

        @ExplodeLoop
        private Object[] getForeignArguments(LLVMDataEscapeNode[] dataEscapeNodes, Object[] arguments, LLVMInteropType.Function functionType, BranchProfile exception) {
            int i;
            assert (arguments.length == this.argumentCount);
            Object[] args = new Object[dataEscapeNodes.length];
            if (functionType != null) {
                assert (arguments.length == functionType.getNumberOfParameters() + 1);
                for (i = 0; i < functionType.getNumberOfParameters(); ++i) {
                    LLVMInteropType argType = functionType.getParameter(i);
                    if (!(argType instanceof LLVMInteropType.Value)) {
                        exception.enter();
                        throw new LLVMPolyglotException(this, "Cannot call polyglot function with structured argument type.");
                    }
                    LLVMInteropType.Structured baseType = ((LLVMInteropType.Value)argType).baseType;
                    args[i] = dataEscapeNodes[i].executeWithType(arguments[i + 1], baseType);
                }
            }
            while (i < args.length) {
                args[i] = dataEscapeNodes[i].executeWithTarget(arguments[i + 1]);
                ++i;
            }
            return args;
        }

        protected ForeignToLLVM createToLLVMNode() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.convert(this.type.getReturnType()));
        }

        protected LLVMDataEscapeNode[] createLLVMDataEscapeNodes() {
            CompilerAsserts.neverPartOfCompilation();
            LLVMDataEscapeNode[] args = new LLVMDataEscapeNode[this.type.getNumberOfArguments() - 1];
            for (int i = 0; i < args.length; ++i) {
                args[i] = LLVMDataEscapeNode.create(this.type.getArgumentType(i + 1));
            }
            return args;
        }

        public static LLVMLookupDispatchForeignNode create(FunctionType type) {
            return LLVMDispatchNodeGen.LLVMLookupDispatchForeignNodeGen.create(type);
        }
    }
}

