/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.LLVMUniquesRegionAllocNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMFrameNullerUtil;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMDispatchBasicBlockNode;

public abstract class LLVMFunctionRootNode
extends LLVMExpressionNode {
    @Node.Children
    private final LLVMStatementNode[] copyArgumentsToFrame;
    @Node.Child
    private LLVMUniquesRegionAllocNode uniquesRegionAllocNode;
    @Node.Child
    private LLVMExpressionNode rootBody;
    private final int frameSlotsToInitialize;
    private final LLVMStack.LLVMStackAccess stackAccess;

    public LLVMFunctionRootNode(LLVMUniquesRegionAllocNode uniquesRegionAllocNode, LLVMStack.LLVMStackAccess stackAccess, LLVMStatementNode[] copyArgumentsToFrame, LLVMDispatchBasicBlockNode rootBody, FrameDescriptor frameDescriptor) {
        this.uniquesRegionAllocNode = uniquesRegionAllocNode;
        this.stackAccess = stackAccess;
        this.copyArgumentsToFrame = copyArgumentsToFrame;
        this.rootBody = rootBody;
        this.frameSlotsToInitialize = frameDescriptor.getNumberOfSlots();
    }

    @ExplodeLoop
    private void copyArgumentsToFrame(VirtualFrame frame) {
        for (LLVMStatementNode n : this.copyArgumentsToFrame) {
            n.execute(frame);
        }
    }

    @Specialization
    public Object doRun(VirtualFrame frame) {
        this.nullStack(frame);
        this.stackAccess.executeEnter(frame);
        try {
            this.copyArgumentsToFrame(frame);
            if (this.uniquesRegionAllocNode != null) {
                this.uniquesRegionAllocNode.execute(frame);
            }
            Object object = this.rootBody.executeGeneric(frame);
            return object;
        }
        finally {
            this.stackAccess.executeExit(frame);
        }
    }

    @ExplodeLoop
    private void nullStack(VirtualFrame frame) {
        if (CompilerDirectives.inInterpreter()) {
            return;
        }
        for (int frameSlot = 0; frameSlot < this.frameSlotsToInitialize; ++frameSlot) {
            LLVMFrameNullerUtil.nullFrameSlot(frame, frameSlot);
        }
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.StatementTag.class) {
            return false;
        }
        if (tag == StandardTags.RootTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }
}

