/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToVectorNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMToVectorNode.class)
public final class LLVMToVectorNodeFactory {

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToDoubleVectorNode.class)
    public static final class LLVMBitcastToDoubleVectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToDoubleVectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMBitcastToDoubleVectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3FC) == 0 && (state_0 & 0x3FE) != 0) {
                return this.executeGeneric_long0(state_0, frameValue);
            }
            if ((state_0 & 0x3FA) == 0 && (state_0 & 0x3FE) != 0) {
                return this.executeGeneric_double1(state_0, frameValue);
            }
            return this.executeGeneric_generic2(state_0, frameValue);
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doLong(fromNodeValue_);
        }

        private Object executeGeneric_double1(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x3FE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (Long)fromNodeValue_;
                    return this.doLong(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (Double)fromNodeValue_;
                    return this.doDouble(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloatVector(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64Vector(fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDoubleVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doLong(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doFloatVector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x100;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x200;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3FE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x3FE & (state_0 & 0x3FE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            this.state_0_ |= 0x200;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMBitcastToDoubleVectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToDoubleVectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToFloatVectorNode.class)
    public static final class LLVMBitcastToFloatVectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToFloatVectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMBitcastToFloatVectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3FC) == 0 && (state_0 & 0x3FE) != 0) {
                return this.executeGeneric_int0(state_0, frameValue);
            }
            if ((state_0 & 0x3FA) == 0 && (state_0 & 0x3FE) != 0) {
                return this.executeGeneric_float1(state_0, frameValue);
            }
            return this.executeGeneric_generic2(state_0, frameValue);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doInt(fromNodeValue_);
        }

        private Object executeGeneric_float1(int state_0__, VirtualFrame frameValue) {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
            }
            assert ((state_0 & 4) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x3FE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (Integer)fromNodeValue_;
                    return this.doInt(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                    return this.doFloat(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloatVector(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64Vector(fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDoubleVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMFloatVector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (Integer)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doInt(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                this.state_0_ = state_0 |= 4;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doFloatVector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x100;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x200;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3FE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x3FE & (state_0 & 0x3FE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            this.state_0_ |= 0x200;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMBitcastToFloatVectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToFloatVectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToPointerVectorNode.class)
    public static final class LLVMBitcastToPointerVectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToPointerVectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMBitcastToPointerVectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 2) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                return this.doI64Vector(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMPointerVector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI64Vector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMBitcastToPointerVectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToPointerVectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToI64VectorNode.class)
    public static final class LLVMBitcastToI64VectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToI64VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMBitcastToI64VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FC) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeGeneric_long0(state_0, frameValue);
            }
            if ((state_0 & 0x1FA) == 0 && (state_0 & 0x1FE) != 0) {
                return this.executeGeneric_double1(state_0, frameValue);
            }
            return this.executeGeneric_generic2(state_0, frameValue);
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_double1(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x1FE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (Double)fromNodeValue_;
                    return this.doDouble(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64Vector(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDoubleVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI64Vector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x100;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x1FE & (state_0 & 0x1FE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMBitcastToI64VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToI64VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToI32VectorNode.class)
    public static final class LLVMBitcastToI32VectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToI32VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMBitcastToI32VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFFC) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_int0(state_0, frameValue);
            }
            if ((state_0 & 0xFFA) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_float1(state_0, frameValue);
            }
            if ((state_0 & 0xFF6) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_long2(state_0, frameValue);
            }
            if ((state_0 & 0xFEE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_double3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_float1(int state_0__, VirtualFrame frameValue) {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
            }
            assert ((state_0 & 4) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_long2(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_double3(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0xFFE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (Integer)fromNodeValue_;
                    return this.doI32(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                    return this.doFloat(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (Double)fromNodeValue_;
                    return this.doDouble(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64Vector(fromNodeValue__);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloatVector(fromNodeValue__);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDoubleVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (Integer)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                this.state_0_ = state_0 |= 4;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x100;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x200;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x400;
                return this.doFloatVector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x800;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xFFE & (state_0 & 0xFFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            this.state_0_ |= 0x200;
            this.state_0_ |= 0x400;
            this.state_0_ |= 0x800;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMBitcastToI32VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToI32VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToI16VectorNode.class)
    public static final class LLVMBitcastToI16VectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToI16VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMBitcastToI16VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FFC) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_short0(state_0, frameValue);
            }
            if ((state_0 & 0x1FFA) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_int1(state_0, frameValue);
            }
            if ((state_0 & 0x1FF6) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_long2(state_0, frameValue);
            }
            if ((state_0 & 0x1FEE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_float3(state_0, frameValue);
            }
            if ((state_0 & 0x1FDE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_double4(state_0, frameValue);
            }
            return this.executeGeneric_generic5(state_0, frameValue);
        }

        private Object executeGeneric_short0(int state_0__, VirtualFrame frameValue) {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int1(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long2(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_float3(int state_0__, VirtualFrame frameValue) {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
            }
            assert ((state_0 & 0x10) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_double4(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x20) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x1FFE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (Short)fromNodeValue_;
                    return this.doI16(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (Integer)fromNodeValue_;
                    return this.doI32(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                    return this.doFloat(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (Double)fromNodeValue_;
                    return this.doDouble(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                    return this.do80BitFloat(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64Vector(fromNodeValue__);
                }
                if ((state_0 & 0x1000) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDoubleVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (Short)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (Integer)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                this.state_0_ = state_0 |= 0x10;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.do80BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x100;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x200;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x400;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x800;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x1000;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x1FFE & (state_0 & 0x1FFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            this.state_0_ |= 0x200;
            this.state_0_ |= 0x400;
            this.state_0_ |= 0x800;
            this.state_0_ |= 0x1000;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMBitcastToI16VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToI16VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToI8VectorNode.class)
    public static final class LLVMBitcastToI8VectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToI8VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMBitcastToI8VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3FFC) == 0 && (state_0 & 0x3FFE) != 0) {
                return this.executeGeneric_byte0(state_0, frameValue);
            }
            if ((state_0 & 0x3FFA) == 0 && (state_0 & 0x3FFE) != 0) {
                return this.executeGeneric_short1(state_0, frameValue);
            }
            if ((state_0 & 0x3FF6) == 0 && (state_0 & 0x3FFE) != 0) {
                return this.executeGeneric_int2(state_0, frameValue);
            }
            if ((state_0 & 0x3FEE) == 0 && (state_0 & 0x3FFE) != 0) {
                return this.executeGeneric_long3(state_0, frameValue);
            }
            if ((state_0 & 0x3FDE) == 0 && (state_0 & 0x3FFE) != 0) {
                return this.executeGeneric_float4(state_0, frameValue);
            }
            if ((state_0 & 0x3FBE) == 0 && (state_0 & 0x3FFE) != 0) {
                return this.executeGeneric_double5(state_0, frameValue);
            }
            return this.executeGeneric_generic6(state_0, frameValue);
        }

        private Object executeGeneric_byte0(int state_0__, VirtualFrame frameValue) {
            byte fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short1(int state_0__, VirtualFrame frameValue) {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int2(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long3(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_float4(int state_0__, VirtualFrame frameValue) {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
            }
            assert ((state_0 & 0x20) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_double5(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x40) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x3FFE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (Byte)fromNodeValue_;
                    return this.doI8(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (Short)fromNodeValue_;
                    return this.doI16(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (Integer)fromNodeValue_;
                    return this.doI32(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                    return this.doFloat(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (Double)fromNodeValue_;
                    return this.doDouble(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                    return this.do80BitFloat(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0x1000) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64Vector(fromNodeValue__);
                }
                if ((state_0 & 0x2000) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDoubleVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (Byte)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (Short)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (Integer)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                this.state_0_ = state_0 |= 0x20;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.do80BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x100;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x200;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x400;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x800;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x1000;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x2000;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3FFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x3FFE & (state_0 & 0x3FFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            this.state_0_ |= 0x200;
            this.state_0_ |= 0x400;
            this.state_0_ |= 0x800;
            this.state_0_ |= 0x1000;
            this.state_0_ |= 0x2000;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMBitcastToI8VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToI8VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMBitcastToI1VectorNode.class)
    public static final class LLVMBitcastToI1VectorNodeGen
    extends LLVMToVectorNode.LLVMBitcastToI1VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMBitcastToI1VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x7FFC) == 0 && (state_0 & 0x7FFE) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            if ((state_0 & 0x7FFA) == 0 && (state_0 & 0x7FFE) != 0) {
                return this.executeGeneric_byte1(state_0, frameValue);
            }
            if ((state_0 & 0x7FF6) == 0 && (state_0 & 0x7FFE) != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0x7FEE) == 0 && (state_0 & 0x7FFE) != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            if ((state_0 & 0x7FDE) == 0 && (state_0 & 0x7FFE) != 0) {
                return this.executeGeneric_long4(state_0, frameValue);
            }
            if ((state_0 & 0x7FBE) == 0 && (state_0 & 0x7FFE) != 0) {
                return this.executeGeneric_float5(state_0, frameValue);
            }
            if ((state_0 & 0x7F7E) == 0 && (state_0 & 0x7FFE) != 0) {
                return this.executeGeneric_double6(state_0, frameValue);
            }
            return this.executeGeneric_generic7(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doI1(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            byte fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x20) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
            }
            assert ((state_0 & 0x40) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x80) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x7FFE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (Boolean)fromNodeValue_;
                    return this.doI1(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (Byte)fromNodeValue_;
                    return this.doI8(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (Short)fromNodeValue_;
                    return this.doI16(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (Integer)fromNodeValue_;
                    return this.doI32(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                    return this.doFloat(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (Double)fromNodeValue_;
                    return this.doDouble(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                    return this.do80BitFloat(fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0x1000) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0x2000) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64Vector(fromNodeValue__);
                }
                if ((state_0 & 0x4000) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDoubleVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI1Vector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (Boolean)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (Byte)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (Short)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (Integer)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                this.state_0_ = state_0 |= 0x40;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                this.state_0_ = state_0 |= 0x100;
                return this.do80BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x200;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x400;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x800;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x1000;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x2000;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x4000;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x7FFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x7FFE & (state_0 & 0x7FFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            this.state_0_ |= 0x200;
            this.state_0_ |= 0x400;
            this.state_0_ |= 0x800;
            this.state_0_ |= 0x1000;
            this.state_0_ |= 0x2000;
            this.state_0_ |= 0x4000;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMBitcastToI1VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMBitcastToI1VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToDoubleVectorNode.class)
    public static final class LLVMSignedCastToDoubleVectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToDoubleVectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMSignedCastToDoubleVectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0xFE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloat(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDouble(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xFE & (state_0 & 0xFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMSignedCastToDoubleVectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToDoubleVectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToFloatVectorNode.class)
    public static final class LLVMSignedCastToFloatVectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToFloatVectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMSignedCastToFloatVectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0xFE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloat(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDouble(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMFloatVector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xFE & (state_0 & 0xFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMSignedCastToFloatVectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToFloatVectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToI64VectorNode.class)
    public static final class LLVMSignedCastToI64VectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToI64VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private LLVMToNativeNode pointer_toNativeNode_;

        private LLVMSignedCastToI64VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x1FE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloat(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDouble(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMPointerVector) {
                    LLVMPointerVector fromNodeValue__ = (LLVMPointerVector)fromNodeValue_;
                    LLVMToNativeNode toNativeNode__ = this.pointer_toNativeNode_;
                    if (toNativeNode__ != null) {
                        return this.doPointer(fromNodeValue__, toNativeNode__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI64Vector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMPointerVector) {
                LLVMPointerVector fromNodeValue_ = (LLVMPointerVector)fromNodeValue;
                LLVMToNativeNode toNativeNode__ = (LLVMToNativeNode)this.insert(LLVMToNativeNodeGen.create());
                Objects.requireNonNull(toNativeNode__, "Specialization 'doPointer(LLVMPointerVector, LLVMToNativeNode)' cache 'toNativeNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.pointer_toNativeNode_ = toNativeNode__;
                this.state_0_ = state_0 |= 0x100;
                return this.doPointer(fromNodeValue_, toNativeNode__);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x1FE & (state_0 & 0x1FE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            LLVMToNativeNode toNativeNode__ = (LLVMToNativeNode)this.insert(LLVMToNativeNodeGen.create());
            Objects.requireNonNull(toNativeNode__, "Specialization 'doPointer(LLVMPointerVector, LLVMToNativeNode)' cache 'toNativeNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.pointer_toNativeNode_ = toNativeNode__;
            assert (NodeUtil.assertRecursion((Node)this.pointer_toNativeNode_, (int)1));
            ((GenerateAOT.Provider)this.pointer_toNativeNode_).prepareForAOT(language, root);
            this.state_0_ |= 0x100;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_toNativeNode_ = null;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMSignedCastToI64VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToI64VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToI32VectorNode.class)
    public static final class LLVMSignedCastToI32VectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToI32VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMSignedCastToI32VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0xFE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloat(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDouble(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xFE & (state_0 & 0xFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMSignedCastToI32VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToI32VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToI16VectorNode.class)
    public static final class LLVMSignedCastToI16VectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToI16VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMSignedCastToI16VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0xFE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloat(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDouble(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xFE & (state_0 & 0xFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMSignedCastToI16VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToI16VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToI8VectorNode.class)
    public static final class LLVMSignedCastToI8VectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToI8VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMSignedCastToI8VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0xFE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloat(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDouble(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xFE & (state_0 & 0xFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMSignedCastToI8VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToI8VectorNodeGen(fromNode, vectorLength);
        }
    }

    @GeneratedBy(value=LLVMToVectorNode.LLVMSignedCastToI1VectorNode.class)
    public static final class LLVMSignedCastToI1VectorNodeGen
    extends LLVMToVectorNode.LLVMSignedCastToI1VectorNode
    implements GenerateAOT.Provider {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMSignedCastToI1VectorNodeGen(LLVMExpressionNode fromNode, int vectorLength) {
            this.vectorLength = vectorLength;
            this.fromNode_ = fromNode;
        }

        @Override
        protected int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0xFE) != 0) {
                if ((state_0 & 2) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloat(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDouble(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMI1Vector executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doDouble(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xFE & (state_0 & 0xFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToVectorNode.LLVMSignedCastToI1VectorNode create(LLVMExpressionNode fromNode, int vectorLength) {
            return new LLVMSignedCastToI1VectorNodeGen(fromNode, vectorLength);
        }
    }
}

