/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.except.LLVMException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI64Node;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValue;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

@NodeChild(value="fromNode", type=LLVMExpressionNode.class)
public abstract class LLVMToI8Node
extends LLVMExpressionNode {
    @Specialization(guards={"isForeignNumber(from, foreigns, interop)"})
    @GenerateAOT.Exclude
    protected byte doManagedPointer(LLVMManagedPointer from, @Cached(value="createForeignToLLVM()") ForeignToLLVM toLLVM, @CachedLibrary(limit="1") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop) {
        return (Byte)toLLVM.executeWithTarget(foreigns.asForeign(from.getObject()));
    }

    @Specialization(rewriteOn={LLVMException.class})
    protected byte doPointer(LLVMPointer from, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative) {
        return (byte)toNative.executeWithTarget(from).asNative();
    }

    @Specialization
    protected byte doFallbackPointerAsComparable(LLVMPointer from, @Cached ToComparableValue toComparableValue) {
        return (byte)toComparableValue.executeWithTarget(from);
    }

    protected ForeignToLLVM createForeignToLLVM() {
        return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.I8);
    }

    protected static boolean isForeignNumber(LLVMManagedPointer pointer, LLVMAsForeignLibrary foreigns, InteropLibrary interop) {
        return foreigns.isForeign(pointer) && interop.isNumber(pointer.getObject());
    }

    public static abstract class LLVMBitcastToI8Node
    extends LLVMToI8Node {
        @Specialization
        protected byte doI8(byte from) {
            return from;
        }

        @Specialization
        protected byte doI1Vector(LLVMI1Vector from) {
            return (byte)LLVMToI64Node.LLVMBitcastToI64Node.castI1Vector(from, 8);
        }

        @Specialization
        protected byte doI8Vector(LLVMI8Vector from) {
            assert (from.getLength() == 1) : "invalid vector size";
            return from.getValue(0);
        }
    }

    public static abstract class LLVMUnsignedCastToI8Node
    extends LLVMToI8Node {
        @Specialization
        protected byte doI1(boolean from) {
            return from ? (byte)1 : 0;
        }

        @Specialization
        protected byte doI8(byte from) {
            return from;
        }

        @Specialization
        protected byte doIVarBit(LLVMIVarBit from) {
            return from.getZeroExtendedByteValue();
        }

        @Specialization
        protected byte doFloat(float from) {
            return (byte)from;
        }

        @Specialization
        protected byte doFloat(double from) {
            return (byte)from;
        }

        @Specialization
        protected byte doLLVM80BitFloat(LLVM80BitFloat from) {
            return from.getByteValue();
        }
    }

    public static abstract class LLVMSignedCastToI8Node
    extends LLVMToI8Node {
        @Specialization
        protected byte doI8(boolean from) {
            return from ? (byte)-1 : 0;
        }

        @Specialization
        protected byte doI8(byte from) {
            return from;
        }

        @Specialization
        protected byte doI8(short from) {
            return (byte)from;
        }

        @Specialization
        protected byte doI8(int from) {
            return (byte)from;
        }

        @Specialization
        protected byte doI8(long from) {
            return (byte)from;
        }

        @Specialization
        protected byte doI8(LLVMIVarBit from) {
            return from.getByteValue();
        }

        @Specialization
        protected byte doI8(float from) {
            return (byte)from;
        }

        @Specialization
        protected byte doI8(double from) {
            return (byte)from;
        }

        @Specialization
        protected byte doI8(LLVM80BitFloat from) {
            return from.getByteValue();
        }
    }
}

