/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import java.nio.ByteOrder;

public abstract class LLVMNativeConvertNode
extends LLVMNode {
    public abstract Object executeConvert(Object var1);

    public static LLVMNativeConvertNode createToNative(Type argType) {
        if (argType instanceof PointerType || argType instanceof FunctionType) {
            return new AddressToNative();
        }
        if (argType instanceof VoidType) {
            return new VoidToNative();
        }
        if (argType instanceof PrimitiveType && ((PrimitiveType)argType).getPrimitiveKind() == PrimitiveType.PrimitiveKind.I64) {
            return new AddressToNative();
        }
        return LLVMNativeConvertNodeFactory.IdNodeGen.create();
    }

    public static LLVMNativeConvertNode createFromNative(Type retType) {
        if (retType instanceof PointerType) {
            return LLVMNativeConvertNodeFactory.NativeToAddressNodeGen.create();
        }
        if (retType instanceof PrimitiveType) {
            switch (((PrimitiveType)retType).getPrimitiveKind()) {
                case I1: {
                    return LLVMNativeConvertNodeFactory.I1FromNativeToLLVMNodeGen.create();
                }
                case X86_FP80: {
                    return LLVMNativeConvertNodeFactory.FP80FromNativeToLLVMNodeGen.create();
                }
                case F128: {
                    return LLVMNativeConvertNodeFactory.FP128FromNativeToLLVMNodeGen.create();
                }
            }
        }
        return LLVMNativeConvertNodeFactory.IdNodeGen.create();
    }

    protected static class AddressToNative
    extends LLVMNativeConvertNode {
        @Node.Child
        LLVMToNativeNode toNative = LLVMToNativeNode.createToNativeWithTarget();

        protected AddressToNative() {
        }

        @Override
        public Object executeConvert(Object arg) {
            return this.toNative.executeWithTarget(arg).asNative();
        }
    }

    protected static class VoidToNative
    extends LLVMNativeConvertNode {
        protected VoidToNative() {
        }

        @Override
        public Object executeConvert(Object arg) {
            assert (LLVMPointer.isInstance(arg) && LLVMPointer.cast(arg).isNull());
            return LLVMNativePointer.createNull();
        }
    }

    protected static abstract class Id
    extends LLVMNativeConvertNode {
        protected Id() {
        }

        @Specialization
        protected Object doConvert(Object arg) {
            return arg;
        }
    }

    protected static abstract class NativeToAddress
    extends LLVMNativeConvertNode {
        protected NativeToAddress() {
        }

        @Specialization
        protected LLVMNativePointer doLong(long pointer) {
            return LLVMNativePointer.create(pointer);
        }

        @Specialization(guards={"interop.isPointer(address)"}, limit="3", rewriteOn={UnsupportedMessageException.class})
        @GenerateAOT.Exclude
        protected LLVMNativePointer doPointer(Object address, @CachedLibrary(value="address") InteropLibrary interop) throws UnsupportedMessageException {
            return LLVMNativePointer.create(interop.asPointer(address));
        }

        @Specialization(guards={"!interop.isPointer(address)"}, limit="3")
        @GenerateAOT.Exclude
        protected LLVMManagedPointer doFunction(Object address, @CachedLibrary(value="address") InteropLibrary interop) {
            return LLVMManagedPointer.create(address);
        }

        @Specialization(limit="3", replaces={"doPointer", "doFunction"})
        @GenerateAOT.Exclude
        protected LLVMPointer doGeneric(Object address, @CachedLibrary(value="address") InteropLibrary interop) {
            if (interop.isPointer(address)) {
                try {
                    return this.doPointer(address, interop);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            return this.doFunction(address, interop);
        }
    }

    static abstract class I1FromNativeToLLVMNode
    extends LLVMNativeConvertNode {
        I1FromNativeToLLVMNode() {
        }

        @Specialization
        protected Object convert(byte value) {
            return value != 0;
        }

        @Specialization
        protected Object convert(boolean value) {
            return value;
        }
    }

    static abstract class FP80FromNativeToLLVMNode
    extends LLVMNativeConvertNode {
        FP80FromNativeToLLVMNode() {
        }

        @Specialization(limit="1")
        @GenerateAOT.Exclude
        protected LLVM80BitFloat convert(Object value, @CachedLibrary(value="value") InteropLibrary interop) {
            try {
                long fraction = interop.readBufferLong(value, ByteOrder.LITTLE_ENDIAN, 0L);
                short expSign = interop.readBufferShort(value, ByteOrder.LITTLE_ENDIAN, 8L);
                return new LLVM80BitFloat(expSign, fraction);
            }
            catch (InvalidBufferOffsetException | UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }
    }

    static abstract class FP128FromNativeToLLVMNode
    extends LLVMNativeConvertNode {
        FP128FromNativeToLLVMNode() {
        }

        @Specialization(limit="1")
        @GenerateAOT.Exclude
        protected LLVM128BitFloat convert(Object value, @CachedLibrary(value="value") InteropLibrary interop) {
            try {
                long fraction = interop.readBufferLong(value, ByteOrder.LITTLE_ENDIAN, 0L);
                long expSign = interop.readBufferLong(value, ByteOrder.LITTLE_ENDIAN, 8L);
                return new LLVM128BitFloat(expSign, fraction);
            }
            catch (InvalidBufferOffsetException | UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }
    }
}

