/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMElemPtrSymbol;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;

public class LLVMThreadLocalSymbol
extends LLVMSymbol {
    private final String name;
    private final LLVMSourceSymbol sourceSymbol;
    public static final LLVMThreadLocalSymbol[] EMPTY = new LLVMThreadLocalSymbol[0];

    public LLVMThreadLocalSymbol(String name, LLVMSourceSymbol sourceSymbol, IDGenerater.BitcodeID bitcodeID, int symbolIndex, boolean exported, boolean externalWeak) {
        super(name, bitcodeID, symbolIndex, exported, externalWeak);
        this.name = name;
        this.sourceSymbol = sourceSymbol;
    }

    public static LLVMThreadLocalSymbol create(String symbolName, LLVMSourceSymbol sourceSymbol, IDGenerater.BitcodeID bitcodeID, int symbolIndex, boolean exported, boolean externalWeak) {
        return new LLVMThreadLocalSymbol(symbolName, sourceSymbol, bitcodeID, symbolIndex, exported, externalWeak);
    }

    public String getSourceName() {
        return this.sourceSymbol != null ? this.sourceSymbol.getName() : this.name;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isGlobalVariable() {
        return false;
    }

    @Override
    public boolean isAlias() {
        return false;
    }

    @Override
    public LLVMFunction asFunction() {
        throw new IllegalStateException("Thread local global " + this.name + " is not a function.");
    }

    @Override
    public LLVMGlobal asGlobalVariable() {
        throw new IllegalStateException("Thread local global " + this.name + " is not a global.");
    }

    @Override
    public boolean isElemPtrExpression() {
        return false;
    }

    @Override
    public boolean isThreadLocalSymbol() {
        return true;
    }

    @Override
    public LLVMElemPtrSymbol asElemPtrExpression() {
        throw new IllegalStateException("Thread local global " + this.name + " is not a GetElementPointer symbol.");
    }

    @Override
    public LLVMThreadLocalSymbol asThreadLocalSymbol() {
        return this;
    }

    public String toString() {
        return "(" + this.sourceSymbol + ")" + this.name;
    }
}

