/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.records;

public enum DwTagRecord {
    DW_TAG_UNKNOWN(-1),
    DW_TAG_ARRAY_TYPE(1),
    DW_TAG_CLASS_TYPE(2),
    DW_TAG_ENTRY_POINT(3),
    DW_TAG_ENUMERATION_TYPE(4),
    DW_TAG_FORMAL_PARAMETER(5),
    DW_TAG_IMPORTED_DECLARATION(8),
    DW_TAG_LABEL(10),
    DW_TAG_LEXICAL_BLOCK(11),
    DW_TAG_MEMBER(13),
    DW_TAG_POINTER_TYPE(15),
    DW_TAG_REFERENCE_TYPE(16),
    DW_TAG_COMPILE_UNIT(17),
    DW_TAG_STRING_TYPE(18),
    DW_TAG_STRUCTURE_TYPE(19),
    DW_TAG_SUBROUTINE_TYPE(21),
    DW_TAG_TYPEDEF(22),
    DW_TAG_UNION_TYPE(23),
    DW_TAG_UNSPECIFIED_PARAMETERS(24),
    DW_TAG_VARIANT(25),
    DW_TAG_COMMON_BLOCK(26),
    DW_TAG_COMMON_INCLUSION(27),
    DW_TAG_INHERITANCE(28),
    DW_TAG_INLINE_SUBROUTINE(29),
    DW_TAG_MODULE(30),
    DW_TAG_PTR_TO_MEMBER_TYPE(31),
    DW_TAG_SET_TYPE(32),
    DW_TAG_SUBRANGE_TYPE(33),
    DW_TAG_WITH_STMT(34),
    DW_TAG_ACCESS_DECLARATION(35),
    DW_TAG_BASE_TYPE(36),
    DW_TAG_CATCH_BLOCK(37),
    DW_TAG_CONST_TYPE(38),
    DW_TAG_CONSTANT(39),
    DW_TAG_ENUMERATOR(40),
    DW_TAG_FILE_TYPE(41),
    DW_TAG_FRIEND(42),
    DW_TAG_NAMELIST(43),
    DW_TAG_NAMELIST_ITEM(44),
    DW_TAG_PACKED_TYPE(45),
    DW_TAG_SUBPROGRAM(46),
    DW_TAG_TEMPLATE_TYPE_PARAMETER(47),
    DW_TAG_TEMPLATE_VALUE_PARAMETER(48),
    DW_TAG_THROWN_TYPE(49),
    DW_TAG_TRY_BLOCK(50),
    DW_TAG_VARIANT_PART(51),
    DW_TAG_VARIABLE(52),
    DW_TAG_VOLATILE_TYPE(53),
    DW_TAG_DWARF_PROCEDURE(54),
    DW_TAG_RESTRICT_TYPE(55),
    DW_TAG_INTERFACE_TYPE(56),
    DW_TAG_NAMESPACE(57),
    DW_TAG_IMPORTED_MODULE(58),
    DW_TAG_CONDITION(63),
    DW_TAG_SHARED_TYPE(64),
    DW_TAG_TYPE_UNIT(65),
    DW_TAG_RVALUE_REFERENCE_TYPE(66),
    DW_TAG_TEMPLATE_ALIAS(67),
    DW_TAG_LO_USER(16512),
    DW_TAG_MIPS_LOOP(16513),
    DW_TAG_FORMAT_LABEL(16641),
    DW_TAG_FUNCTION_TEMPLATE(16642),
    DW_TAG_CLASS_TEMPLATE(16643),
    DW_TAG_GNU_TEMPLATE_TEMPLATE_PARAM(16646),
    DW_TAG_GNU_TEMPLATE_PARAMETER_PACK(16647),
    DW_TAG_GNU_FORMAL_PARAMETER_PACK(16648),
    DW_TAG_APPLE_PROPERTY(16896),
    DW_TAG_HI_USER(65535),
    DW_TAG_AUTO_VARIABLE(256),
    DW_TAG_ARG_VARIABLE(257),
    DW_TAG_RETURN_VARIABLE(258),
    DW_TAG_VECTOR_TYPE(259);

    private static final DwTagRecord[] VALUES;
    private static final long DWARF_CONSTANT_VALUE_MASK = 65535L;
    private static final long DWARF_CONSTANT_VERSION_MASK = -65536L;
    private final int code;

    public static long getDwarfConstant(long code) {
        return code & 0xFFFFL;
    }

    public static DwTagRecord decode(long code) {
        long codePart = DwTagRecord.getDwarfConstant(code);
        for (DwTagRecord cc : VALUES) {
            if (cc.code() != codePart) continue;
            return cc;
        }
        return DW_TAG_UNKNOWN;
    }

    public static boolean isDwarfDescriptor(long val) {
        if (val <= 0L || (val & 0xFFFFFFFFFFFF0000L) == 0L) {
            return false;
        }
        DwTagRecord decoded = DwTagRecord.decode(val);
        switch (decoded) {
            case DW_TAG_UNKNOWN: 
            case DW_TAG_HI_USER: 
            case DW_TAG_LO_USER: {
                return false;
            }
        }
        return true;
    }

    private DwTagRecord(int code) {
        this.code = code;
    }

    public long code() {
        return this.code;
    }

    static {
        VALUES = DwTagRecord.values();
    }
}

