/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants.integer;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.math.BigInteger;

public final class BigIntegerConstant
extends AbstractConstant {
    private final BigInteger value;

    public BigIntegerConstant(Type type, BigInteger value) {
        super(type);
        this.value = value;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public BigInteger getValue() {
        return this.value;
    }

    public String toString() {
        try {
            if (this.getType().getBitSize() == 1L) {
                return BigInteger.ZERO.equals(this.value) ? "false" : "true";
            }
        }
        catch (Type.TypeOverflowException typeOverflowException) {
            // empty catch block
        }
        return this.value.toString();
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        try {
            Type type = this.getType();
            if (Long.compareUnsigned(type.getBitSize(), 64L) <= 0) {
                return CommonNodeFactory.createSimpleConstantNoArray(this.value.longValueExact(), type);
            }
            return CommonNodeFactory.createSimpleConstantNoArray(this.value, type);
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
    }
}

