/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDString;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceFileReference;

public abstract class MDFile
implements MDBaseNode {
    private static final int ARGINDEX_FILENAME = 1;
    private static final int ARGINDEX_DIRECTORY = 2;
    private static final int ARGINDEX_CHECKSUMKIND = 3;
    private static final int ARGINDEX_CHECKSUM = 4;

    private MDFile() {
    }

    public abstract MDBaseNode getMDFile();

    public abstract MDBaseNode getMDDirectory();

    public abstract LLVMSourceFileReference toSourceFileReference();

    public static MDFile create38(long[] args, MetadataValueList md) {
        MDFileImpl file = new MDFileImpl();
        file.file = md.getNullable(args[1], file);
        file.directory = md.getNullable(args[2], file);
        file.checksumKind = (int)args[3];
        file.checksum = md.getNullable(args[4], file);
        return file;
    }

    public static MDFile create32(long[] args, Metadata md) {
        MDFileImpl file = new MDFileImpl();
        file.file = ParseUtil.resolveReference(args, 1, file, md);
        file.directory = ParseUtil.resolveReference(args, 2, file, md);
        file.checksumKind = (int)args[3];
        file.checksum = ParseUtil.resolveReference(args, 4, file, md);
        return file;
    }

    public static MDFile create(MDBaseNode fileNode, MDBaseNode dirNode) {
        return MDFile.create(fileNode, dirNode, 0, MDVoidNode.INSTANCE);
    }

    public static MDFile create(MDBaseNode fileNode, MDBaseNode dirNode, int checksumKind, MDBaseNode checksum) {
        MDFileImpl file = new MDFileImpl();
        file.file = fileNode;
        file.directory = dirNode;
        file.checksumKind = checksumKind;
        file.checksum = checksum;
        return file;
    }

    private static final class MDFileImpl
    extends MDFile
    implements LLVMSourceFileReference {
        private MDBaseNode directory;
        private MDBaseNode file = MDVoidNode.INSTANCE;
        private int checksumKind = 0;
        private MDBaseNode checksum;

        private MDFileImpl() {
            this.directory = MDVoidNode.INSTANCE;
            this.checksum = MDVoidNode.INSTANCE;
        }

        @Override
        public void accept(MetadataVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public MDBaseNode getMDFile() {
            return this.file;
        }

        @Override
        public MDBaseNode getMDDirectory() {
            return this.directory;
        }

        @Override
        public LLVMSourceFileReference toSourceFileReference() {
            return this;
        }

        @Override
        public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
            if (this.file == oldValue) {
                this.file = newValue;
            }
            if (this.directory == oldValue) {
                this.directory = newValue;
            }
            if (this.checksum == oldValue) {
                this.checksum = newValue;
            }
        }

        @Override
        public String getFilename() {
            return MDString.getIfInstance(this.file);
        }

        @Override
        public String getDirectory() {
            return MDString.getIfInstance(this.directory);
        }

        @Override
        public LLVMSourceFileReference.ChecksumKind getChecksumKind() {
            return LLVMSourceFileReference.ChecksumKind.forBitcodeValue(this.checksumKind);
        }

        @Override
        public String getChecksum() {
            return MDString.getIfInstance(this.checksum);
        }
    }
}

