/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.macho;

import com.oracle.truffle.llvm.parser.filereader.ObjectFileReader;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.graalvm.polyglot.io.ByteSequence;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class Xar {
    private final XarHeader header;
    private final List<XarFile> files;
    private final ByteSequence heap;

    public Xar(XarHeader header, List<XarFile> files, ByteSequence heap) {
        this.header = header;
        this.files = files;
        this.heap = heap;
    }

    public XarHeader getHeader() {
        return this.header;
    }

    public ByteSequence getHeap() {
        return this.heap;
    }

    public static Xar create(ByteSequence bytes) {
        ObjectFileReader data = new ObjectFileReader(bytes, false);
        data.getInt();
        XarHeader header = XarHeader.create(data);
        List<XarFile> files = TocParser.parse(data, header);
        ByteSequence heap = data.slice();
        return new Xar(header, files, heap);
    }

    public ByteSequence extractBitcode() {
        XarFile embeddedBitcode = null;
        for (XarFile file : this.files) {
            if (!file.fileType.equals("LTO")) continue;
            if (embeddedBitcode != null) {
                throw new LLVMParserException("More than one Bitcode file in embedded archive!");
            }
            embeddedBitcode = file;
        }
        if (embeddedBitcode == null) {
            return null;
        }
        return this.heap.subSequence((int)embeddedBitcode.offset, (int)(embeddedBitcode.offset + embeddedBitcode.size));
    }

    public static final class XarHeader {
        private final short size;
        private final short version;
        private final long tocComprSize;
        private final long tocUncomprSize;
        private final int checksumAlgo;

        private XarHeader(short size, short version, long tocComprSize, long tocUncomprSize, int checksumAlgo) {
            this.size = size;
            this.version = version;
            this.tocComprSize = tocComprSize;
            this.tocUncomprSize = tocUncomprSize;
            this.checksumAlgo = checksumAlgo;
        }

        public short getSize() {
            return this.size;
        }

        public short getVersion() {
            return this.version;
        }

        public long getTocComprSize() {
            return this.tocComprSize;
        }

        public long getTocUncomprSize() {
            return this.tocUncomprSize;
        }

        public int getChecksumAlgo() {
            return this.checksumAlgo;
        }

        public static XarHeader create(ObjectFileReader data) {
            short size = data.getShort();
            short version = data.getShort();
            long tocComprSize = data.getLong();
            long tocUncomprSize = data.getLong();
            int checksumAlgo = data.getInt();
            return new XarHeader(size, version, tocComprSize, tocUncomprSize, checksumAlgo);
        }
    }

    private static final class TocParser
    extends DefaultHandler {
        private XarFileBuilder fileBuilder = null;
        private String lastTag;
        private List<XarFile> files = new ArrayList<XarFile>();
        private static final SAXParserFactory PARSER_FACTORY = SAXParserFactory.newInstance();

        private TocParser() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("file")) {
                if (this.fileBuilder != null) {
                    throw new LLVMParserException("Only flat xar archives are supported!");
                }
                this.fileBuilder = new XarFileBuilder();
            } else if (this.fileBuilder != null) {
                this.lastTag = qName;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.fileBuilder != null && this.lastTag != null) {
                switch (this.lastTag) {
                    case "name": {
                        this.fileBuilder.name = new String(ch, start, length);
                        break;
                    }
                    case "file-type": {
                        this.fileBuilder.fileType = new String(ch, start, length);
                        break;
                    }
                    case "offset": {
                        this.fileBuilder.offset = Long.parseUnsignedLong(new String(ch, start, length));
                        break;
                    }
                    case "length": {
                        this.fileBuilder.length = Long.parseUnsignedLong(new String(ch, start, length));
                        break;
                    }
                    case "size": {
                        this.fileBuilder.size = Long.parseUnsignedLong(new String(ch, start, length));
                    }
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (qName.equals("file")) {
                if (this.fileBuilder != null) {
                    this.files.add(this.fileBuilder.create());
                }
                this.fileBuilder = null;
            }
            this.lastTag = null;
        }

        private static List<XarFile> parse(ObjectFileReader data, XarHeader header) {
            int comprSize = (int)header.getTocComprSize();
            int uncomprSize = (int)header.getTocUncomprSize();
            byte[] compressedData = new byte[comprSize];
            data.get(compressedData);
            Inflater decompresser = new Inflater();
            decompresser.setInput(compressedData, 0, comprSize);
            byte[] uncompressedData = new byte[uncomprSize];
            try {
                decompresser.inflate(uncompressedData);
            }
            catch (DataFormatException e) {
                throw new LLVMParserException("DataFormatException when decompressing xar table of contents!");
            }
            decompresser.end();
            try {
                XMLReader xmlReader = PARSER_FACTORY.newSAXParser().getXMLReader();
                TocParser parser = new TocParser();
                xmlReader.setContentHandler(parser);
                xmlReader.parse(new InputSource(new ByteArrayInputStream(uncompressedData)));
                return parser.files;
            }
            catch (IOException | ParserConfigurationException | SAXException e1) {
                throw new LLVMParserException("Could not parse xar table of contents xml!");
            }
        }

        static {
            try {
                PARSER_FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                PARSER_FACTORY.setFeature("http://xml.org/sax/features/external-general-entities", false);
                PARSER_FACTORY.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                PARSER_FACTORY.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                PARSER_FACTORY.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                PARSER_FACTORY.setXIncludeAware(false);
                PARSER_FACTORY.setNamespaceAware(false);
            }
            catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private static final class XarFile {
        private final String name;
        private final String fileType;
        private final long offset;
        private final long size;

        XarFile(String name, String fileType, long offset, long size) {
            this.size = size;
            this.offset = offset;
            this.fileType = fileType;
            this.name = name;
        }
    }

    private static final class XarFileBuilder {
        private String name = null;
        private String fileType = null;
        private long offset = -1L;
        private long size = -1L;
        private long length = -1L;

        private XarFileBuilder() {
        }

        private XarFile create() {
            if (this.name == null) {
                throw new LLVMParserException("Missing name tag!");
            }
            if (this.fileType == null) {
                throw new LLVMParserException("Missing file-type tag!");
            }
            if (this.size < 0L) {
                throw new LLVMParserException("Missing size tag!");
            }
            if (this.length < 0L) {
                throw new LLVMParserException("Missing length tag!");
            }
            if (this.length != this.size) {
                throw new LLVMParserException("Length does not match size. (compressed files not supported)");
            }
            return new XarFile(this.name, this.fileType, this.offset, this.size);
        }
    }
}

