/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@CompilerDirectives.ValueType
public final class LLVMI32Vector
extends LLVMVector {
    private final int[] vector;

    public static LLVMI32Vector create(int[] vector) {
        return new LLVMI32Vector(vector);
    }

    private LLVMI32Vector(int[] vector) {
        this.vector = vector;
    }

    public int getValue(int index) {
        return this.vector[index];
    }

    @Override
    public int getLength() {
        return this.vector.length;
    }

    @Override
    public Type getElementType() {
        return PrimitiveType.I32;
    }

    @Override
    public Object getElement(int index) {
        return index >= 0 && index < this.vector.length ? Integer.valueOf(this.vector[index]) : null;
    }
}

