/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.provider.EagerExportProvider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropInvokeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropInvokeNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMResolveForeignClassChainNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMResolveForeignClassChainNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNodeGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotAsDateTimeNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotAsDateTimeNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotNativeBufferInfo;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotNativeBufferInfoFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotReadBuffer;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotReadBufferFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotWriteBuffer;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotWriteBufferFactory;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.CommonPointerLibraries;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Objects;

@GeneratedBy(value=CommonPointerLibraries.class)
public final class CommonPointerLibrariesGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private CommonPointerLibrariesGen() {
    }

    private static void init() {
    }

    static {
        LibraryExport.register(CommonPointerLibraries.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new LLVMManagedWriteLibraryExports(), new LLVMManagedReadLibraryExports()});
    }

    @GeneratedBy(value=CommonPointerLibraries.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMPointerImpl.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == CommonPointerLibraries.class;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                if (arg1Value instanceof LLVMPointerImpl) {
                    LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                    return CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, LLVMAddressEqualsNodeGen.OperationNodeGen.getUncached());
                }
                return CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isDate(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isDate((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.asDate(arg0Value, LLVMPolyglotAsDateTimeNodeFactory.LLVMPolyglotAsDateNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isTime(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isTime((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.asTime(arg0Value, LLVMPolyglotAsDateTimeNodeFactory.LLVMPolyglotAsTimeNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isTimeZone(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isTimeZone((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.asTimeZone(arg0Value, LLVMPolyglotAsDateTimeNodeFactory.LLVMPolyglotAsTimeZoneNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Instant asInstant(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.asInstant(arg0Value, LLVMPolyglotAsDateTimeNodeFactory.LLVMPolyglotAsInstantNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasMembers((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.getMembers(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readMember(arg0Value, arg1Value, LLVMResolveForeignClassChainNodeGen.getUncached(), LLVMForeignGetMemberPointerNodeGen.getUncached(), LLVMForeignReadNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isMemberInvocable(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.invokeMember(arg0Value, arg1Value, arg2Value, LLVMInteropInvokeNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isMemberInsertable((LLVMPointerImpl)receiver, member);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, LLVMResolveForeignClassChainNodeGen.getUncached(), LLVMForeignGetMemberPointerNodeGen.getUncached(), LLVMForeignWriteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasArrayElements((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.getArraySize(arg0Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, LLVMForeignGetIndexPointerNodeGen.getUncached(), LLVMForeignReadNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isArrayElementInsertable((LLVMPointerImpl)receiver, index);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, LLVMForeignGetIndexPointerNodeGen.getUncached(), LLVMForeignWriteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasLanguage((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.getLanguage((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.toDisplayString((LLVMPointerImpl)receiver, allowSideEffects);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.getMetaObject((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasMetaObject((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.identityHashCode((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasBufferElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasBufferElements((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public long getBufferSize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.getBufferSize(arg0Value, LLVMPolyglotNativeBufferInfoFactory.GetBufferSizeNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public byte readBufferByte(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readBufferByte(arg0Value, arg1Value, LLVMPolyglotReadBufferFactory.LLVMPolyglotReadBufferByteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferByte(Object arg0Value_, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeBufferByte(arg0Value, arg1Value, arg2Value, LLVMPolyglotWriteBufferFactory.LLVMPolyglotWriteBufferByteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public short readBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readBufferShort(arg0Value, arg1Value, arg2Value, LLVMPolyglotReadBufferFactory.LLVMPolyglotReadBufferShortNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeBufferShort(arg0Value, arg1Value, arg2Value, arg3Value, LLVMPolyglotWriteBufferFactory.LLVMPolyglotWriteBufferShortNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public int readBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readBufferInt(arg0Value, arg1Value, arg2Value, LLVMPolyglotReadBufferFactory.LLVMPolyglotReadBufferIntNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeBufferInt(arg0Value, arg1Value, arg2Value, arg3Value, LLVMPolyglotWriteBufferFactory.LLVMPolyglotWriteBufferIntNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public long readBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readBufferLong(arg0Value, arg1Value, arg2Value, LLVMPolyglotReadBufferFactory.LLVMPolyglotReadBufferLongNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeBufferLong(arg0Value, arg1Value, arg2Value, arg3Value, LLVMPolyglotWriteBufferFactory.LLVMPolyglotWriteBufferLongNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public float readBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readBufferFloat(arg0Value, arg1Value, arg2Value, LLVMPolyglotReadBufferFactory.LLVMPolyglotReadBufferFloatNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeBufferFloat(arg0Value, arg1Value, arg2Value, arg3Value, LLVMPolyglotWriteBufferFactory.LLVMPolyglotWriteBufferFloatNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public double readBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readBufferDouble(arg0Value, arg1Value, arg2Value, LLVMPolyglotReadBufferFactory.LLVMPolyglotReadBufferDoubleNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeBufferDouble(arg0Value, arg1Value, arg2Value, arg3Value, LLVMPolyglotWriteBufferFactory.LLVMPolyglotWriteBufferDoubleNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isBufferWritable(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isBufferWritable(arg0Value, LLVMPolyglotNativeBufferInfoFactory.IsBufferWritableNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile isObject;
            @Node.Child
            private LLVMResolveForeignClassChainNode getDirectClass;
            @Node.Child
            private LLVMForeignGetMemberPointerNode getMember;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile isArray;
            @Node.Child
            private LLVMForeignGetIndexPointerNode getIndex;
            @Node.Child
            private LLVMAddressEqualsNode.Operation isIdenticalOrUndefined_pointer_equals_;
            @Node.Child
            private LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsDateNode asDateNode__asDate_asDate_;
            @Node.Child
            private LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsTimeNode asTimeNode__asTime_asTime_;
            @Node.Child
            private LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsTimeZoneNode asTimeZoneNode__asTimeZone_asTimeZone_;
            @Node.Child
            private LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsInstantNode asInstantNode__asInstant_inst_;
            @Node.Child
            private LLVMForeignReadNode readMemberNode__readMember_read_;
            @Node.Child
            private InteropLibrary isMemberInvocableNode__isMemberInvocable_interop_;
            @Node.Child
            private InvokeMemberNode_InvokeMemberData invokeMemberNode__invokeMember_cache;
            @Node.Child
            private LLVMForeignWriteNode writeMemberNode__writeMember_write_;
            @Node.Child
            private LLVMForeignReadNode readArrayElementNode__readArrayElement_read_;
            @Node.Child
            private LLVMForeignWriteNode writeArrayElementNode__writeArrayElement_write_;
            @Node.Child
            private LLVMPolyglotNativeBufferInfo.GetBufferSize getBufferSizeNode__getBufferSize_getSize_;
            @Node.Child
            private LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferByteNode readBufferByteNode__readBufferByte_read_;
            @Node.Child
            private LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferByteNode writeBufferByteNode__writeBufferByte_write_;
            @Node.Child
            private LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferShortNode readBufferShortNode__readBufferShort_read_;
            @Node.Child
            private LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferShortNode writeBufferShortNode__writeBufferShort_write_;
            @Node.Child
            private LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferIntNode readBufferIntNode__readBufferInt_read_;
            @Node.Child
            private LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferIntNode writeBufferIntNode__writeBufferInt_write_;
            @Node.Child
            private LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferLongNode readBufferLongNode__readBufferLong_read_;
            @Node.Child
            private LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferLongNode writeBufferLongNode__writeBufferLong_write_;
            @Node.Child
            private LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferFloatNode readBufferFloatNode__readBufferFloat_read_;
            @Node.Child
            private LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferFloatNode writeBufferFloatNode__writeBufferFloat_write_;
            @Node.Child
            private LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferDoubleNode readBufferDoubleNode__readBufferDouble_read_;
            @Node.Child
            private LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferDoubleNode writeBufferDoubleNode__writeBufferDouble_write_;
            @Node.Child
            private LLVMPolyglotNativeBufferInfo.IsBufferWritable isBufferWritableNode__isBufferWritable_isWritable_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == CommonPointerLibraries.class;
            }

            private boolean isIdenticalOrUndefinedFallbackGuard_(int state_0, LLVMPointerImpl arg0Value, Object arg1Value) {
                return (state_0 & 1) != 0 || !(arg1Value instanceof LLVMPointerImpl);
            }

            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        LLVMAddressEqualsNode.Operation equals__ = this.isIdenticalOrUndefined_pointer_equals_;
                        if (equals__ != null) {
                            return CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, equals__);
                        }
                    }
                    if ((state_0 & 2) != 0 && this.isIdenticalOrUndefinedFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            private TriState isIdenticalOrUndefinedAndSpecialize(LLVMPointerImpl arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof LLVMPointerImpl) {
                    LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                    LLVMAddressEqualsNode.Operation equals__ = (LLVMAddressEqualsNode.Operation)this.insert(LLVMAddressEqualsNodeGen.OperationNodeGen.create());
                    Objects.requireNonNull(equals__, "Specialization 'doPointer(LLVMPointerImpl, LLVMPointerImpl, Operation)' cache 'equals' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.isIdenticalOrUndefined_pointer_equals_ = equals__;
                    this.state_0_ = state_0 |= 1;
                    return CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, equals__);
                }
                this.state_0_ = state_0 |= 2;
                return CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public boolean isDate(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isDate((LLVMPointerImpl)receiver);
            }

            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsDateNode asDate__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0 && (asDate__ = this.asDateNode__asDate_asDate_) != null) {
                    return CommonPointerLibraries.asDate(arg0Value, asDate__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asDateNode_AndSpecialize(arg0Value);
            }

            private LocalDate asDateNode_AndSpecialize(LLVMPointerImpl arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsDateNode asDate__ = (LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsDateNode)this.insert(LLVMPolyglotAsDateTimeNodeFactory.LLVMPolyglotAsDateNodeGen.create());
                Objects.requireNonNull(asDate__, "Specialization 'asDate(LLVMPointerImpl, LLVMPolyglotAsDateNode)' cache 'asDate' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.asDateNode__asDate_asDate_ = asDate__;
                this.state_0_ = state_0 |= 4;
                return CommonPointerLibraries.asDate(arg0Value, asDate__);
            }

            public boolean isTime(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isTime((LLVMPointerImpl)receiver);
            }

            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsTimeNode asTime__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 8) != 0 && (asTime__ = this.asTimeNode__asTime_asTime_) != null) {
                    return CommonPointerLibraries.asTime(arg0Value, asTime__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asTimeNode_AndSpecialize(arg0Value);
            }

            private LocalTime asTimeNode_AndSpecialize(LLVMPointerImpl arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsTimeNode asTime__ = (LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsTimeNode)this.insert(LLVMPolyglotAsDateTimeNodeFactory.LLVMPolyglotAsTimeNodeGen.create());
                Objects.requireNonNull(asTime__, "Specialization 'asTime(LLVMPointerImpl, LLVMPolyglotAsTimeNode)' cache 'asTime' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.asTimeNode__asTime_asTime_ = asTime__;
                this.state_0_ = state_0 |= 8;
                return CommonPointerLibraries.asTime(arg0Value, asTime__);
            }

            public boolean isTimeZone(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isTimeZone((LLVMPointerImpl)receiver);
            }

            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsTimeZoneNode asTimeZone__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10) != 0 && (asTimeZone__ = this.asTimeZoneNode__asTimeZone_asTimeZone_) != null) {
                    return CommonPointerLibraries.asTimeZone(arg0Value, asTimeZone__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asTimeZoneNode_AndSpecialize(arg0Value);
            }

            private ZoneId asTimeZoneNode_AndSpecialize(LLVMPointerImpl arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsTimeZoneNode asTimeZone__ = (LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsTimeZoneNode)this.insert(LLVMPolyglotAsDateTimeNodeFactory.LLVMPolyglotAsTimeZoneNodeGen.create());
                Objects.requireNonNull(asTimeZone__, "Specialization 'asTimeZone(LLVMPointerImpl, LLVMPolyglotAsTimeZoneNode)' cache 'asTimeZone' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.asTimeZoneNode__asTimeZone_asTimeZone_ = asTimeZone__;
                this.state_0_ = state_0 |= 0x10;
                return CommonPointerLibraries.asTimeZone(arg0Value, asTimeZone__);
            }

            public Instant asInstant(Object arg0Value_) throws UnsupportedMessageException {
                LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsInstantNode inst__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20) != 0 && (inst__ = this.asInstantNode__asInstant_inst_) != null) {
                    return CommonPointerLibraries.asInstant(arg0Value, inst__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asInstantNode_AndSpecialize(arg0Value);
            }

            private Instant asInstantNode_AndSpecialize(LLVMPointerImpl arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsInstantNode inst__ = (LLVMPolyglotAsDateTimeNode.LLVMPolyglotAsInstantNode)this.insert(LLVMPolyglotAsDateTimeNodeFactory.LLVMPolyglotAsInstantNodeGen.create());
                Objects.requireNonNull(inst__, "Specialization 'asInstant(LLVMPointerImpl, LLVMPolyglotAsInstantNode)' cache 'inst' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.asInstantNode__asInstant_inst_ = inst__;
                this.state_0_ = state_0 |= 0x20;
                return CommonPointerLibraries.asInstant(arg0Value, inst__);
            }

            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasMembers((LLVMPointerImpl)receiver);
            }

            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                ConditionProfile isObject_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40) != 0 && (isObject_ = this.isObject) != null) {
                    return CommonPointerLibraries.getMembers(arg0Value, arg1Value, isObject_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object getMembersNode_AndSpecialize(LLVMPointerImpl arg0Value, boolean arg1Value) throws UnsupportedMessageException {
                ConditionProfile isObject_;
                int state_0 = this.state_0_;
                ConditionProfile isObject__shared = this.isObject;
                if (isObject__shared != null) {
                    isObject_ = isObject__shared;
                } else {
                    isObject_ = ConditionProfile.create();
                    if (isObject_ == null) {
                        throw new IllegalStateException("Specialization 'getMembers(LLVMPointerImpl, boolean, ConditionProfile)' contains a shared cache with name 'isObject' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.isObject == null) {
                    VarHandle.storeStoreFence();
                    this.isObject = isObject_;
                }
                this.state_0_ = state_0 |= 0x40;
                return CommonPointerLibraries.getMembers(arg0Value, arg1Value, isObject_);
            }

            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                ConditionProfile isObject_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x80) != 0 && (isObject_ = this.isObject) != null) {
                    return CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, isObject_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) {
                ConditionProfile isObject_;
                int state_0 = this.state_0_;
                ConditionProfile isObject__shared = this.isObject;
                if (isObject__shared != null) {
                    isObject_ = isObject__shared;
                } else {
                    isObject_ = ConditionProfile.create();
                    if (isObject_ == null) {
                        throw new IllegalStateException("Specialization 'isMemberReadable(LLVMPointerImpl, String, ConditionProfile)' contains a shared cache with name 'isObject' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.isObject == null) {
                    VarHandle.storeStoreFence();
                    this.isObject = isObject_;
                }
                this.state_0_ = state_0 |= 0x80;
                return CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, isObject_);
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                LLVMForeignReadNode read__;
                LLVMForeignGetMemberPointerNode getMember_;
                LLVMResolveForeignClassChainNode getDirectClass_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x100) != 0 && (getDirectClass_ = this.getDirectClass) != null && (getMember_ = this.getMember) != null && (read__ = this.readMemberNode__readMember_read_) != null) {
                    return CommonPointerLibraries.readMember(arg0Value, arg1Value, getDirectClass_, getMember_, read__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                LLVMForeignGetMemberPointerNode getMember_;
                LLVMForeignGetMemberPointerNode getMember__shared;
                LLVMResolveForeignClassChainNode getDirectClass_;
                int state_0 = this.state_0_;
                LLVMResolveForeignClassChainNode getDirectClass__shared = this.getDirectClass;
                if (getDirectClass__shared != null) {
                    getDirectClass_ = getDirectClass__shared;
                } else {
                    getDirectClass_ = (LLVMResolveForeignClassChainNode)this.insert(LLVMResolveForeignClassChainNodeGen.create());
                    if (getDirectClass_ == null) {
                        throw new IllegalStateException("Specialization 'readMember(LLVMPointerImpl, String, LLVMResolveForeignClassChainNode, LLVMForeignGetMemberPointerNode, LLVMForeignReadNode)' contains a shared cache with name 'resolveClassChain' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.getDirectClass == null) {
                    VarHandle.storeStoreFence();
                    this.getDirectClass = getDirectClass_;
                }
                if ((getMember__shared = this.getMember) != null) {
                    getMember_ = getMember__shared;
                } else {
                    getMember_ = (LLVMForeignGetMemberPointerNode)this.insert(LLVMForeignGetMemberPointerNodeGen.create());
                    if (getMember_ == null) {
                        throw new IllegalStateException("Specialization 'readMember(LLVMPointerImpl, String, LLVMResolveForeignClassChainNode, LLVMForeignGetMemberPointerNode, LLVMForeignReadNode)' contains a shared cache with name 'getElementPointer' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.getMember == null) {
                    VarHandle.storeStoreFence();
                    this.getMember = getMember_;
                }
                LLVMForeignReadNode read__ = (LLVMForeignReadNode)this.insert(LLVMForeignReadNodeGen.create());
                Objects.requireNonNull(read__, "Specialization 'readMember(LLVMPointerImpl, String, LLVMResolveForeignClassChainNode, LLVMForeignGetMemberPointerNode, LLVMForeignReadNode)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readMemberNode__readMember_read_ = read__;
                this.state_0_ = state_0 |= 0x100;
                return CommonPointerLibraries.readMember(arg0Value, arg1Value, getDirectClass_, getMember_, read__);
            }

            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                ConditionProfile isObject_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x200) != 0 && (isObject_ = this.isObject) != null) {
                    return CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, isObject_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) {
                ConditionProfile isObject_;
                int state_0 = this.state_0_;
                ConditionProfile isObject__shared = this.isObject;
                if (isObject__shared != null) {
                    isObject_ = isObject__shared;
                } else {
                    isObject_ = ConditionProfile.create();
                    if (isObject_ == null) {
                        throw new IllegalStateException("Specialization 'isMemberModifiable(LLVMPointerImpl, String, ConditionProfile)' contains a shared cache with name 'isObject' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.isObject == null) {
                    VarHandle.storeStoreFence();
                    this.isObject = isObject_;
                }
                this.state_0_ = state_0 |= 0x200;
                return CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, isObject_);
            }

            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                InteropLibrary interop__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x400) != 0 && (interop__ = this.isMemberInvocableNode__isMemberInvocable_interop_) != null) {
                    return CommonPointerLibraries.isMemberInvocable(arg0Value, arg1Value, interop__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                InteropLibrary interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                Objects.requireNonNull(interop__, "Specialization 'isMemberInvocable(LLVMPointerImpl, String, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.isMemberInvocableNode__isMemberInvocable_interop_ = interop__;
                this.state_0_ = state_0 |= 0x400;
                return CommonPointerLibraries.isMemberInvocable(arg0Value, arg1Value, interop__);
            }

            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                InvokeMemberNode_InvokeMemberData s0_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x800) != 0 && (s0_ = this.invokeMemberNode__invokeMember_cache) != null) {
                    return CommonPointerLibraries.invokeMember(arg0Value, arg1Value, arg2Value, s0_.invoke_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                int state_0 = this.state_0_;
                InvokeMemberNode_InvokeMemberData s0_ = (InvokeMemberNode_InvokeMemberData)this.insert(new InvokeMemberNode_InvokeMemberData());
                s0_.invoke_ = (LLVMInteropInvokeNode)s0_.insert(LLVMInteropInvokeNode.create());
                VarHandle.storeStoreFence();
                this.invokeMemberNode__invokeMember_cache = s0_;
                this.state_0_ = state_0 |= 0x800;
                return CommonPointerLibraries.invokeMember(arg0Value, arg1Value, arg2Value, s0_.invoke_);
            }

            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isMemberInsertable((LLVMPointerImpl)receiver, member);
            }

            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                LLVMForeignWriteNode write__;
                LLVMForeignGetMemberPointerNode getMember_;
                LLVMResolveForeignClassChainNode getDirectClass_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1000) != 0 && (getDirectClass_ = this.getDirectClass) != null && (getMember_ = this.getMember) != null && (write__ = this.writeMemberNode__writeMember_write_) != null) {
                    CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, getDirectClass_, getMember_, write__);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeMemberNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                LLVMForeignGetMemberPointerNode getMember_;
                LLVMForeignGetMemberPointerNode getMember__shared;
                LLVMResolveForeignClassChainNode getDirectClass_;
                int state_0 = this.state_0_;
                LLVMResolveForeignClassChainNode getDirectClass__shared = this.getDirectClass;
                if (getDirectClass__shared != null) {
                    getDirectClass_ = getDirectClass__shared;
                } else {
                    getDirectClass_ = (LLVMResolveForeignClassChainNode)this.insert(LLVMResolveForeignClassChainNodeGen.create());
                    if (getDirectClass_ == null) {
                        throw new IllegalStateException("Specialization 'writeMember(LLVMPointerImpl, String, Object, LLVMResolveForeignClassChainNode, LLVMForeignGetMemberPointerNode, LLVMForeignWriteNode)' contains a shared cache with name 'resolveClassChain' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.getDirectClass == null) {
                    VarHandle.storeStoreFence();
                    this.getDirectClass = getDirectClass_;
                }
                if ((getMember__shared = this.getMember) != null) {
                    getMember_ = getMember__shared;
                } else {
                    getMember_ = (LLVMForeignGetMemberPointerNode)this.insert(LLVMForeignGetMemberPointerNodeGen.create());
                    if (getMember_ == null) {
                        throw new IllegalStateException("Specialization 'writeMember(LLVMPointerImpl, String, Object, LLVMResolveForeignClassChainNode, LLVMForeignGetMemberPointerNode, LLVMForeignWriteNode)' contains a shared cache with name 'getElementPointer' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.getMember == null) {
                    VarHandle.storeStoreFence();
                    this.getMember = getMember_;
                }
                LLVMForeignWriteNode write__ = (LLVMForeignWriteNode)this.insert(LLVMForeignWriteNodeGen.create());
                Objects.requireNonNull(write__, "Specialization 'writeMember(LLVMPointerImpl, String, Object, LLVMResolveForeignClassChainNode, LLVMForeignGetMemberPointerNode, LLVMForeignWriteNode)' cache 'write' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.writeMemberNode__writeMember_write_ = write__;
                this.state_0_ = state_0 |= 0x1000;
                CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, getDirectClass_, getMember_, write__);
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasArrayElements((LLVMPointerImpl)receiver);
            }

            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                ConditionProfile isArray_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000) != 0 && (isArray_ = this.isArray) != null) {
                    return CommonPointerLibraries.getArraySize(arg0Value, isArray_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getArraySizeNode_AndSpecialize(arg0Value);
            }

            private long getArraySizeNode_AndSpecialize(LLVMPointerImpl arg0Value) throws UnsupportedMessageException {
                ConditionProfile isArray_;
                int state_0 = this.state_0_;
                ConditionProfile isArray__shared = this.isArray;
                if (isArray__shared != null) {
                    isArray_ = isArray__shared;
                } else {
                    isArray_ = ConditionProfile.create();
                    if (isArray_ == null) {
                        throw new IllegalStateException("Specialization 'getArraySize(LLVMPointerImpl, ConditionProfile)' contains a shared cache with name 'isArray' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.isArray == null) {
                    VarHandle.storeStoreFence();
                    this.isArray = isArray_;
                }
                this.state_0_ = state_0 |= 0x2000;
                return CommonPointerLibraries.getArraySize(arg0Value, isArray_);
            }

            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                ConditionProfile isArray_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x4000) != 0 && (isArray_ = this.isArray) != null) {
                    return CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, isArray_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementReadableNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) {
                ConditionProfile isArray_;
                int state_0 = this.state_0_;
                ConditionProfile isArray__shared = this.isArray;
                if (isArray__shared != null) {
                    isArray_ = isArray__shared;
                } else {
                    isArray_ = ConditionProfile.create();
                    if (isArray_ == null) {
                        throw new IllegalStateException("Specialization 'isArrayElementReadable(LLVMPointerImpl, long, ConditionProfile)' contains a shared cache with name 'isArray' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.isArray == null) {
                    VarHandle.storeStoreFence();
                    this.isArray = isArray_;
                }
                this.state_0_ = state_0 |= 0x4000;
                return CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, isArray_);
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                LLVMForeignReadNode read__;
                LLVMForeignGetIndexPointerNode getIndex_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x8000) != 0 && (getIndex_ = this.getIndex) != null && (read__ = this.readArrayElementNode__readArrayElement_read_) != null) {
                    return CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, getIndex_, read__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readArrayElementNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                LLVMForeignGetIndexPointerNode getIndex_;
                int state_0 = this.state_0_;
                LLVMForeignGetIndexPointerNode getIndex__shared = this.getIndex;
                if (getIndex__shared != null) {
                    getIndex_ = getIndex__shared;
                } else {
                    getIndex_ = (LLVMForeignGetIndexPointerNode)this.insert(LLVMForeignGetIndexPointerNodeGen.create());
                    if (getIndex_ == null) {
                        throw new IllegalStateException("Specialization 'readArrayElement(LLVMPointerImpl, long, LLVMForeignGetIndexPointerNode, LLVMForeignReadNode)' contains a shared cache with name 'getElementPointer' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.getIndex == null) {
                    VarHandle.storeStoreFence();
                    this.getIndex = getIndex_;
                }
                LLVMForeignReadNode read__ = (LLVMForeignReadNode)this.insert(LLVMForeignReadNodeGen.create());
                Objects.requireNonNull(read__, "Specialization 'readArrayElement(LLVMPointerImpl, long, LLVMForeignGetIndexPointerNode, LLVMForeignReadNode)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readArrayElementNode__readArrayElement_read_ = read__;
                this.state_0_ = state_0 |= 0x8000;
                return CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, getIndex_, read__);
            }

            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                ConditionProfile isArray_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10000) != 0 && (isArray_ = this.isArray) != null) {
                    return CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, isArray_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementModifiableNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) {
                ConditionProfile isArray_;
                int state_0 = this.state_0_;
                ConditionProfile isArray__shared = this.isArray;
                if (isArray__shared != null) {
                    isArray_ = isArray__shared;
                } else {
                    isArray_ = ConditionProfile.create();
                    if (isArray_ == null) {
                        throw new IllegalStateException("Specialization 'isArrayElementModifiable(LLVMPointerImpl, long, ConditionProfile)' contains a shared cache with name 'isArray' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.isArray == null) {
                    VarHandle.storeStoreFence();
                    this.isArray = isArray_;
                }
                this.state_0_ = state_0 |= 0x10000;
                return CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, isArray_);
            }

            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isArrayElementInsertable((LLVMPointerImpl)receiver, index);
            }

            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                LLVMForeignWriteNode write__;
                LLVMForeignGetIndexPointerNode getIndex_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20000) != 0 && (getIndex_ = this.getIndex) != null && (write__ = this.writeArrayElementNode__writeArrayElement_write_) != null) {
                    CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, getIndex_, write__);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeArrayElementNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                LLVMForeignGetIndexPointerNode getIndex_;
                int state_0 = this.state_0_;
                LLVMForeignGetIndexPointerNode getIndex__shared = this.getIndex;
                if (getIndex__shared != null) {
                    getIndex_ = getIndex__shared;
                } else {
                    getIndex_ = (LLVMForeignGetIndexPointerNode)this.insert(LLVMForeignGetIndexPointerNodeGen.create());
                    if (getIndex_ == null) {
                        throw new IllegalStateException("Specialization 'writeArrayElement(LLVMPointerImpl, long, Object, LLVMForeignGetIndexPointerNode, LLVMForeignWriteNode)' contains a shared cache with name 'getElementPointer' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.getIndex == null) {
                    VarHandle.storeStoreFence();
                    this.getIndex = getIndex_;
                }
                LLVMForeignWriteNode write__ = (LLVMForeignWriteNode)this.insert(LLVMForeignWriteNodeGen.create());
                Objects.requireNonNull(write__, "Specialization 'writeArrayElement(LLVMPointerImpl, long, Object, LLVMForeignGetIndexPointerNode, LLVMForeignWriteNode)' cache 'write' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.writeArrayElementNode__writeArrayElement_write_ = write__;
                this.state_0_ = state_0 |= 0x20000;
                CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, getIndex_, write__);
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasLanguage((LLVMPointerImpl)receiver);
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.getLanguage((LLVMPointerImpl)receiver);
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.toDisplayString((LLVMPointerImpl)receiver, allowSideEffects);
            }

            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.getMetaObject((LLVMPointerImpl)receiver);
            }

            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasMetaObject((LLVMPointerImpl)receiver);
            }

            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.identityHashCode((LLVMPointerImpl)receiver);
            }

            public boolean hasBufferElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasBufferElements((LLVMPointerImpl)receiver);
            }

            public long getBufferSize(Object arg0Value_) throws UnsupportedMessageException {
                LLVMPolyglotNativeBufferInfo.GetBufferSize getSize__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40000) != 0 && (getSize__ = this.getBufferSizeNode__getBufferSize_getSize_) != null) {
                    return CommonPointerLibraries.getBufferSize(arg0Value, getSize__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getBufferSizeNode_AndSpecialize(arg0Value);
            }

            private long getBufferSizeNode_AndSpecialize(LLVMPointerImpl arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                LLVMPolyglotNativeBufferInfo.GetBufferSize getSize__ = (LLVMPolyglotNativeBufferInfo.GetBufferSize)this.insert(LLVMPolyglotNativeBufferInfoFactory.GetBufferSizeNodeGen.create());
                Objects.requireNonNull(getSize__, "Specialization 'getBufferSize(LLVMPointerImpl, GetBufferSize)' cache 'getSize' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.getBufferSizeNode__getBufferSize_getSize_ = getSize__;
                this.state_0_ = state_0 |= 0x40000;
                return CommonPointerLibraries.getBufferSize(arg0Value, getSize__);
            }

            public byte readBufferByte(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferByteNode read__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x80000) != 0 && (read__ = this.readBufferByteNode__readBufferByte_read_) != null) {
                    return CommonPointerLibraries.readBufferByte(arg0Value, arg1Value, read__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readBufferByteNode_AndSpecialize(arg0Value, arg1Value);
            }

            private byte readBufferByteNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferByteNode read__ = (LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferByteNode)this.insert(LLVMPolyglotReadBufferFactory.LLVMPolyglotReadBufferByteNodeGen.create());
                Objects.requireNonNull(read__, "Specialization 'readBufferByte(LLVMPointerImpl, long, LLVMPolyglotReadBufferByteNode)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readBufferByteNode__readBufferByte_read_ = read__;
                this.state_0_ = state_0 |= 0x80000;
                return CommonPointerLibraries.readBufferByte(arg0Value, arg1Value, read__);
            }

            public void writeBufferByte(Object arg0Value_, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferByteNode write__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x100000) != 0 && (write__ = this.writeBufferByteNode__writeBufferByte_write_) != null) {
                    CommonPointerLibraries.writeBufferByte(arg0Value, arg1Value, arg2Value, write__);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeBufferByteNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeBufferByteNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferByteNode write__ = (LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferByteNode)this.insert(LLVMPolyglotWriteBufferFactory.LLVMPolyglotWriteBufferByteNodeGen.create());
                Objects.requireNonNull(write__, "Specialization 'writeBufferByte(LLVMPointerImpl, long, byte, LLVMPolyglotWriteBufferByteNode)' cache 'write' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.writeBufferByteNode__writeBufferByte_write_ = write__;
                this.state_0_ = state_0 |= 0x100000;
                CommonPointerLibraries.writeBufferByte(arg0Value, arg1Value, arg2Value, write__);
            }

            public short readBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferShortNode read__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x200000) != 0 && (read__ = this.readBufferShortNode__readBufferShort_read_) != null) {
                    return CommonPointerLibraries.readBufferShort(arg0Value, arg1Value, arg2Value, read__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readBufferShortNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private short readBufferShortNode_AndSpecialize(LLVMPointerImpl arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferShortNode read__ = (LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferShortNode)this.insert(LLVMPolyglotReadBufferFactory.LLVMPolyglotReadBufferShortNodeGen.create());
                Objects.requireNonNull(read__, "Specialization 'readBufferShort(LLVMPointerImpl, ByteOrder, long, LLVMPolyglotReadBufferShortNode)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readBufferShortNode__readBufferShort_read_ = read__;
                this.state_0_ = state_0 |= 0x200000;
                return CommonPointerLibraries.readBufferShort(arg0Value, arg1Value, arg2Value, read__);
            }

            public void writeBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferShortNode write__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x400000) != 0 && (write__ = this.writeBufferShortNode__writeBufferShort_write_) != null) {
                    CommonPointerLibraries.writeBufferShort(arg0Value, arg1Value, arg2Value, arg3Value, write__);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeBufferShortNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void writeBufferShortNode_AndSpecialize(LLVMPointerImpl arg0Value, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferShortNode write__ = (LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferShortNode)this.insert(LLVMPolyglotWriteBufferFactory.LLVMPolyglotWriteBufferShortNodeGen.create());
                Objects.requireNonNull(write__, "Specialization 'writeBufferShort(LLVMPointerImpl, ByteOrder, long, short, LLVMPolyglotWriteBufferShortNode)' cache 'write' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.writeBufferShortNode__writeBufferShort_write_ = write__;
                this.state_0_ = state_0 |= 0x400000;
                CommonPointerLibraries.writeBufferShort(arg0Value, arg1Value, arg2Value, arg3Value, write__);
            }

            public int readBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferIntNode read__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x800000) != 0 && (read__ = this.readBufferIntNode__readBufferInt_read_) != null) {
                    return CommonPointerLibraries.readBufferInt(arg0Value, arg1Value, arg2Value, read__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readBufferIntNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private int readBufferIntNode_AndSpecialize(LLVMPointerImpl arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferIntNode read__ = (LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferIntNode)this.insert(LLVMPolyglotReadBufferFactory.LLVMPolyglotReadBufferIntNodeGen.create());
                Objects.requireNonNull(read__, "Specialization 'readBufferInt(LLVMPointerImpl, ByteOrder, long, LLVMPolyglotReadBufferIntNode)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readBufferIntNode__readBufferInt_read_ = read__;
                this.state_0_ = state_0 |= 0x800000;
                return CommonPointerLibraries.readBufferInt(arg0Value, arg1Value, arg2Value, read__);
            }

            public void writeBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferIntNode write__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1000000) != 0 && (write__ = this.writeBufferIntNode__writeBufferInt_write_) != null) {
                    CommonPointerLibraries.writeBufferInt(arg0Value, arg1Value, arg2Value, arg3Value, write__);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeBufferIntNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void writeBufferIntNode_AndSpecialize(LLVMPointerImpl arg0Value, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferIntNode write__ = (LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferIntNode)this.insert(LLVMPolyglotWriteBufferFactory.LLVMPolyglotWriteBufferIntNodeGen.create());
                Objects.requireNonNull(write__, "Specialization 'writeBufferInt(LLVMPointerImpl, ByteOrder, long, int, LLVMPolyglotWriteBufferIntNode)' cache 'write' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.writeBufferIntNode__writeBufferInt_write_ = write__;
                this.state_0_ = state_0 |= 0x1000000;
                CommonPointerLibraries.writeBufferInt(arg0Value, arg1Value, arg2Value, arg3Value, write__);
            }

            public long readBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferLongNode read__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000000) != 0 && (read__ = this.readBufferLongNode__readBufferLong_read_) != null) {
                    return CommonPointerLibraries.readBufferLong(arg0Value, arg1Value, arg2Value, read__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readBufferLongNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private long readBufferLongNode_AndSpecialize(LLVMPointerImpl arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferLongNode read__ = (LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferLongNode)this.insert(LLVMPolyglotReadBufferFactory.LLVMPolyglotReadBufferLongNodeGen.create());
                Objects.requireNonNull(read__, "Specialization 'readBufferLong(LLVMPointerImpl, ByteOrder, long, LLVMPolyglotReadBufferLongNode)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readBufferLongNode__readBufferLong_read_ = read__;
                this.state_0_ = state_0 |= 0x2000000;
                return CommonPointerLibraries.readBufferLong(arg0Value, arg1Value, arg2Value, read__);
            }

            public void writeBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferLongNode write__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x4000000) != 0 && (write__ = this.writeBufferLongNode__writeBufferLong_write_) != null) {
                    CommonPointerLibraries.writeBufferLong(arg0Value, arg1Value, arg2Value, arg3Value, write__);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeBufferLongNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void writeBufferLongNode_AndSpecialize(LLVMPointerImpl arg0Value, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferLongNode write__ = (LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferLongNode)this.insert(LLVMPolyglotWriteBufferFactory.LLVMPolyglotWriteBufferLongNodeGen.create());
                Objects.requireNonNull(write__, "Specialization 'writeBufferLong(LLVMPointerImpl, ByteOrder, long, long, LLVMPolyglotWriteBufferLongNode)' cache 'write' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.writeBufferLongNode__writeBufferLong_write_ = write__;
                this.state_0_ = state_0 |= 0x4000000;
                CommonPointerLibraries.writeBufferLong(arg0Value, arg1Value, arg2Value, arg3Value, write__);
            }

            public float readBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferFloatNode read__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x8000000) != 0 && (read__ = this.readBufferFloatNode__readBufferFloat_read_) != null) {
                    return CommonPointerLibraries.readBufferFloat(arg0Value, arg1Value, arg2Value, read__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readBufferFloatNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private float readBufferFloatNode_AndSpecialize(LLVMPointerImpl arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferFloatNode read__ = (LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferFloatNode)this.insert(LLVMPolyglotReadBufferFactory.LLVMPolyglotReadBufferFloatNodeGen.create());
                Objects.requireNonNull(read__, "Specialization 'readBufferFloat(LLVMPointerImpl, ByteOrder, long, LLVMPolyglotReadBufferFloatNode)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readBufferFloatNode__readBufferFloat_read_ = read__;
                this.state_0_ = state_0 |= 0x8000000;
                return CommonPointerLibraries.readBufferFloat(arg0Value, arg1Value, arg2Value, read__);
            }

            public void writeBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferFloatNode write__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10000000) != 0 && (write__ = this.writeBufferFloatNode__writeBufferFloat_write_) != null) {
                    CommonPointerLibraries.writeBufferFloat(arg0Value, arg1Value, arg2Value, arg3Value, write__);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeBufferFloatNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void writeBufferFloatNode_AndSpecialize(LLVMPointerImpl arg0Value, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferFloatNode write__ = (LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferFloatNode)this.insert(LLVMPolyglotWriteBufferFactory.LLVMPolyglotWriteBufferFloatNodeGen.create());
                Objects.requireNonNull(write__, "Specialization 'writeBufferFloat(LLVMPointerImpl, ByteOrder, long, float, LLVMPolyglotWriteBufferFloatNode)' cache 'write' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.writeBufferFloatNode__writeBufferFloat_write_ = write__;
                this.state_0_ = state_0 |= 0x10000000;
                CommonPointerLibraries.writeBufferFloat(arg0Value, arg1Value, arg2Value, arg3Value, write__);
            }

            public double readBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferDoubleNode read__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20000000) != 0 && (read__ = this.readBufferDoubleNode__readBufferDouble_read_) != null) {
                    return CommonPointerLibraries.readBufferDouble(arg0Value, arg1Value, arg2Value, read__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readBufferDoubleNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private double readBufferDoubleNode_AndSpecialize(LLVMPointerImpl arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferDoubleNode read__ = (LLVMPolyglotReadBuffer.LLVMPolyglotReadBufferDoubleNode)this.insert(LLVMPolyglotReadBufferFactory.LLVMPolyglotReadBufferDoubleNodeGen.create());
                Objects.requireNonNull(read__, "Specialization 'readBufferDouble(LLVMPointerImpl, ByteOrder, long, LLVMPolyglotReadBufferDoubleNode)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.readBufferDoubleNode__readBufferDouble_read_ = read__;
                this.state_0_ = state_0 |= 0x20000000;
                return CommonPointerLibraries.readBufferDouble(arg0Value, arg1Value, arg2Value, read__);
            }

            public void writeBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferDoubleNode write__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40000000) != 0 && (write__ = this.writeBufferDoubleNode__writeBufferDouble_write_) != null) {
                    CommonPointerLibraries.writeBufferDouble(arg0Value, arg1Value, arg2Value, arg3Value, write__);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeBufferDoubleNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void writeBufferDoubleNode_AndSpecialize(LLVMPointerImpl arg0Value, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_0 = this.state_0_;
                LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferDoubleNode write__ = (LLVMPolyglotWriteBuffer.LLVMPolyglotWriteBufferDoubleNode)this.insert(LLVMPolyglotWriteBufferFactory.LLVMPolyglotWriteBufferDoubleNodeGen.create());
                Objects.requireNonNull(write__, "Specialization 'writeBufferDouble(LLVMPointerImpl, ByteOrder, long, double, LLVMPolyglotWriteBufferDoubleNode)' cache 'write' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.writeBufferDoubleNode__writeBufferDouble_write_ = write__;
                this.state_0_ = state_0 |= 0x40000000;
                CommonPointerLibraries.writeBufferDouble(arg0Value, arg1Value, arg2Value, arg3Value, write__);
            }

            public boolean isBufferWritable(Object arg0Value_) throws UnsupportedMessageException {
                LLVMPolyglotNativeBufferInfo.IsBufferWritable isWritable__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & Integer.MIN_VALUE) != 0 && (isWritable__ = this.isBufferWritableNode__isBufferWritable_isWritable_) != null) {
                    return CommonPointerLibraries.isBufferWritable(arg0Value, isWritable__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isBufferWritableNode_AndSpecialize(arg0Value);
            }

            private boolean isBufferWritableNode_AndSpecialize(LLVMPointerImpl arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                LLVMPolyglotNativeBufferInfo.IsBufferWritable isWritable__ = (LLVMPolyglotNativeBufferInfo.IsBufferWritable)this.insert(LLVMPolyglotNativeBufferInfoFactory.IsBufferWritableNodeGen.create());
                Objects.requireNonNull(isWritable__, "Specialization 'isBufferWritable(LLVMPointerImpl, IsBufferWritable)' cache 'isWritable' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.isBufferWritableNode__isBufferWritable_isWritable_ = isWritable__;
                this.state_0_ = state_0 |= Integer.MIN_VALUE;
                return CommonPointerLibraries.isBufferWritable(arg0Value, isWritable__);
            }

            @GeneratedBy(value=CommonPointerLibraries.class)
            @DenyReplace
            private static final class InvokeMemberNode_InvokeMemberData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                LLVMInteropInvokeNode invoke_;

                InvokeMemberNode_InvokeMemberData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=CommonPointerLibraries.class)
    private static final class LLVMManagedWriteLibraryExports
    extends LibraryExport<LLVMManagedWriteLibrary> {
        private LLVMManagedWriteLibraryExports() {
            super(LLVMManagedWriteLibrary.class, LLVMPointerImpl.class, false, true, 1);
        }

        protected LLVMManagedWriteLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMManagedWriteLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl || receiver instanceof LibraryExport);
            return new Cached(receiver);
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMManagedWriteLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == CommonPointerLibraries.class;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isWritable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isWritable((LLVMPointerImpl)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI8(Object receiver, long offset, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI8((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI16(Object receiver, long offset, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI16((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI32(Object receiver, long offset, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI32((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeFloat(Object receiver, long offset, float value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeFloat((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI64(Object receiver, long offset, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI64((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeGenericI64(Object receiver, long offset, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeGenericI64((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeDouble(Object receiver, long offset, double value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeDouble((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writePointer(Object receiver, long offset, LLVMPointer value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writePointer((LLVMPointerImpl)receiver, offset, value);
            }
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        private static final class Cached
        extends LLVMManagedWriteLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == CommonPointerLibraries.class;
            }

            @Override
            public boolean isWritable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isWritable((LLVMPointerImpl)receiver);
            }

            @Override
            public void writeI8(Object receiver, long offset, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI8((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writeI16(Object receiver, long offset, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI16((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writeI32(Object receiver, long offset, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI32((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writeFloat(Object receiver, long offset, float value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeFloat((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writeI64(Object receiver, long offset, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeI64((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writeGenericI64(Object receiver, long offset, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeGenericI64((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writeDouble(Object receiver, long offset, double value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writeDouble((LLVMPointerImpl)receiver, offset, value);
            }

            @Override
            public void writePointer(Object receiver, long offset, LLVMPointer value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CommonPointerLibraries.writePointer((LLVMPointerImpl)receiver, offset, value);
            }
        }
    }

    @GeneratedBy(value=CommonPointerLibraries.class)
    private static final class LLVMManagedReadLibraryExports
    extends LibraryExport<LLVMManagedReadLibrary> {
        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, LLVMPointerImpl.class, false, true, 2);
        }

        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMManagedReadLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl || receiver instanceof LibraryExport);
            return new Cached(receiver);
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == CommonPointerLibraries.class;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isReadable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isReadable((LLVMPointerImpl)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readI8(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI8((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readI16(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI16((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readI32(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI32((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloat(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readFloat((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long readI64(Object receiver, long offset) throws UnexpectedResultException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI64((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDouble(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readDouble((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMPointer readPointer(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readPointer((LLVMPointerImpl)receiver, offset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readGenericI64(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readGenericI64((LLVMPointerImpl)receiver, offset);
            }
        }

        @GeneratedBy(value=CommonPointerLibraries.class)
        private static final class Cached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == CommonPointerLibraries.class;
            }

            @Override
            public boolean isReadable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isReadable((LLVMPointerImpl)receiver);
            }

            @Override
            public byte readI8(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI8((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public short readI16(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI16((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public int readI32(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI32((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public float readFloat(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readFloat((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public long readI64(Object receiver, long offset) throws UnexpectedResultException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readI64((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public double readDouble(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readDouble((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public LLVMPointer readPointer(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readPointer((LLVMPointerImpl)receiver, offset);
            }

            @Override
            public Object readGenericI64(Object receiver, long offset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.readGenericI64((LLVMPointerImpl)receiver, offset);
            }
        }
    }

    @GeneratedBy(value=CommonPointerLibraries.class)
    public static final class LLVMManagedReadLibraryEagerProvider
    implements EagerExportProvider {
        public void ensureRegistered() {
            CommonPointerLibrariesGen.init();
        }

        public String getLibraryClassName() {
            return "com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary";
        }
    }

    @GeneratedBy(value=CommonPointerLibraries.class)
    public static final class LLVMManagedWriteLibraryEagerProvider
    implements EagerExportProvider {
        public void ensureRegistered() {
            CommonPointerLibrariesGen.init();
        }

        public String getLibraryClassName() {
            return "com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary";
        }
    }
}

