/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMIVarBitLoadNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeField(name="bitWidth", type=int.class)
public abstract class LLVMIVarBitLoadNode
extends LLVMLoadNode {
    protected final boolean isRecursive;

    protected LLVMIVarBitLoadNode() {
        this(false);
    }

    protected LLVMIVarBitLoadNode(boolean isRecursive) {
        this.isRecursive = isRecursive;
    }

    public abstract LLVMIVarBit executeWithTarget(LLVMManagedPointer var1);

    public abstract int getBitWidth();

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected LLVMIVarBit doIVarBitNative(LLVMNativePointer addr) {
        return this.getLanguage().getLLVMMemory().getIVarBit(this, addr, this.getBitWidth());
    }

    LLVMIVarBitLoadNode createRecursive() {
        return LLVMIVarBitLoadNodeGen.create(true, null, this.getBitWidth());
    }

    @Specialization(guards={"!isRecursive", "isAutoDerefHandle(addr)"})
    protected LLVMIVarBit doIVarBitDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @Cached(value="createRecursive()") LLVMIVarBitLoadNode load) {
        return load.executeWithTarget(getReceiver.execute(addr));
    }

    @Specialization(limit="3")
    @GenerateAOT.Exclude
    protected LLVMIVarBit doForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        byte[] result = new byte[this.getByteSize()];
        long curOffset = addr.getOffset();
        for (int i = result.length - 1; i >= 0; --i) {
            result[i] = nativeRead.readI8(addr.getObject(), curOffset);
            ++curOffset;
        }
        return LLVMIVarBit.create(this.getBitWidth(), result, this.getBitWidth(), false);
    }

    private int getByteSize() {
        assert (this.getBitWidth() % 8 == 0);
        return this.getBitWidth() / 8;
    }
}

