/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMVarArgCompoundValue;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMStructByValueNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMStructByValueNode.class)
public final class LLVMStructByValueNodeGen
extends LLVMStructByValueNode
implements GenerateAOT.Provider {
    private final long length;
    @Node.Child
    private LLVMExpressionNode source_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMStructByValueNodeGen(LLVMMemMoveNode memMove, LLVMExpressionNode stackAllocationNode, LLVMExpressionNode source, long length) {
        super(memMove, stackAllocationNode);
        this.length = length;
        this.source_ = source;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object sourceValue_ = this.source_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(frameValue, sourceValue_);
        }
        if ((state_0 & 6) != 0) {
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(sourceValue_)) {
                LLVMPointer sourceValue__ = LLVMTypes.asPointer(sourceValue_);
                return this.byValue(frameValue, sourceValue__);
            }
            if ((state_0 & 4) != 0 && sourceValue_ instanceof LLVMVarArgCompoundValue) {
                LLVMVarArgCompoundValue sourceValue__ = (LLVMVarArgCompoundValue)sourceValue_;
                return this.byValue(frameValue, sourceValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, sourceValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object sourceValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(sourceValue)) {
            LLVMPointer sourceValue_ = LLVMTypes.asPointer(sourceValue);
            this.state_0_ = state_0 |= 2;
            return this.byValue(frameValue, sourceValue_);
        }
        if (sourceValue instanceof LLVMVarArgCompoundValue) {
            LLVMVarArgCompoundValue sourceValue_ = (LLVMVarArgCompoundValue)sourceValue;
            this.state_0_ = state_0 |= 4;
            return this.byValue(frameValue, sourceValue_);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.source_}, new Object[]{sourceValue});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 6) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        this.state_0_ |= 4;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMStructByValueNode create(LLVMMemMoveNode memMove, LLVMExpressionNode stackAllocationNode, LLVMExpressionNode source, long length) {
        return new LLVMStructByValueNodeGen(memMove, stackAllocationNode, source, length);
    }
}

