/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.memory.LLVMAllocateNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.AllocateGlobalsBlockNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class AllocateGlobalsBlockNode
extends LLVMNode
implements LLVMAllocateNode {
    private final long size;
    @Node.Child
    LLVMToNativeNode toNative;

    protected AllocateGlobalsBlockNode(long size) {
        this.size = size;
        this.toNative = LLVMToNativeNode.createToNativeWithTarget();
    }

    @Specialization
    @GenerateAOT.Exclude
    public LLVMPointer doDefault(@Bind(value="getContext().getAllocateGlobalsBlockFunction()") Object allocateGlobalsBlock, @CachedLibrary(value="allocateGlobalsBlock") InteropLibrary interop) {
        try {
            Object ret = interop.execute(allocateGlobalsBlock, new Object[]{this.size});
            return this.toNative.executeWithTarget(ret);
        }
        catch (InteropException ex) {
            throw new OutOfMemoryError("could not allocate globals block");
        }
    }

    public static AllocateGlobalsBlockNode create(long size) {
        return AllocateGlobalsBlockNodeGen.create(size);
    }
}

