/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;

public abstract class LLVMPolyglotAsDateTimeNode
extends LLVMNode {
    protected static boolean isInstantPointer(LLVMPointer receiver) {
        return receiver.getExportType() instanceof LLVMInteropType.Instant;
    }

    protected static boolean isTimeInfoPointer(LLVMPointer receiver) {
        return receiver.getExportType() instanceof LLVMInteropType.TimeInfo;
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotAsInstantNode
    extends LLVMPolyglotAsDateTimeNode {
        public abstract Instant execute(LLVMPointer var1) throws UnsupportedMessageException;

        @CompilerDirectives.TruffleBoundary
        private Instant ofEpochSecond(long epochSecond) {
            try {
                return Instant.ofEpochSecond(epochSecond);
            }
            catch (DateTimeException ex) {
                throw new LLVMPolyglotException((Node)this, "Failed to construct instant value from epoch second: %s", ex.toString());
            }
        }

        @Specialization(guards={"isInstantPointer(receiver)"})
        protected Instant asInstant(LLVMPointer receiver, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode load, @Cached BranchProfile exception) throws UnsupportedMessageException {
            try {
                long v = load.executeWithTarget(receiver, 0L);
                return this.ofEpochSecond(v);
            }
            catch (UnexpectedResultException ex) {
                exception.enter();
                throw UnsupportedMessageException.create((Throwable)ex);
            }
        }

        @Fallback
        public Instant unsupported(LLVMPointer receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotAsTimeZoneNode
    extends LLVMPolyglotAsDateTimeNode {
        public static final ZoneId UTC = ZoneId.of("UTC");

        public abstract ZoneId execute(LLVMPointer var1) throws UnsupportedMessageException;

        @Specialization(guards={"isInstantPointer(receiver)"})
        protected ZoneId instantAsZoneId(LLVMPointer receiver) {
            return UTC;
        }

        @Fallback
        public ZoneId unsupported(LLVMPointer receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotAsTimeNode
    extends LLVMPolyglotAsDateTimeNode {
        public abstract LocalTime execute(LLVMPointer var1) throws UnsupportedMessageException;

        @CompilerDirectives.TruffleBoundary
        private LocalTime ofInstant(Instant instant, ZoneId zoneId) {
            try {
                return LocalTime.ofInstant(instant, zoneId);
            }
            catch (DateTimeException ex) {
                throw new LLVMPolyglotException((Node)this, "Failed to convert instant to local time: %s", ex.toString());
            }
        }

        @Specialization(guards={"isInstantPointer(receiver)"})
        protected LocalTime instantAsTime(LLVMPointer receiver, @Cached LLVMPolyglotAsInstantNode instant, @Cached LLVMPolyglotAsTimeZoneNode timeZone) throws UnsupportedMessageException {
            return this.ofInstant(instant.execute(receiver), timeZone.execute(receiver));
        }

        @CompilerDirectives.TruffleBoundary
        private LocalTime ofHourMinSec(int hour, int min, int sec) {
            try {
                return LocalTime.of(hour, min, sec);
            }
            catch (DateTimeException ex) {
                throw new LLVMPolyglotException((Node)this, "Failed to construct local time value: %s", ex.toString());
            }
        }

        @Specialization(guards={"isTimeInfoPointer(receiver)"})
        protected LocalTime timeInfoAsTime(LLVMPointer receiver, @Cached LLVMForeignGetMemberPointerNode getElementPointerHour, @Cached LLVMForeignGetMemberPointerNode getElementPointerMin, @Cached LLVMForeignGetMemberPointerNode getElementPointerSec, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode loadInt, @Cached BranchProfile exception) throws UnsupportedMessageException {
            try {
                LLVMInteropType.TimeInfo ti = (LLVMInteropType.TimeInfo)receiver.getExportType();
                LLVMInteropType.Struct struct = ti.getStruct();
                LLVMPointer hourPtr = getElementPointerHour.execute(struct, receiver, "tm_hour");
                LLVMPointer minPtr = getElementPointerMin.execute(struct, receiver, "tm_min");
                LLVMPointer secPtr = getElementPointerSec.execute(struct, receiver, "tm_sec");
                return this.ofHourMinSec(loadInt.executeWithTarget(hourPtr, 0L), loadInt.executeWithTarget(minPtr, 0L), loadInt.executeWithTarget(secPtr, 0L));
            }
            catch (UnknownIdentifierException ex) {
                exception.enter();
                throw UnsupportedMessageException.create((Throwable)ex);
            }
        }

        @Fallback
        public LocalTime unsupported(LLVMPointer receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @GenerateUncached
    public static abstract class LLVMPolyglotAsDateNode
    extends LLVMPolyglotAsDateTimeNode {
        public abstract LocalDate execute(LLVMPointer var1) throws UnsupportedMessageException;

        @CompilerDirectives.TruffleBoundary
        private LocalDate ofInstant(Instant instant, ZoneId zoneId) {
            try {
                return LocalDate.ofInstant(instant, zoneId);
            }
            catch (DateTimeException ex) {
                throw new LLVMPolyglotException((Node)this, "Failed to convert instant to local date value: %s", ex.toString());
            }
        }

        @Specialization(guards={"isInstantPointer(receiver)"})
        protected LocalDate instantAsDate(LLVMPointer receiver, @Cached LLVMPolyglotAsInstantNode instant, @Cached LLVMPolyglotAsTimeZoneNode timeZone) throws UnsupportedMessageException {
            return this.ofInstant(instant.execute(receiver), timeZone.execute(receiver));
        }

        @CompilerDirectives.TruffleBoundary
        private LocalDate ofYearMonthDay(int year, int month, int day) {
            try {
                return LocalDate.of(year, month, day);
            }
            catch (DateTimeException ex) {
                throw new LLVMPolyglotException((Node)this, "Failed to construct local date value: %s", ex.toString());
            }
        }

        @Specialization(guards={"isTimeInfoPointer(receiver)"})
        protected LocalDate timeInfoAsDate(LLVMPointer receiver, @Cached LLVMForeignGetMemberPointerNode getElementPointerYear, @Cached LLVMForeignGetMemberPointerNode getElementPointerMon, @Cached LLVMForeignGetMemberPointerNode getElementPointerMday, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode loadInt, @Cached BranchProfile exception) throws UnsupportedMessageException {
            try {
                LLVMInteropType.TimeInfo ti = (LLVMInteropType.TimeInfo)receiver.getExportType();
                LLVMInteropType.Struct struct = ti.getStruct();
                LLVMPointer yearPtr = getElementPointerYear.execute(struct, receiver, "tm_year");
                LLVMPointer monPtr = getElementPointerMon.execute(struct, receiver, "tm_mon");
                LLVMPointer mdayPtr = getElementPointerMday.execute(struct, receiver, "tm_mday");
                return this.ofYearMonthDay(loadInt.executeWithTarget(yearPtr, 0L) + 1900, loadInt.executeWithTarget(monPtr, 0L) + 1, loadInt.executeWithTarget(mdayPtr, 0L));
            }
            catch (UnknownIdentifierException ex) {
                exception.enter();
                throw UnsupportedMessageException.create((Throwable)ex);
            }
        }

        @Fallback
        public LocalDate unsupported(LLVMPointer receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }
}

