/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
public abstract class LLVMDLOpen
extends LLVMIntrinsic {
    @Specialization
    protected Object doOp(Object file, int flag, @Cached LLVMReadStringNode readStr) {
        RTLDFlags globalOrLocal = RTLDFlags.RTLD_LOCAL;
        RTLDFlags lazyOrNow = RTLDFlags.RTLD_NOW;
        PlatformCapability sysContextExt = LLVMLanguage.get(this).getCapability(PlatformCapability.class);
        if (sysContextExt.isGlobalDLOpenFlagSet(flag)) {
            globalOrLocal = RTLDFlags.RTLD_GLOBAL;
        }
        if (sysContextExt.isLazyDLOpenFlagSet(flag)) {
            lazyOrNow = RTLDFlags.RTLD_LAZY;
        }
        boolean hasFirstFlag = sysContextExt.isFirstDLOpenFlagSet(flag);
        try {
            return LLVMManagedPointer.create(new LLVMDLHandler(this.loadLibrary(this.getContext(), globalOrLocal, lazyOrNow, hasFirstFlag, flag, file, readStr)));
        }
        catch (RuntimeException e) {
            this.getContext().setDLError(1);
            return LLVMNativePointer.createNull();
        }
    }

    @CompilerDirectives.TruffleBoundary
    protected Object loadLibrary(LLVMContext ctx, RTLDFlags globalOrLocal, RTLDFlags lazyOrNow, boolean hasFirstFlag, int flag, Object file, LLVMReadStringNode readStr) {
        Source source;
        if (file.equals(LLVMNativePointer.createNull())) {
            if (ctx.getMainLibrary() != null && (lazyOrNow.isActive(RTLDFlags.RTLD_LAZY) || hasFirstFlag)) {
                return ctx.getMainLibrary();
            }
            return LLVMNativePointer.createNull();
        }
        String filename = readStr.executeWithTarget(file);
        Path path = Paths.get(filename, new String[0]);
        try {
            if (filename.contains("/")) {
                TruffleFile truffleFile = ctx.getEnv().getInternalTruffleFile(path.toUri());
                source = Source.newBuilder((String)"llvm", (TruffleFile)truffleFile).build();
            } else {
                source = ctx.getMainLibraryLocator().locateSource(ctx, filename, "<source library>");
            }
        }
        catch (IOException e) {
            ctx.setDLError(1);
            throw new IllegalStateException(e);
        }
        CallTarget callTarget = ctx.getEnv().parsePublic(source, new String[]{String.valueOf(flag)});
        return callTarget.call(new Object[]{globalOrLocal});
    }

    public static enum RTLDFlags {
        RTLD_OPEN_DEFAULT,
        RTLD_LAZY,
        RTLD_NOW,
        RTLD_GLOBAL,
        RTLD_LOCAL,
        RTLD_FIRST;


        public boolean isActive(RTLDFlags phase) {
            return phase == this;
        }
    }

    @ExportLibrary.Repeat(value={@ExportLibrary(value=LLVMAsForeignLibrary.class, useForAOT=true, useForAOTPriority=1), @ExportLibrary(value=InteropLibrary.class)})
    protected static final class LLVMDLHandler
    implements TruffleObject {
        final Object library;

        private LLVMDLHandler(Object library) {
            this.library = library;
        }

        @ExportMessage
        public boolean isForeign() {
            return true;
        }

        @ExportMessage
        public Object asForeign() {
            return this.library;
        }

        public Object getLibrary() {
            return this.library;
        }

        @ExportMessage
        boolean isPointer(@CachedLibrary(value="this.library") InteropLibrary interop) {
            return interop.isPointer(this.library);
        }

        @ExportMessage
        long asPointer(@CachedLibrary(value="this.library") InteropLibrary interop) throws UnsupportedMessageException {
            return interop.asPointer(this.library);
        }

        @ExportMessage
        void toNative(@CachedLibrary(value="this.library") InteropLibrary interop) {
            interop.toNative(this.library);
        }
    }
}

