/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.global;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=LLVMManagedReadLibrary.class, useForAOT=true, useForAOTPriority=1), @ExportLibrary(value=LLVMManagedWriteLibrary.class, useForAOT=true, useForAOTPriority=2), @ExportLibrary(value=LLVMAsForeignLibrary.class, useForAOT=true, useForAOTPriority=3)})
public final class LLVMGlobalContainer
extends LLVMInternalTruffleObject {
    private static final int MAX_INVALIDATING_WRITES = 3;
    private long address;
    private volatile NativizedState nativizedState = NativizedState.Managed;
    @CompilerDirectives.CompilationFinal
    private State contents;
    private Object fallbackContents = 0L;

    public LLVMGlobalContainer() {
        State state;
        this.contents = state = new State(0L, 0);
    }

    public Object get() {
        while (true) {
            State c = this.contents;
            if (c.assumption.isValid()) {
                return c.value;
            }
            if (c.writeCount == 3) {
                return this.fallbackContents;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
    }

    public Object getFallback() {
        return this.fallbackContents;
    }

    public void set(Object value) {
        assert (value != null);
        while (true) {
            State c = this.contents;
            if (c.assumption.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (c.writeCount < 3) {
                    State state;
                    this.contents = state = new State(value, c.writeCount + 1);
                    c.assumption.invalidate();
                    break;
                }
                c.assumption.invalidate();
                break;
            }
            if (c.writeCount == 3) break;
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
        this.setFallback(value);
    }

    public void setFallback(Object value) {
        this.fallbackContents = value;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void waitForToNative() {
        assert (this.nativizedState != NativizedState.Managed);
    }

    @ExportMessage
    public boolean isPointer() {
        switch (this.nativizedState) {
            case Managed: {
                return false;
            }
            case Conversion: {
                this.waitForToNative();
                return true;
            }
            case Native: {
                return true;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public long asPointer() throws UnsupportedMessageException {
        if (this.isPointer()) {
            return this.address;
        }
        throw UnsupportedMessageException.create();
    }

    public long getAddress() {
        return this.address;
    }

    public int getSize() {
        return 1;
    }

    @ExportMessage
    public void toNative() {
        if (!this.isPointer()) {
            this.doToNative();
        }
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized void doToNative() {
        if (this.nativizedState == NativizedState.Managed) {
            LLVMMemory memory = LLVMLanguage.get(null).getLLVMMemory();
            LLVMNativePointer pointer = memory.allocateMemory(null, 8L);
            this.address = pointer.asNative();
            this.nativizedState = NativizedState.Conversion;
            Object global = this.getFallback();
            long value = global instanceof Number ? ((Number)global).longValue() : LLVMNativePointerSupportFactory.ToNativePointerNodeGen.getUncached().execute(global).asNative();
            memory.putI64((Node)LLVMNativePointerSupportFactory.ToNativePointerNodeGen.getUncached(), pointer, value);
            this.nativizedState = NativizedState.Native;
        }
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isReadable"), @ExportMessage(name="isWritable")})
    boolean isAccessible() {
        return true;
    }

    public void dispose() {
        if (this.address != 0L) {
            LLVMMemory memory = LLVMLanguage.get(null).getLLVMMemory();
            memory.free(null, this.address);
            this.address = 0L;
        }
    }

    @ExportMessage
    public static boolean isForeign(LLVMGlobalContainer receiver) {
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return String.format("LLVMGlobalContainer (address = 0x%x, contents = %s)", this.address, this.contents);
    }

    private static enum NativizedState {
        Managed,
        Conversion,
        Native;

    }

    private static final class State {
        final Object value;
        final Assumption assumption;
        final int writeCount;

        State(Object value, int writeCount) {
            assert (writeCount <= 3);
            this.value = value;
            this.writeCount = writeCount;
            this.assumption = Truffle.getRuntime().createAssumption("LLVM global variable is constant");
        }
    }

    @ExportMessage
    @ImportStatic(value={LLVMLanguage.class})
    static class WriteGenericI64 {
        WriteGenericI64() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, Object value, @Cached.Shared(value="toNative") @Cached LLVMNativePointerSupport.ToNativePointerNode toNative) {
            assert (self.isPointer());
            long ptr = toNative.execute(value).asNative();
            LLVMLanguage.get(toNative).getLLVMMemory().putI64((Node)toNative, self.getAddress() + offset, ptr);
        }

        @Specialization(guards={"isSingleContext($node)", "!self.isPointer()", "offset == 0"})
        static void writeI64ManagedSingleContext(LLVMGlobalContainer self, long offset, Object value) {
            assert (offset == 0L);
            if (CompilerDirectives.isPartialEvaluationConstant((Object)self)) {
                self.set(value);
            } else {
                WriteGenericI64.writeI64ManagedSingleContextBoundary(self, value);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void writeI64ManagedSingleContextBoundary(LLVMGlobalContainer self, Object value) {
            self.set(value);
        }

        @Specialization(guards={"!self.isPointer()", "offset == 0"}, replaces={"writeI64ManagedSingleContext"})
        static void writeI64Managed(LLVMGlobalContainer self, long offset, Object value) {
            assert (offset == 0L);
            self.setFallback(value);
        }

        @Specialization(guards={"!self.isPointer()", "offset != 0"})
        @GenerateAOT.Exclude
        static void writeFallback(LLVMGlobalContainer self, long offset, Object value, @Cached.Shared(value="toNative") @Cached LLVMNativePointerSupport.ToNativePointerNode toNative) {
            self.toNative();
            WriteGenericI64.writeNative(self, offset, value, toNative);
        }
    }

    @ExportMessage
    @ImportStatic(value={LLVMLanguage.class})
    static class WriteI64 {
        WriteI64() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, long value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location) {
            assert (self.isPointer());
            LLVMLanguage.get((Node)location).getLLVMMemory().putI64((Node)location, self.getAddress() + offset, value);
        }

        @Specialization(guards={"isSingleContext($node)", "!self.isPointer()", "offset == 0"})
        static void writeManagedSingleContext(LLVMGlobalContainer self, long offset, long value) {
            assert (offset == 0L);
            if (CompilerDirectives.isPartialEvaluationConstant((Object)self)) {
                self.set(value);
            } else {
                WriteI64.writeManagedSingleContextBoundary(self, value);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void writeManagedSingleContextBoundary(LLVMGlobalContainer self, long value) {
            self.set(value);
        }

        @Specialization(guards={"!self.isPointer()", "offset == 0"}, replaces={"writeManagedSingleContext"})
        static void writeManaged(LLVMGlobalContainer self, long offset, long value) {
            assert (offset == 0L);
            self.setFallback(value);
        }

        @Specialization(guards={"!self.isPointer()", "offset != 0"})
        static void writeFallback(LLVMGlobalContainer self, long offset, long value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location) {
            self.toNative();
            WriteI64.writeNative(self, offset, value, location);
        }
    }

    @ExportMessage
    static class WriteDouble {
        WriteDouble() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, double value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location) {
            assert (self.isPointer());
            LLVMLanguage.get((Node)location).getLLVMMemory().putDouble((Node)location, self.getAddress() + offset, value);
        }

        @Specialization(replaces={"writeNative"})
        static void writeManaged(LLVMGlobalContainer self, long offset, double value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location) {
            self.toNative();
            WriteDouble.writeNative(self, offset, value, location);
        }
    }

    @ExportMessage
    static class WriteFloat {
        WriteFloat() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, float value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location) {
            assert (self.isPointer());
            LLVMLanguage.get((Node)location).getLLVMMemory().putFloat((Node)location, self.getAddress() + offset, value);
        }

        @Specialization(replaces={"writeNative"})
        static void writeManaged(LLVMGlobalContainer self, long offset, float value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location) {
            self.toNative();
            WriteFloat.writeNative(self, offset, value, location);
        }
    }

    @ExportMessage
    static class WriteI32 {
        WriteI32() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, int value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location) {
            assert (self.isPointer());
            LLVMLanguage.get((Node)location).getLLVMMemory().putI32((Node)location, self.getAddress() + offset, value);
        }

        @Specialization(replaces={"writeNative"})
        static void writeManaged(LLVMGlobalContainer self, long offset, int value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location) {
            self.toNative();
            WriteI32.writeNative(self, offset, value, location);
        }
    }

    @ExportMessage
    static class WriteI16 {
        WriteI16() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, short value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location) {
            assert (self.isPointer());
            LLVMLanguage.get((Node)location).getLLVMMemory().putI16((Node)location, self.getAddress() + offset, value);
        }

        @Specialization(replaces={"writeNative"})
        static void writeManaged(LLVMGlobalContainer self, long offset, short value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location) {
            self.toNative();
            WriteI16.writeNative(self, offset, value, location);
        }
    }

    @ExportMessage
    static class WriteI8 {
        WriteI8() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, byte value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location) {
            assert (self.isPointer());
            LLVMLanguage.get((Node)location).getLLVMMemory().putI8((Node)location, self.getAddress() + offset, value);
        }

        @Specialization(replaces={"writeNative"})
        static void writeManaged(LLVMGlobalContainer self, long offset, byte value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location) {
            self.toNative();
            WriteI8.writeNative(self, offset, value, location);
        }
    }

    @ExportMessage
    @ImportStatic(value={LLVMLanguage.class})
    static class ReadPointer {
        ReadPointer() {
        }

        @Specialization(guards={"self.isPointer()"})
        static LLVMPointer readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            assert (self.isPointer());
            return LLVMLanguage.get((Node)location).getLLVMMemory().getPointer((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"isSingleContext($node)", "!self.isPointer()", "offset == 0"})
        static LLVMPointer readManagedSingleContext(LLVMGlobalContainer self, long offset, @Cached.Shared(value="toPointer") @Cached LLVMToPointerNode toPointer) {
            assert (offset == 0L);
            return toPointer.executeWithTarget(self.get());
        }

        @Specialization(guards={"!self.isPointer()", "offset == 0"}, replaces={"readManagedSingleContext"})
        static LLVMPointer readManaged(LLVMGlobalContainer self, long offset, @Cached.Shared(value="toPointer") @Cached LLVMToPointerNode toPointer) {
            assert (offset == 0L);
            return toPointer.executeWithTarget(self.getFallback());
        }

        @Specialization(guards={"!self.isPointer()", "offset != 0"})
        static LLVMPointer readFallback(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.toNative();
            return ReadPointer.readNative(self, offset, location);
        }
    }

    @ExportMessage
    @ImportStatic(value={LLVMLanguage.class})
    static class ReadGenericI64 {
        ReadGenericI64() {
        }

        @Specialization(guards={"self.isPointer()"})
        static long readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            assert (self.isPointer());
            return LLVMLanguage.get((Node)location).getLLVMMemory().getI64((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"isSingleContext($node)", "!self.isPointer()", "offset == 0"})
        static Object readI64ManagedSingleContext(LLVMGlobalContainer self, long offset) {
            assert (offset == 0L);
            return self.get();
        }

        @Specialization(guards={"!self.isPointer()", "offset == 0"}, replaces={"readI64ManagedSingleContext"})
        static Object readI64Managed(LLVMGlobalContainer self, long offset) {
            assert (offset == 0L);
            return self.getFallback();
        }

        @Specialization(guards={"!self.isPointer()", "offset != 0"})
        static Object readFallback(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.toNative();
            return ReadGenericI64.readNative(self, offset, location);
        }
    }

    @ExportMessage
    static class ReadDouble {
        ReadDouble() {
        }

        @Specialization(guards={"self.isPointer()"})
        static double readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            assert (self.isPointer());
            return LLVMLanguage.get((Node)location).getLLVMMemory().getDouble((Node)location, self.getAddress() + offset);
        }

        @Specialization(replaces={"readNative"})
        static double readManaged(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.toNative();
            return ReadDouble.readNative(self, offset, location);
        }
    }

    @ExportMessage
    static class ReadFloat {
        ReadFloat() {
        }

        @Specialization(guards={"self.isPointer()"})
        static float readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            assert (self.isPointer());
            return LLVMLanguage.get((Node)location).getLLVMMemory().getFloat((Node)location, self.getAddress() + offset);
        }

        @Specialization(replaces={"readNative"})
        static float readManaged(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.toNative();
            return ReadFloat.readNative(self, offset, location);
        }
    }

    @ExportMessage
    static class ReadI32 {
        ReadI32() {
        }

        @Specialization(guards={"self.isPointer()"})
        static int readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            assert (self.isPointer());
            return LLVMLanguage.get((Node)location).getLLVMMemory().getI32((Node)location, self.getAddress() + offset);
        }

        @Specialization(replaces={"readNative"})
        static int readManaged(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.toNative();
            return ReadI32.readNative(self, offset, location);
        }
    }

    @ExportMessage
    static class ReadI16 {
        ReadI16() {
        }

        @Specialization(guards={"self.isPointer()"})
        static short readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            assert (self.isPointer());
            return LLVMLanguage.get((Node)location).getLLVMMemory().getI16((Node)location, self.getAddress() + offset);
        }

        @Specialization(replaces={"readNative"})
        static short readManaged(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.toNative();
            return ReadI16.readNative(self, offset, location);
        }
    }

    @ExportMessage
    static class ReadI8 {
        ReadI8() {
        }

        @Specialization(guards={"self.isPointer()"})
        static byte readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            assert (self.isPointer());
            return LLVMLanguage.get((Node)location).getLLVMMemory().getI8((Node)location, self.getAddress() + offset);
        }

        @Specialization(replaces={"readNative"})
        static byte readManaged(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location) {
            self.toNative();
            return ReadI8.readNative(self, offset, location);
        }
    }
}

