/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.scanner;

public enum Block {
    ROOT(-1),
    BLOCKINFO(0),
    MODULE(8),
    PARAMATTR(9),
    PARAMATTR_GROUP(10),
    CONSTANTS(11),
    FUNCTION(12, ParsingStrategy.LAZY),
    IDENTIFICATION(13),
    VALUE_SYMTAB(14),
    METADATA(15),
    METADATA_ATTACHMENT(16),
    TYPE(17),
    USELIST(18, ParsingStrategy.SKIP),
    MODULE_STRTAB(19, ParsingStrategy.SKIP),
    FUNCTION_SUMMARY(20, ParsingStrategy.SKIP),
    OPERAND_BUNDLE_TAGS(21),
    METADATA_KIND(22),
    STRTAB(23),
    FULL_LTO_GLOBALVAR_SUMMARY(24, ParsingStrategy.SKIP),
    SYMTAB(25),
    SYNC_SCOPE_NAMES(26, ParsingStrategy.SKIP);

    private static final Block[] VALUES;
    private final int id;
    private final ParsingStrategy strategy;

    private Block(int id) {
        this(id, ParsingStrategy.EAGER);
    }

    private Block(int id, ParsingStrategy strategy) {
        this.id = id;
        this.strategy = strategy;
    }

    boolean parseLazily() {
        return this.strategy == ParsingStrategy.LAZY;
    }

    boolean skip() {
        return this.strategy == ParsingStrategy.SKIP;
    }

    static Block lookup(long id) {
        for (Block block : VALUES) {
            if ((long)block.id != id) continue;
            return block;
        }
        throw new IllegalStateException("Unknown BlockID: " + id);
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    static {
        VALUES = Block.values();
    }

    static enum ParsingStrategy {
        EAGER,
        LAZY,
        SKIP;

    }
}

