// CheckStyle: start generated
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.js.api.ValueLibrary;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject.IsIdenticalOrUndefined;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject.ToBoolean;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject.ToNumber;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject.ToString;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(JSDynamicObject.class)
@SuppressWarnings({"javadoc", "unused"})
public final class JSDynamicObjectGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(JSDynamicObject.class, new InteropLibraryExports(), new ValueLibraryExports());
    }

    private JSDynamicObjectGen() {
    }

    @GeneratedBy(JSDynamicObject.class)
    public static class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, JSDynamicObject.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof JSDynamicObject;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof JSDynamicObject;
            return new Cached(receiver);
        }

        @GeneratedBy(JSDynamicObject.class)
        public static class Cached extends InteropLibrary {

            private final Class<? extends JSDynamicObject> receiverClass_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IsIdenticalOrUndefined#doHostObject}
             *   1: SpecializationActive {@link IsIdenticalOrUndefined#doOther}
             * </pre> */
            @CompilationFinal private int state_0_;

            protected Cached(Object receiver) {
                JSDynamicObject castReceiver = ((JSDynamicObject) receiver) ;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, JSDynamicObject arg0Value, Object arg1Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[JSDynamicObject.IsIdenticalOrUndefined.doHostObject(JSDynamicObject, JSDynamicObject)] */) && arg1Value instanceof JSDynamicObject) {
                    return false;
                }
                return true;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsIdenticalOrUndefined#doHostObject}
             *     Activation probability: 0.65000
             *     With/without class size: 11/0 bytes
             *   Specialization {@link IsIdenticalOrUndefined#doOther}
             *     Activation probability: 0.35000
             *     With/without class size: 8/0 bytes
             * </pre> */
            @Override
            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                JSDynamicObject arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[JSDynamicObject.IsIdenticalOrUndefined.doHostObject(JSDynamicObject, JSDynamicObject)] || SpecializationActive[JSDynamicObject.IsIdenticalOrUndefined.doOther(JSDynamicObject, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSDynamicObject.IsIdenticalOrUndefined.doHostObject(JSDynamicObject, JSDynamicObject)] */ && arg1Value instanceof JSDynamicObject) {
                        JSDynamicObject arg1Value_ = (JSDynamicObject) arg1Value;
                        return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSDynamicObject.IsIdenticalOrUndefined.doOther(JSDynamicObject, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private TriState executeAndSpecialize(JSDynamicObject arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof JSDynamicObject) {
                    JSDynamicObject arg1Value_ = (JSDynamicObject) arg1Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[JSDynamicObject.IsIdenticalOrUndefined.doHostObject(JSDynamicObject, JSDynamicObject)] */;
                    this.state_0_ = state_0;
                    return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                state_0 = state_0 | 0b10 /* add SpecializationActive[JSDynamicObject.IsIdenticalOrUndefined.doOther(JSDynamicObject, Object)] */;
                this.state_0_ = state_0;
                return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).identityHashCode();
            }

        }
        @GeneratedBy(JSDynamicObject.class)
        public static class Uncached extends InteropLibrary implements UnadoptableNode {

            private final Class<? extends JSDynamicObject> receiverClass_;

            @SuppressWarnings("cast")
            protected Uncached(Object receiver) {
                this.receiverClass_ = ((JSDynamicObject) receiver).getClass();
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @TruffleBoundary
            @Override
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSDynamicObject arg0Value = ((JSDynamicObject) arg0Value_);
                if (arg1Value instanceof JSDynamicObject) {
                    JSDynamicObject arg1Value_ = (JSDynamicObject) arg1Value;
                    return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSDynamicObject) receiver) .identityHashCode();
            }

        }
    }
    @GeneratedBy(JSDynamicObject.class)
    public static class ValueLibraryExports extends LibraryExport<ValueLibrary> {

        private ValueLibraryExports() {
            super(ValueLibrary.class, JSDynamicObject.class, false, false, 0);
        }

        @Override
        protected ValueLibrary createUncached(Object receiver) {
            assert receiver instanceof JSDynamicObject;
            ValueLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected ValueLibrary createCached(Object receiver) {
            assert receiver instanceof JSDynamicObject;
            return new Cached(receiver);
        }

        @GeneratedBy(JSDynamicObject.class)
        public static class Cached extends ValueLibrary {

            private final Class<? extends JSDynamicObject> receiverClass_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ToString#toString}
             *   1: SpecializationActive {@link ToNumber#toNumber}
             *   2: SpecializationActive {@link ToBoolean#toBoolean}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToString#toString}
             *   Parameter: {@link JSToStringNode} toStringNode</pre> */
            @Child private JSToStringNode toString_toString_toStringNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToNumber#toNumber}
             *   Parameter: {@link JSToNumberNode} toNumberNode</pre> */
            @Child private JSToNumberNode toNumber_toNumber_toNumberNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToBoolean#toBoolean}
             *   Parameter: {@link JSToBooleanNode} toBooleanNode</pre> */
            @Child private JSToBooleanNode toBoolean_toBoolean_toBooleanNode_;

            protected Cached(Object receiver) {
                JSDynamicObject castReceiver = ((JSDynamicObject) receiver) ;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ToString#toString}
             *     Activation probability: 0.33333
             *     With/without class size: 10/4 bytes
             * </pre> */
            @Override
            public TruffleString toString(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                JSDynamicObject arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSDynamicObject.ToString.toString(JSDynamicObject, JSToStringNode)] */) {
                    {
                        JSToStringNode toStringNode__ = this.toString_toString_toStringNode_;
                        if (toStringNode__ != null) {
                            return ToString.toString(arg0Value, toStringNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return toStringAndSpecialize(arg0Value);
            }

            private TruffleString toStringAndSpecialize(JSDynamicObject arg0Value) {
                int state_0 = this.state_0_;
                JSToStringNode toStringNode__ = this.insert((JSToStringNode.create()));
                Objects.requireNonNull(toStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.toString_toString_toStringNode_ = toStringNode__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[JSDynamicObject.ToString.toString(JSDynamicObject, JSToStringNode)] */;
                this.state_0_ = state_0;
                return ToString.toString(arg0Value, toStringNode__);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ToNumber#toNumber}
             *     Activation probability: 0.33333
             *     With/without class size: 10/4 bytes
             * </pre> */
            @Override
            public Number toNumber(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                JSDynamicObject arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSDynamicObject.ToNumber.toNumber(JSDynamicObject, JSToNumberNode)] */) {
                    {
                        JSToNumberNode toNumberNode__ = this.toNumber_toNumber_toNumberNode_;
                        if (toNumberNode__ != null) {
                            return ToNumber.toNumber(arg0Value, toNumberNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return toNumberAndSpecialize(arg0Value);
            }

            private Number toNumberAndSpecialize(JSDynamicObject arg0Value) {
                int state_0 = this.state_0_;
                JSToNumberNode toNumberNode__ = this.insert((JSToNumberNode.create()));
                Objects.requireNonNull(toNumberNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.toNumber_toNumber_toNumberNode_ = toNumberNode__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[JSDynamicObject.ToNumber.toNumber(JSDynamicObject, JSToNumberNode)] */;
                this.state_0_ = state_0;
                return ToNumber.toNumber(arg0Value, toNumberNode__);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ToBoolean#toBoolean}
             *     Activation probability: 0.33333
             *     With/without class size: 10/4 bytes
             * </pre> */
            @Override
            public boolean toBoolean(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                JSDynamicObject arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSDynamicObject.ToBoolean.toBoolean(JSDynamicObject, JSToBooleanNode)] */) {
                    {
                        JSToBooleanNode toBooleanNode__ = this.toBoolean_toBoolean_toBooleanNode_;
                        if (toBooleanNode__ != null) {
                            return ToBoolean.toBoolean(arg0Value, toBooleanNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return toBooleanAndSpecialize(arg0Value);
            }

            private boolean toBooleanAndSpecialize(JSDynamicObject arg0Value) {
                int state_0 = this.state_0_;
                JSToBooleanNode toBooleanNode__ = this.insert((JSToBooleanNode.create()));
                Objects.requireNonNull(toBooleanNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.toBoolean_toBoolean_toBooleanNode_ = toBooleanNode__;
                state_0 = state_0 | 0b100 /* add SpecializationActive[JSDynamicObject.ToBoolean.toBoolean(JSDynamicObject, JSToBooleanNode)] */;
                this.state_0_ = state_0;
                return ToBoolean.toBoolean(arg0Value, toBooleanNode__);
            }

        }
        @GeneratedBy(JSDynamicObject.class)
        public static class Uncached extends ValueLibrary implements UnadoptableNode {

            private final Class<? extends JSDynamicObject> receiverClass_;

            @SuppressWarnings("cast")
            protected Uncached(Object receiver) {
                this.receiverClass_ = ((JSDynamicObject) receiver).getClass();
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @TruffleBoundary
            @Override
            public TruffleString toString(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSDynamicObject arg0Value = ((JSDynamicObject) arg0Value_);
                return ToString.toString(arg0Value, (JSToStringNode.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Number toNumber(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSDynamicObject arg0Value = ((JSDynamicObject) arg0Value_);
                return ToNumber.toNumber(arg0Value, (JSToNumberNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean toBoolean(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JSDynamicObject arg0Value = ((JSDynamicObject) arg0Value_);
                return ToBoolean.toBoolean(arg0Value, (JSToBooleanNode.getUncached()));
            }

        }
    }
}
