// CheckStyle: start generated
package com.oracle.truffle.js.nodes.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.strings.TruffleString.SwitchEncodingNode;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.runtime.JSConfig;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link ToJSValueNode#i32}
 *     Activation probability: 0.32000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link ToJSValueNode#i64}
 *     Activation probability: 0.26000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link ToJSValueNode#f32}
 *     Activation probability: 0.20000
 *     With/without class size: 6/0 bytes
 *   Specialization {@link ToJSValueNode#f64}
 *     Activation probability: 0.14000
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToJSValueNode#convert}
 *     Activation probability: 0.08000
 *     With/without class size: 6/16 bytes
 * </pre> */
@GeneratedBy(ToJSValueNode.class)
@SuppressWarnings("javadoc")
public final class ToJSValueNodeGen extends ToJSValueNode {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link ToJSValueNode#i32}
     *   1: SpecializationActive {@link ToJSValueNode#i64}
     *   2: SpecializationActive {@link ToJSValueNode#f32}
     *   3: SpecializationActive {@link ToJSValueNode#f64}
     *   4: SpecializationActive {@link ToJSValueNode#convert}
     *   5-7: ImplicitCast[type=double, index=0]
     * </pre> */
    @CompilationFinal private int state_0_;
    @Child private FallbackData fallback_cache;

    private ToJSValueNodeGen() {
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object arg0Value) {
        if (!((state_0 & 0b10) != 0 /* is SpecializationActive[ToJSValueNode.i64(long)] */) && arg0Value instanceof Long) {
            return false;
        }
        if (!((state_0 & 0b100) != 0 /* is SpecializationActive[ToJSValueNode.f32(float)] */) && arg0Value instanceof Float) {
            return false;
        }
        if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[ToJSValueNode.f64(double)] */
         && (state_0 & 0b11100000) == 0b11100000) && JSTypesGen.isImplicitDouble(arg0Value)) {
            return false;
        }
        return true;
    }

    @Override
    public Object execute(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111) != 0 /* is SpecializationActive[ToJSValueNode.i32(int)] || SpecializationActive[ToJSValueNode.i64(long)] || SpecializationActive[ToJSValueNode.f32(float)] || SpecializationActive[ToJSValueNode.f64(double)] || SpecializationActive[ToJSValueNode.convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[ToJSValueNode.i32(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return ToJSValueNode.i32(arg0Value_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToJSValueNode.i64(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return ToJSValueNode.i64(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToJSValueNode.f32(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return ToJSValueNode.f32(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToJSValueNode.f64(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                return ToJSValueNode.f64(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToJSValueNode.convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)] */) {
                FallbackData s4_ = this.fallback_cache;
                if (s4_ != null) {
                    if (fallbackGuard_(state_0, arg0Value)) {
                        return convert(arg0Value, s4_.isFuncLib_, s4_.funcTypeLib_, s4_.asTStringLib_, s4_.switchEncoding_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[ToJSValueNode.i32(int)] */;
            this.state_0_ = state_0;
            return ToJSValueNode.i32(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[ToJSValueNode.i64(long)] */;
            this.state_0_ = state_0;
            return ToJSValueNode.i64(arg0Value_);
        }
        if (arg0Value instanceof Float) {
            float arg0Value_ = (float) arg0Value;
            state_0 = state_0 | 0b100 /* add SpecializationActive[ToJSValueNode.f32(float)] */;
            this.state_0_ = state_0;
            return ToJSValueNode.f32(arg0Value_);
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state_0 = (state_0 | (doubleCast0 << 5) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b1000 /* add SpecializationActive[ToJSValueNode.f64(double)] */;
                this.state_0_ = state_0;
                return ToJSValueNode.f64(arg0Value_);
            }
        }
        FallbackData s4_ = this.insert(new FallbackData());
        InteropLibrary isFuncLib__ = s4_.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
        Objects.requireNonNull(isFuncLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
        s4_.isFuncLib_ = isFuncLib__;
        InteropLibrary funcTypeLib__ = s4_.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
        Objects.requireNonNull(funcTypeLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
        s4_.funcTypeLib_ = funcTypeLib__;
        InteropLibrary asTStringLib__ = s4_.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
        Objects.requireNonNull(asTStringLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
        s4_.asTStringLib_ = asTStringLib__;
        SwitchEncodingNode switchEncoding__ = s4_.insert((SwitchEncodingNode.create()));
        Objects.requireNonNull(switchEncoding__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
        s4_.switchEncoding_ = switchEncoding__;
        VarHandle.storeStoreFence();
        this.fallback_cache = s4_;
        state_0 = state_0 | 0b10000 /* add SpecializationActive[ToJSValueNode.convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)] */;
        this.state_0_ = state_0;
        return convert(arg0Value, isFuncLib__, funcTypeLib__, asTStringLib__, switchEncoding__);
    }

    @NeverDefault
    public static ToJSValueNode create() {
        return new ToJSValueNodeGen();
    }

    @NeverDefault
    public static ToJSValueNode getUncached() {
        return ToJSValueNodeGen.UNCACHED;
    }

    @GeneratedBy(ToJSValueNode.class)
    @DenyReplace
    private static final class FallbackData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link ToJSValueNode#convert}
         *   Parameter: {@link InteropLibrary} isFuncLib</pre> */
        @Child InteropLibrary isFuncLib_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToJSValueNode#convert}
         *   Parameter: {@link InteropLibrary} funcTypeLib</pre> */
        @Child InteropLibrary funcTypeLib_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToJSValueNode#convert}
         *   Parameter: {@link InteropLibrary} asTStringLib</pre> */
        @Child InteropLibrary asTStringLib_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToJSValueNode#convert}
         *   Parameter: {@link SwitchEncodingNode} switchEncoding</pre> */
        @Child SwitchEncodingNode switchEncoding_;

        FallbackData() {
        }

    }
    @GeneratedBy(ToJSValueNode.class)
    @DenyReplace
    private static final class Uncached extends ToJSValueNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public Object execute(Object arg0Value) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return ToJSValueNode.i32(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return ToJSValueNode.i64(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return ToJSValueNode.f32(arg0Value_);
            }
            if (JSTypesGen.isImplicitDouble(arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(arg0Value);
                return ToJSValueNode.f64(arg0Value_);
            }
            return convert(arg0Value, (INTEROP_LIBRARY_.getUncached()), (INTEROP_LIBRARY_.getUncached()), (INTEROP_LIBRARY_.getUncached()), (SwitchEncodingNode.getUncached()));
        }

    }
}
