// CheckStyle: start generated
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject.BoundOrWrapped;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject.Unbound;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

/**
 * Debug Info: <pre>
 *   Specialization {@link ExportValueNode#doFunctionNoBind}
 *     Activation probability: 0.11213
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ExportValueNode#doFunctionUndefinedThis}
 *     Activation probability: 0.10551
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ExportValueNode#doBindUnboundFunction}
 *     Activation probability: 0.09890
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ExportValueNode#doBoundFunction}
 *     Activation probability: 0.09228
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ExportValueNode#doAsyncFunction}
 *     Activation probability: 0.08566
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ExportValueNode#doSafeInteger}
 *     Activation probability: 0.07904
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ExportValueNode#doObject}
 *     Activation probability: 0.07243
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ExportValueNode#doInt}
 *     Activation probability: 0.06581
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ExportValueNode#doLong}
 *     Activation probability: 0.05919
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ExportValueNode#doFloat}
 *     Activation probability: 0.05257
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ExportValueNode#doDouble}
 *     Activation probability: 0.04596
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ExportValueNode#doBoolean}
 *     Activation probability: 0.03934
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ExportValueNode#doBigInt}
 *     Activation probability: 0.03272
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ExportValueNode#doString}
 *     Activation probability: 0.02610
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ExportValueNode#doTruffleObject}
 *     Activation probability: 0.01949
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ExportValueNode#doOther}
 *     Activation probability: 0.01287
 *     With/without class size: 4/0 bytes
 * </pre> */
@GeneratedBy(ExportValueNode.class)
@SuppressWarnings("javadoc")
public final class ExportValueNodeGen extends ExportValueNode {

    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link ExportValueNode#doFunctionNoBind}
     *   1: SpecializationActive {@link ExportValueNode#doFunctionUndefinedThis}
     *   2: SpecializationActive {@link ExportValueNode#doBindUnboundFunction}
     *   3: SpecializationActive {@link ExportValueNode#doBoundFunction}
     *   4: SpecializationActive {@link ExportValueNode#doAsyncFunction}
     *   5: SpecializationActive {@link ExportValueNode#doSafeInteger}
     *   6: SpecializationActive {@link ExportValueNode#doObject}
     *   7: SpecializationActive {@link ExportValueNode#doTruffleObject}
     *   8: SpecializationActive {@link ExportValueNode#doInt}
     *   9: SpecializationActive {@link ExportValueNode#doLong}
     *   10: SpecializationActive {@link ExportValueNode#doFloat}
     *   11: SpecializationActive {@link ExportValueNode#doDouble}
     *   12: SpecializationActive {@link ExportValueNode#doBoolean}
     *   13: SpecializationActive {@link ExportValueNode#doBigInt}
     *   14: SpecializationActive {@link ExportValueNode#doString}
     *   15: SpecializationActive {@link ExportValueNode#doOther}
     *   16-18: ImplicitCast[type=double, index=0]
     * </pre> */
    @CompilationFinal private int state_0_;

    private ExportValueNodeGen() {
    }

    @Override
    public Object execute(Object arg0Value, Object arg1Value, boolean arg2Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1111111111111111) != 0 /* is SpecializationActive[ExportValueNode.doFunctionNoBind(JSFunctionObject, Object, boolean)] || SpecializationActive[ExportValueNode.doFunctionUndefinedThis(JSFunctionObject, Object, boolean)] || SpecializationActive[ExportValueNode.doBindUnboundFunction(Unbound, Object, boolean)] || SpecializationActive[ExportValueNode.doBoundFunction(BoundOrWrapped, Object, boolean)] || SpecializationActive[ExportValueNode.doAsyncFunction(JSFunctionObject, Object, boolean)] || SpecializationActive[ExportValueNode.doSafeInteger(SafeInteger, Object, boolean)] || SpecializationActive[ExportValueNode.doObject(JSDynamicObject, Object, boolean)] || SpecializationActive[ExportValueNode.doInt(int, Object, boolean)] || SpecializationActive[ExportValueNode.doLong(long, Object, boolean)] || SpecializationActive[ExportValueNode.doFloat(float, Object, boolean)] || SpecializationActive[ExportValueNode.doDouble(double, Object, boolean)] || SpecializationActive[ExportValueNode.doBoolean(boolean, Object, boolean)] || SpecializationActive[ExportValueNode.doBigInt(BigInt, Object, boolean)] || SpecializationActive[ExportValueNode.doString(TruffleString, Object, boolean)] || SpecializationActive[ExportValueNode.doTruffleObject(TruffleObject, Object, boolean)] || SpecializationActive[ExportValueNode.doOther(Object, Object, boolean)] */) {
            if ((state_0 & 0b11) != 0 /* is SpecializationActive[ExportValueNode.doFunctionNoBind(JSFunctionObject, Object, boolean)] || SpecializationActive[ExportValueNode.doFunctionUndefinedThis(JSFunctionObject, Object, boolean)] */ && arg0Value instanceof JSFunctionObject) {
                JSFunctionObject arg0Value_ = (JSFunctionObject) arg0Value;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ExportValueNode.doFunctionNoBind(JSFunctionObject, Object, boolean)] */) {
                    if ((!(arg2Value)) && (!(isInteropCompletePromises()) || !(JSFunction.isAsyncFunction(arg0Value_)))) {
                        return ExportValueNode.doFunctionNoBind(arg0Value_, arg1Value, arg2Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[ExportValueNode.doFunctionUndefinedThis(JSFunctionObject, Object, boolean)] */) {
                    if ((arg2Value) && (JSGuards.isUndefined(arg1Value)) && (!(isInteropCompletePromises()) || !(JSFunction.isAsyncFunction(arg0Value_)))) {
                        return ExportValueNode.doFunctionUndefinedThis(arg0Value_, arg1Value, arg2Value);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ExportValueNode.doBindUnboundFunction(Unbound, Object, boolean)] */ && arg0Value instanceof Unbound) {
                Unbound arg0Value_ = (Unbound) arg0Value;
                if ((arg2Value) && (!(JSGuards.isUndefined(arg1Value))) && (!(isInteropCompletePromises()) || !(JSFunction.isAsyncFunction(arg0Value_)))) {
                    return ExportValueNode.doBindUnboundFunction(arg0Value_, arg1Value, arg2Value);
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ExportValueNode.doBoundFunction(BoundOrWrapped, Object, boolean)] */ && arg0Value instanceof BoundOrWrapped) {
                BoundOrWrapped arg0Value_ = (BoundOrWrapped) arg0Value;
                if ((arg2Value) && (!(isInteropCompletePromises()) || !(JSFunction.isAsyncFunction(arg0Value_)))) {
                    return ExportValueNode.doBoundFunction(arg0Value_, arg1Value, arg2Value);
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ExportValueNode.doAsyncFunction(JSFunctionObject, Object, boolean)] */ && arg0Value instanceof JSFunctionObject) {
                JSFunctionObject arg0Value_ = (JSFunctionObject) arg0Value;
                assert DSLSupport.assertIdempotence((isInteropCompletePromises()));
                if ((JSFunction.isAsyncFunction(arg0Value_))) {
                    return ExportValueNode.doAsyncFunction(arg0Value_, arg1Value, arg2Value);
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ExportValueNode.doSafeInteger(SafeInteger, Object, boolean)] */ && arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger) arg0Value;
                return ExportValueNode.doSafeInteger(arg0Value_, arg1Value, arg2Value);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ExportValueNode.doObject(JSDynamicObject, Object, boolean)] */ && arg0Value instanceof JSDynamicObject) {
                JSDynamicObject arg0Value_ = (JSDynamicObject) arg0Value;
                if ((!(JSGuards.isJSFunction(arg0Value_)))) {
                    return ExportValueNode.doObject(arg0Value_, arg1Value, arg2Value);
                }
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ExportValueNode.doInt(int, Object, boolean)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return ExportValueNode.doInt(arg0Value_, arg1Value, arg2Value);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ExportValueNode.doLong(long, Object, boolean)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return ExportValueNode.doLong(arg0Value_, arg1Value, arg2Value);
            }
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[ExportValueNode.doFloat(float, Object, boolean)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return ExportValueNode.doFloat(arg0Value_, arg1Value, arg2Value);
            }
            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[ExportValueNode.doDouble(double, Object, boolean)] */ && JSTypesGen.isImplicitDouble((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                return ExportValueNode.doDouble(arg0Value_, arg1Value, arg2Value);
            }
            if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ExportValueNode.doBoolean(boolean, Object, boolean)] */ && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return ExportValueNode.doBoolean(arg0Value_, arg1Value, arg2Value);
            }
            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[ExportValueNode.doBigInt(BigInt, Object, boolean)] */ && arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt) arg0Value;
                return ExportValueNode.doBigInt(arg0Value_, arg1Value, arg2Value);
            }
            if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[ExportValueNode.doString(TruffleString, Object, boolean)] */ && arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                return ExportValueNode.doString(arg0Value_, arg1Value, arg2Value);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ExportValueNode.doTruffleObject(TruffleObject, Object, boolean)] */ && arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                if ((!(JSGuards.isJSFunction(arg0Value_))) && (!(JSGuards.isSafeInteger(arg0Value_)))) {
                    return ExportValueNode.doTruffleObject(arg0Value_, arg1Value, arg2Value);
                }
            }
            if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[ExportValueNode.doOther(Object, Object, boolean)] */) {
                if ((!(JSGuards.isTruffleObject(arg0Value))) && (!(JSGuards.isString(arg0Value))) && (!(JSGuards.isBoolean(arg0Value))) && (!(JSGuards.isNumberDouble(arg0Value))) && (!(JSGuards.isNumberLong(arg0Value))) && (!(JSGuards.isNumberInteger(arg0Value)))) {
                    return ExportValueNode.doOther(arg0Value, arg1Value, arg2Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Object executeAndSpecialize(Object arg0Value, Object arg1Value, boolean arg2Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof JSFunctionObject) {
            JSFunctionObject arg0Value_ = (JSFunctionObject) arg0Value;
            if ((!(arg2Value)) && (!(isInteropCompletePromises()) || !(JSFunction.isAsyncFunction(arg0Value_)))) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[ExportValueNode.doFunctionNoBind(JSFunctionObject, Object, boolean)] */;
                this.state_0_ = state_0;
                return ExportValueNode.doFunctionNoBind(arg0Value_, arg1Value, arg2Value);
            }
            if ((arg2Value) && (JSGuards.isUndefined(arg1Value)) && (!(isInteropCompletePromises()) || !(JSFunction.isAsyncFunction(arg0Value_)))) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[ExportValueNode.doFunctionUndefinedThis(JSFunctionObject, Object, boolean)] */;
                this.state_0_ = state_0;
                return ExportValueNode.doFunctionUndefinedThis(arg0Value_, arg1Value, arg2Value);
            }
        }
        if (arg0Value instanceof Unbound) {
            Unbound arg0Value_ = (Unbound) arg0Value;
            if ((arg2Value) && (!(JSGuards.isUndefined(arg1Value))) && (!(isInteropCompletePromises()) || !(JSFunction.isAsyncFunction(arg0Value_)))) {
                state_0 = state_0 | 0b100 /* add SpecializationActive[ExportValueNode.doBindUnboundFunction(Unbound, Object, boolean)] */;
                this.state_0_ = state_0;
                return ExportValueNode.doBindUnboundFunction(arg0Value_, arg1Value, arg2Value);
            }
        }
        if (arg0Value instanceof BoundOrWrapped) {
            BoundOrWrapped arg0Value_ = (BoundOrWrapped) arg0Value;
            if ((arg2Value) && (!(isInteropCompletePromises()) || !(JSFunction.isAsyncFunction(arg0Value_)))) {
                state_0 = state_0 | 0b1000 /* add SpecializationActive[ExportValueNode.doBoundFunction(BoundOrWrapped, Object, boolean)] */;
                this.state_0_ = state_0;
                return ExportValueNode.doBoundFunction(arg0Value_, arg1Value, arg2Value);
            }
        }
        if (arg0Value instanceof JSFunctionObject) {
            JSFunctionObject arg0Value_ = (JSFunctionObject) arg0Value;
            if ((isInteropCompletePromises()) && (JSFunction.isAsyncFunction(arg0Value_))) {
                state_0 = state_0 | 0b10000 /* add SpecializationActive[ExportValueNode.doAsyncFunction(JSFunctionObject, Object, boolean)] */;
                this.state_0_ = state_0;
                return ExportValueNode.doAsyncFunction(arg0Value_, arg1Value, arg2Value);
            }
        }
        if (arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_ = (SafeInteger) arg0Value;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[ExportValueNode.doSafeInteger(SafeInteger, Object, boolean)] */;
            this.state_0_ = state_0;
            return ExportValueNode.doSafeInteger(arg0Value_, arg1Value, arg2Value);
        }
        if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[ExportValueNode.doTruffleObject(TruffleObject, Object, boolean)] */ && arg0Value instanceof JSDynamicObject) {
            JSDynamicObject arg0Value_ = (JSDynamicObject) arg0Value;
            if ((!(JSGuards.isJSFunction(arg0Value_)))) {
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[ExportValueNode.doObject(JSDynamicObject, Object, boolean)] */;
                this.state_0_ = state_0;
                return ExportValueNode.doObject(arg0Value_, arg1Value, arg2Value);
            }
        }
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[ExportValueNode.doInt(int, Object, boolean)] */;
            this.state_0_ = state_0;
            return ExportValueNode.doInt(arg0Value_, arg1Value, arg2Value);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[ExportValueNode.doLong(long, Object, boolean)] */;
            this.state_0_ = state_0;
            return ExportValueNode.doLong(arg0Value_, arg1Value, arg2Value);
        }
        if (arg0Value instanceof Float) {
            float arg0Value_ = (float) arg0Value;
            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[ExportValueNode.doFloat(float, Object, boolean)] */;
            this.state_0_ = state_0;
            return ExportValueNode.doFloat(arg0Value_, arg1Value, arg2Value);
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state_0 = (state_0 | (doubleCast0 << 16) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[ExportValueNode.doDouble(double, Object, boolean)] */;
                this.state_0_ = state_0;
                return ExportValueNode.doDouble(arg0Value_, arg1Value, arg2Value);
            }
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (boolean) arg0Value;
            state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[ExportValueNode.doBoolean(boolean, Object, boolean)] */;
            this.state_0_ = state_0;
            return ExportValueNode.doBoolean(arg0Value_, arg1Value, arg2Value);
        }
        if (arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt) arg0Value;
            state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[ExportValueNode.doBigInt(BigInt, Object, boolean)] */;
            this.state_0_ = state_0;
            return ExportValueNode.doBigInt(arg0Value_, arg1Value, arg2Value);
        }
        if (arg0Value instanceof TruffleString) {
            TruffleString arg0Value_ = (TruffleString) arg0Value;
            state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[ExportValueNode.doString(TruffleString, Object, boolean)] */;
            this.state_0_ = state_0;
            return ExportValueNode.doString(arg0Value_, arg1Value, arg2Value);
        }
        if (arg0Value instanceof TruffleObject) {
            TruffleObject arg0Value_ = (TruffleObject) arg0Value;
            if ((!(JSGuards.isJSFunction(arg0Value_))) && (!(JSGuards.isSafeInteger(arg0Value_)))) {
                state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[ExportValueNode.doObject(JSDynamicObject, Object, boolean)] */;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[ExportValueNode.doTruffleObject(TruffleObject, Object, boolean)] */;
                this.state_0_ = state_0;
                return ExportValueNode.doTruffleObject(arg0Value_, arg1Value, arg2Value);
            }
        }
        if ((!(JSGuards.isTruffleObject(arg0Value))) && (!(JSGuards.isString(arg0Value))) && (!(JSGuards.isBoolean(arg0Value))) && (!(JSGuards.isNumberDouble(arg0Value))) && (!(JSGuards.isNumberLong(arg0Value))) && (!(JSGuards.isNumberInteger(arg0Value)))) {
            state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[ExportValueNode.doOther(Object, Object, boolean)] */;
            this.state_0_ = state_0;
            return ExportValueNode.doOther(arg0Value, arg1Value, arg2Value);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
    }

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException3LLZ(Node thisNode_, Object arg0Value, Object arg1Value, boolean arg2Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value);
    }

    @NeverDefault
    public static ExportValueNode create() {
        return new ExportValueNodeGen();
    }

    @NeverDefault
    public static ExportValueNode getUncached() {
        return ExportValueNodeGen.UNCACHED;
    }

    @GeneratedBy(ExportValueNode.class)
    @DenyReplace
    private static final class Uncached extends ExportValueNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public Object execute(Object arg0Value, Object arg1Value, boolean arg2Value) {
            if (arg0Value instanceof JSFunctionObject) {
                JSFunctionObject arg0Value_ = (JSFunctionObject) arg0Value;
                if ((!(arg2Value)) && (!(isInteropCompletePromises()) || !(JSFunction.isAsyncFunction(arg0Value_)))) {
                    return ExportValueNode.doFunctionNoBind(arg0Value_, arg1Value, arg2Value);
                }
                if ((arg2Value) && (JSGuards.isUndefined(arg1Value)) && (!(isInteropCompletePromises()) || !(JSFunction.isAsyncFunction(arg0Value_)))) {
                    return ExportValueNode.doFunctionUndefinedThis(arg0Value_, arg1Value, arg2Value);
                }
            }
            if (arg0Value instanceof Unbound) {
                Unbound arg0Value_ = (Unbound) arg0Value;
                if ((arg2Value) && (!(JSGuards.isUndefined(arg1Value))) && (!(isInteropCompletePromises()) || !(JSFunction.isAsyncFunction(arg0Value_)))) {
                    return ExportValueNode.doBindUnboundFunction(arg0Value_, arg1Value, arg2Value);
                }
            }
            if (arg0Value instanceof BoundOrWrapped) {
                BoundOrWrapped arg0Value_ = (BoundOrWrapped) arg0Value;
                if ((arg2Value) && (!(isInteropCompletePromises()) || !(JSFunction.isAsyncFunction(arg0Value_)))) {
                    return ExportValueNode.doBoundFunction(arg0Value_, arg1Value, arg2Value);
                }
            }
            if (arg0Value instanceof JSFunctionObject) {
                JSFunctionObject arg0Value_ = (JSFunctionObject) arg0Value;
                if ((isInteropCompletePromises()) && (JSFunction.isAsyncFunction(arg0Value_))) {
                    return ExportValueNode.doAsyncFunction(arg0Value_, arg1Value, arg2Value);
                }
            }
            if (arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger) arg0Value;
                return ExportValueNode.doSafeInteger(arg0Value_, arg1Value, arg2Value);
            }
            if (arg0Value instanceof JSDynamicObject) {
                JSDynamicObject arg0Value_ = (JSDynamicObject) arg0Value;
                if ((!(JSGuards.isJSFunction(arg0Value_)))) {
                    return ExportValueNode.doObject(arg0Value_, arg1Value, arg2Value);
                }
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return ExportValueNode.doInt(arg0Value_, arg1Value, arg2Value);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return ExportValueNode.doLong(arg0Value_, arg1Value, arg2Value);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return ExportValueNode.doFloat(arg0Value_, arg1Value, arg2Value);
            }
            if (JSTypesGen.isImplicitDouble(arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(arg0Value);
                return ExportValueNode.doDouble(arg0Value_, arg1Value, arg2Value);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (boolean) arg0Value;
                return ExportValueNode.doBoolean(arg0Value_, arg1Value, arg2Value);
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt) arg0Value;
                return ExportValueNode.doBigInt(arg0Value_, arg1Value, arg2Value);
            }
            if (arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                return ExportValueNode.doString(arg0Value_, arg1Value, arg2Value);
            }
            if (arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                if ((!(JSGuards.isJSFunction(arg0Value_))) && (!(JSGuards.isSafeInteger(arg0Value_)))) {
                    return ExportValueNode.doTruffleObject(arg0Value_, arg1Value, arg2Value);
                }
            }
            if ((!(JSGuards.isTruffleObject(arg0Value))) && (!(JSGuards.isString(arg0Value))) && (!(JSGuards.isBoolean(arg0Value))) && (!(JSGuards.isNumberDouble(arg0Value))) && (!(JSGuards.isNumberLong(arg0Value))) && (!(JSGuards.isNumberInteger(arg0Value)))) {
                return ExportValueNode.doOther(arg0Value, arg1Value, arg2Value);
            }
            throw newUnsupportedSpecializationException3LLZ(this, arg0Value, arg1Value, arg2Value);
        }

    }
}
