// CheckStyle: start generated
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleString.SwitchEncodingNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode.Hint;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link ToPrimitiveBaseNode#doInt}
 *     Activation probability: 0.13626
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToPrimitiveBaseNode#doSafeInteger}
 *     Activation probability: 0.12637
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToPrimitiveBaseNode#doLong}
 *     Activation probability: 0.11648
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToPrimitiveBaseNode#doDouble}
 *     Activation probability: 0.10659
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToPrimitiveBaseNode#doBoolean}
 *     Activation probability: 0.09670
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToPrimitiveBaseNode#doString}
 *     Activation probability: 0.08681
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToPrimitiveBaseNode#doSymbol}
 *     Activation probability: 0.07692
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToPrimitiveBaseNode#doBigInt}
 *     Activation probability: 0.06703
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToPrimitiveBaseNode#doNull}
 *     Activation probability: 0.05714
 *     With/without class size: 4/0 bytes
 *   Specialization {@link ToPrimitiveBaseNode#doUndefined}
 *     Activation probability: 0.04725
 *     With/without class size: 4/0 bytes
 *   Specialization {@link AsPrimitiveNode#doJSObject}
 *     Activation probability: 0.03736
 *     With/without class size: 4/0 bytes
 *   Specialization {@link AsPrimitiveNode#doForeignObject}
 *     Activation probability: 0.02747
 *     With/without class size: 4/9 bytes
 *   Specialization {@link ToPrimitiveBaseNode#doFallback}
 *     Activation probability: 0.01758
 *     With/without class size: 4/0 bytes
 * </pre> */
@GeneratedBy(AsPrimitiveNode.class)
@SuppressWarnings({"javadoc", "unused"})
final class AsPrimitiveNodeGen {

    private static final StateField FOREIGN_OBJECT_AS_PRIMITIVE_NODE_FOREIGN_OBJECT_STATE_0_UPDATER = StateField.create(ForeignObjectData.lookup_(), "foreignObject_state_0_");
    private static final InlinedBranchProfile INLINED_FOREIGN_OBJECT_ERROR_BRANCH_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, FOREIGN_OBJECT_AS_PRIMITIVE_NODE_FOREIGN_OBJECT_STATE_0_UPDATER.subUpdater(0, 1)));
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @NeverDefault
    public static AsPrimitiveNode getUncached() {
        return AsPrimitiveNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * <li>{@link Inlined#foreignObject_cache}
     * </ul> */
    @NeverDefault
    public static AsPrimitiveNode inline(@RequiredField(bits = 16, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
        return new AsPrimitiveNodeGen.Inlined(target);
    }

    @GeneratedBy(AsPrimitiveNode.class)
    @DenyReplace
    private static final class Inlined extends AsPrimitiveNode implements UnadoptableNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link ToPrimitiveBaseNode#doInt}
         *   1: SpecializationActive {@link ToPrimitiveBaseNode#doSafeInteger}
         *   2: SpecializationActive {@link ToPrimitiveBaseNode#doLong}
         *   3: SpecializationActive {@link ToPrimitiveBaseNode#doDouble}
         *   4: SpecializationActive {@link ToPrimitiveBaseNode#doBoolean}
         *   5: SpecializationActive {@link ToPrimitiveBaseNode#doString}
         *   6: SpecializationActive {@link ToPrimitiveBaseNode#doSymbol}
         *   7: SpecializationActive {@link ToPrimitiveBaseNode#doBigInt}
         *   8: SpecializationActive {@link ToPrimitiveBaseNode#doNull}
         *   9: SpecializationActive {@link ToPrimitiveBaseNode#doUndefined}
         *   10: SpecializationActive {@link AsPrimitiveNode#doJSObject}
         *   11: SpecializationActive {@link AsPrimitiveNode#doForeignObject}
         *   12: SpecializationActive {@link ToPrimitiveBaseNode#doFallback}
         *   13-15: ImplicitCast[type=double, index=1]
         * </pre> */
        private final StateField state_0_;
        private final ReferenceField<ForeignObjectData> foreignObject_cache;

        @SuppressWarnings("unchecked")
        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(AsPrimitiveNode.class);
            this.state_0_ = target.getState(0, 16);
            this.foreignObject_cache = target.getReference(1, ForeignObjectData.class);
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value, Hint arg2Value) {
            if (!((state_0 & 0b100) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doLong(long, Hint)] */) && arg1Value instanceof Long) {
                return false;
            }
            if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doDouble(double, Hint)] */
             && (state_0 & 0b1110000000000000) == 0b1110000000000000) && JSTypesGen.isImplicitDouble(arg1Value)) {
                return false;
            }
            if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doBoolean(boolean, Hint)] */) && arg1Value instanceof Boolean) {
                return false;
            }
            if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doString(TruffleString, Hint)] */) && arg1Value instanceof TruffleString) {
                return false;
            }
            if (!((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doSymbol(Symbol, Hint)] */) && arg1Value instanceof Symbol) {
                return false;
            }
            if (!((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doBigInt(BigInt, Hint)] */) && arg1Value instanceof BigInt) {
                return false;
            }
            if (!((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doNull(Object, Hint)] */) && (JSGuards.isJSNull(arg1Value))) {
                return false;
            }
            if (!((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doUndefined(Object, Hint)] */) && (JSGuards.isUndefined(arg1Value))) {
                return false;
            }
            if (!((state_0 & 0b10000000000) != 0 /* is SpecializationActive[AsPrimitiveNode.doJSObject(Node, JSObject, Hint)] */) && arg1Value instanceof JSObject) {
                return false;
            }
            if (!((state_0 & 0b100000000000) != 0 /* is SpecializationActive[AsPrimitiveNode.doForeignObject(Node, Object, Hint, InteropLibrary, InlinedBranchProfile, SwitchEncodingNode)] */) && (JSGuards.isForeignObject(arg1Value))) {
                return false;
            }
            return true;
        }

        @Override
        public Object execute(Node arg0Value, Object arg1Value, Hint arg2Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b1111111111111) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doInt(int, Hint)] || SpecializationActive[ToPrimitiveBaseNode.doSafeInteger(SafeInteger, Hint)] || SpecializationActive[ToPrimitiveBaseNode.doLong(long, Hint)] || SpecializationActive[ToPrimitiveBaseNode.doDouble(double, Hint)] || SpecializationActive[ToPrimitiveBaseNode.doBoolean(boolean, Hint)] || SpecializationActive[ToPrimitiveBaseNode.doString(TruffleString, Hint)] || SpecializationActive[ToPrimitiveBaseNode.doSymbol(Symbol, Hint)] || SpecializationActive[ToPrimitiveBaseNode.doBigInt(BigInt, Hint)] || SpecializationActive[ToPrimitiveBaseNode.doNull(Object, Hint)] || SpecializationActive[ToPrimitiveBaseNode.doUndefined(Object, Hint)] || SpecializationActive[AsPrimitiveNode.doJSObject(Node, JSObject, Hint)] || SpecializationActive[AsPrimitiveNode.doForeignObject(Node, Object, Hint, InteropLibrary, InlinedBranchProfile, SwitchEncodingNode)] || SpecializationActive[ToPrimitiveBaseNode.doFallback(Object, Hint, Node)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doInt(int, Hint)] */ && arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    return ToPrimitiveBaseNode.doInt(arg1Value_, arg2Value);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doSafeInteger(SafeInteger, Hint)] */ && arg1Value instanceof SafeInteger) {
                    SafeInteger arg1Value_ = (SafeInteger) arg1Value;
                    return ToPrimitiveBaseNode.doSafeInteger(arg1Value_, arg2Value);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doLong(long, Hint)] */ && arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    return ToPrimitiveBaseNode.doLong(arg1Value_, arg2Value);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doDouble(double, Hint)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=double, index=1] */, arg1Value)) {
                    double arg1Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=double, index=1] */, arg1Value);
                    return ToPrimitiveBaseNode.doDouble(arg1Value_, arg2Value);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doBoolean(boolean, Hint)] */ && arg1Value instanceof Boolean) {
                    boolean arg1Value_ = (boolean) arg1Value;
                    return ToPrimitiveBaseNode.doBoolean(arg1Value_, arg2Value);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doString(TruffleString, Hint)] */ && arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    return ToPrimitiveBaseNode.doString(arg1Value_, arg2Value);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doSymbol(Symbol, Hint)] */ && arg1Value instanceof Symbol) {
                    Symbol arg1Value_ = (Symbol) arg1Value;
                    return ToPrimitiveBaseNode.doSymbol(arg1Value_, arg2Value);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doBigInt(BigInt, Hint)] */ && arg1Value instanceof BigInt) {
                    BigInt arg1Value_ = (BigInt) arg1Value;
                    return ToPrimitiveBaseNode.doBigInt(arg1Value_, arg2Value);
                }
                if ((state_0 & 0b1100000000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doNull(Object, Hint)] || SpecializationActive[ToPrimitiveBaseNode.doUndefined(Object, Hint)] */) {
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doNull(Object, Hint)] */) {
                        if ((JSGuards.isJSNull(arg1Value))) {
                            return ToPrimitiveBaseNode.doNull(arg1Value, arg2Value);
                        }
                    }
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doUndefined(Object, Hint)] */) {
                        if ((JSGuards.isUndefined(arg1Value))) {
                            return ToPrimitiveBaseNode.doUndefined(arg1Value, arg2Value);
                        }
                    }
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[AsPrimitiveNode.doJSObject(Node, JSObject, Hint)] */ && arg1Value instanceof JSObject) {
                    JSObject arg1Value_ = (JSObject) arg1Value;
                    return AsPrimitiveNode.doJSObject(arg0Value, arg1Value_, arg2Value);
                }
                if ((state_0 & 0b1100000000000) != 0 /* is SpecializationActive[AsPrimitiveNode.doForeignObject(Node, Object, Hint, InteropLibrary, InlinedBranchProfile, SwitchEncodingNode)] || SpecializationActive[ToPrimitiveBaseNode.doFallback(Object, Hint, Node)] */) {
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[AsPrimitiveNode.doForeignObject(Node, Object, Hint, InteropLibrary, InlinedBranchProfile, SwitchEncodingNode)] */) {
                        ForeignObjectData s11_ = this.foreignObject_cache.get(arg0Value);
                        if (s11_ != null) {
                            if ((JSGuards.isForeignObject(arg1Value))) {
                                return AsPrimitiveNode.doForeignObject(s11_, arg1Value, arg2Value, s11_.interop_, INLINED_FOREIGN_OBJECT_ERROR_BRANCH_, s11_.switchEncoding_);
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[ToPrimitiveBaseNode.doFallback(Object, Hint, Node)] */) {
                        {
                            Node node__ = (arg0Value);
                            if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                                return doFallback(arg1Value, arg2Value, node__);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(Node arg0Value, Object arg1Value, Hint arg2Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (int) arg1Value;
                state_0 = state_0 | 0b1 /* add SpecializationActive[ToPrimitiveBaseNode.doInt(int, Hint)] */;
                this.state_0_.set(arg0Value, state_0);
                return ToPrimitiveBaseNode.doInt(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof SafeInteger) {
                SafeInteger arg1Value_ = (SafeInteger) arg1Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[ToPrimitiveBaseNode.doSafeInteger(SafeInteger, Hint)] */;
                this.state_0_.set(arg0Value, state_0);
                return ToPrimitiveBaseNode.doSafeInteger(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (long) arg1Value;
                state_0 = state_0 | 0b100 /* add SpecializationActive[ToPrimitiveBaseNode.doLong(long, Hint)] */;
                this.state_0_.set(arg0Value, state_0);
                return ToPrimitiveBaseNode.doLong(arg1Value_, arg2Value);
            }
            {
                int doubleCast1;
                if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                    double arg1Value_ = JSTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                    state_0 = (state_0 | (doubleCast1 << 13) /* set-int ImplicitCast[type=double, index=1] */);
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[ToPrimitiveBaseNode.doDouble(double, Hint)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ToPrimitiveBaseNode.doDouble(arg1Value_, arg2Value);
                }
            }
            if (arg1Value instanceof Boolean) {
                boolean arg1Value_ = (boolean) arg1Value;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[ToPrimitiveBaseNode.doBoolean(boolean, Hint)] */;
                this.state_0_.set(arg0Value, state_0);
                return ToPrimitiveBaseNode.doBoolean(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof TruffleString) {
                TruffleString arg1Value_ = (TruffleString) arg1Value;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[ToPrimitiveBaseNode.doString(TruffleString, Hint)] */;
                this.state_0_.set(arg0Value, state_0);
                return ToPrimitiveBaseNode.doString(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Symbol) {
                Symbol arg1Value_ = (Symbol) arg1Value;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[ToPrimitiveBaseNode.doSymbol(Symbol, Hint)] */;
                this.state_0_.set(arg0Value, state_0);
                return ToPrimitiveBaseNode.doSymbol(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof BigInt) {
                BigInt arg1Value_ = (BigInt) arg1Value;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[ToPrimitiveBaseNode.doBigInt(BigInt, Hint)] */;
                this.state_0_.set(arg0Value, state_0);
                return ToPrimitiveBaseNode.doBigInt(arg1Value_, arg2Value);
            }
            if ((JSGuards.isJSNull(arg1Value))) {
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[ToPrimitiveBaseNode.doNull(Object, Hint)] */;
                this.state_0_.set(arg0Value, state_0);
                return ToPrimitiveBaseNode.doNull(arg1Value, arg2Value);
            }
            if ((JSGuards.isUndefined(arg1Value))) {
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[ToPrimitiveBaseNode.doUndefined(Object, Hint)] */;
                this.state_0_.set(arg0Value, state_0);
                return ToPrimitiveBaseNode.doUndefined(arg1Value, arg2Value);
            }
            if (arg1Value instanceof JSObject) {
                JSObject arg1Value_ = (JSObject) arg1Value;
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[AsPrimitiveNode.doJSObject(Node, JSObject, Hint)] */;
                this.state_0_.set(arg0Value, state_0);
                return AsPrimitiveNode.doJSObject(arg0Value, arg1Value_, arg2Value);
            }
            if ((JSGuards.isForeignObject(arg1Value))) {
                ForeignObjectData s11_ = arg0Value.insert(new ForeignObjectData());
                InteropLibrary interop__ = s11_.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
                Objects.requireNonNull(interop__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s11_.interop_ = interop__;
                SwitchEncodingNode switchEncoding__ = s11_.insert((SwitchEncodingNode.create()));
                Objects.requireNonNull(switchEncoding__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s11_.switchEncoding_ = switchEncoding__;
                VarHandle.storeStoreFence();
                this.foreignObject_cache.set(arg0Value, s11_);
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[AsPrimitiveNode.doForeignObject(Node, Object, Hint, InteropLibrary, InlinedBranchProfile, SwitchEncodingNode)] */;
                this.state_0_.set(arg0Value, state_0);
                return AsPrimitiveNode.doForeignObject(s11_, arg1Value, arg2Value, interop__, INLINED_FOREIGN_OBJECT_ERROR_BRANCH_, switchEncoding__);
            }
            {
                Node node__ = null;
                node__ = (arg0Value);
                state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[ToPrimitiveBaseNode.doFallback(Object, Hint, Node)] */;
                this.state_0_.set(arg0Value, state_0);
                return doFallback(arg1Value, arg2Value, node__);
            }
        }

    }
    @GeneratedBy(AsPrimitiveNode.class)
    @DenyReplace
    private static final class ForeignObjectData extends Node implements SpecializationDataNode {

        /**
         * State Info: <pre>
         *   0: InlinedCache
         *        Specialization: {@link AsPrimitiveNode#doForeignObject}
         *        Parameter: {@link InlinedBranchProfile} errorBranch
         *        Inline method: {@link InlinedBranchProfile#inline}
         * </pre> */
        @CompilationFinal @UnsafeAccessedField private int foreignObject_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link AsPrimitiveNode#doForeignObject}
         *   Parameter: {@link InteropLibrary} interop</pre> */
        @Child InteropLibrary interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link AsPrimitiveNode#doForeignObject}
         *   Parameter: {@link SwitchEncodingNode} switchEncoding</pre> */
        @Child SwitchEncodingNode switchEncoding_;

        ForeignObjectData() {
        }

        private static Lookup lookup_() {
            return MethodHandles.lookup();
        }

    }
    @GeneratedBy(AsPrimitiveNode.class)
    @DenyReplace
    private static final class Uncached extends AsPrimitiveNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public Object execute(Node arg0Value, Object arg1Value, Hint arg2Value) {
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (int) arg1Value;
                return ToPrimitiveBaseNode.doInt(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof SafeInteger) {
                SafeInteger arg1Value_ = (SafeInteger) arg1Value;
                return ToPrimitiveBaseNode.doSafeInteger(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (long) arg1Value;
                return ToPrimitiveBaseNode.doLong(arg1Value_, arg2Value);
            }
            if (JSTypesGen.isImplicitDouble(arg1Value)) {
                double arg1Value_ = JSTypesGen.asImplicitDouble(arg1Value);
                return ToPrimitiveBaseNode.doDouble(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Boolean) {
                boolean arg1Value_ = (boolean) arg1Value;
                return ToPrimitiveBaseNode.doBoolean(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof TruffleString) {
                TruffleString arg1Value_ = (TruffleString) arg1Value;
                return ToPrimitiveBaseNode.doString(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof Symbol) {
                Symbol arg1Value_ = (Symbol) arg1Value;
                return ToPrimitiveBaseNode.doSymbol(arg1Value_, arg2Value);
            }
            if (arg1Value instanceof BigInt) {
                BigInt arg1Value_ = (BigInt) arg1Value;
                return ToPrimitiveBaseNode.doBigInt(arg1Value_, arg2Value);
            }
            if ((JSGuards.isJSNull(arg1Value))) {
                return ToPrimitiveBaseNode.doNull(arg1Value, arg2Value);
            }
            if ((JSGuards.isUndefined(arg1Value))) {
                return ToPrimitiveBaseNode.doUndefined(arg1Value, arg2Value);
            }
            if (arg1Value instanceof JSObject) {
                JSObject arg1Value_ = (JSObject) arg1Value;
                return AsPrimitiveNode.doJSObject(arg0Value, arg1Value_, arg2Value);
            }
            if ((JSGuards.isForeignObject(arg1Value))) {
                return AsPrimitiveNode.doForeignObject(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached()), (InlinedBranchProfile.getUncached()), (SwitchEncodingNode.getUncached()));
            }
            return doFallback(arg1Value, arg2Value, (this));
        }

    }
}
