// CheckStyle: start generated
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.runtime.BigInt;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSRightShiftNode#doInteger}
 *     Activation probability: 0.27381
 *     With/without class size: 7/0 bytes
 *   Specialization {@link JSRightShiftNode#doBigInt}
 *     Activation probability: 0.23095
 *     With/without class size: 8/4 bytes
 *   Specialization {@link JSRightShiftNode#doIntDouble}
 *     Activation probability: 0.18810
 *     With/without class size: 6/0 bytes
 *   Specialization {@link JSRightShiftNode#doDouble}
 *     Activation probability: 0.14524
 *     With/without class size: 7/8 bytes
 *   Specialization {@link JSRightShiftNode#doOverloaded}
 *     Activation probability: 0.10238
 *     With/without class size: 6/4 bytes
 *   Specialization {@link JSRightShiftNode#doGeneric}
 *     Activation probability: 0.05952
 *     With/without class size: 5/9 bytes
 * </pre> */
@GeneratedBy(JSRightShiftNode.class)
@SuppressWarnings("javadoc")
public final class JSRightShiftNodeGen extends JSRightShiftNode {

    private static final StateField GENERIC_JS_RIGHT_SHIFT_NODE_GENERIC_STATE_0_UPDATER = StateField.create(GenericData.lookup_(), "generic_state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSRightShiftNode#doGeneric}
     *   Parameter: {@link InlinedBranchProfile} mixedNumericTypes
     *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
    private static final InlinedBranchProfile INLINED_GENERIC_MIXED_NUMERIC_TYPES_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, GENERIC_JS_RIGHT_SHIFT_NODE_GENERIC_STATE_0_UPDATER.subUpdater(0, 1)));

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSRightShiftNode#doInteger}
     *   1: SpecializationActive {@link JSRightShiftNode#doGeneric}
     *   2: SpecializationActive {@link JSRightShiftNode#doBigInt}
     *   3: SpecializationActive {@link JSRightShiftNode#doIntDouble}
     *   4: SpecializationActive {@link JSRightShiftNode#doDouble}
     *   5: SpecializationActive {@link JSRightShiftNode#doOverloaded}
     *   6-8: ImplicitCast[type=double, index=1]
     *   9-11: ImplicitCast[type=double, index=0]
     * </pre> */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSRightShiftNode#doDouble}
     *   Parameter: {@link JSRightShiftNode} rightShift</pre> */
    @Child private JSRightShiftNode rightShift;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSRightShiftNode#doBigInt}
     *   Parameter: {@link JSLeftShiftNode} leftShift</pre> */
    @Child private JSLeftShiftNode bigInt_leftShift_;
    @Child private DoubleData double_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link JSRightShiftNode#doOverloaded}
     *   Parameter: {@link JSOverloadedBinaryNode} overloadedOperatorNode</pre> */
    @Child private JSOverloadedBinaryNode overloaded_overloadedOperatorNode_;
    @Child private GenericData generic_cache;

    private JSRightShiftNodeGen(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    @Override
    public Object execute(Object leftNodeValue, Object rightNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111111) != 0 /* is SpecializationActive[JSRightShiftNode.doInteger(int, int)] || SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] || SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] || SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] || SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSRightShiftNode.doInteger(int, int)] */ && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (int) leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_ = (int) rightNodeValue;
                    return doInteger(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] */ && leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_ = (BigInt) leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                    {
                        JSLeftShiftNode leftShift__ = this.bigInt_leftShift_;
                        if (leftShift__ != null) {
                            return doBigInt(leftNodeValue_, rightNodeValue_, leftShift__);
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] || SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue)) {
                double rightNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] */ && leftNodeValue instanceof Integer) {
                    int leftNodeValue_ = (int) leftNodeValue;
                    if ((!(JSBinaryNode.largerThan2e32(rightNodeValue_)))) {
                        return doIntDouble(leftNodeValue_, rightNodeValue_);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000000) >>> 9 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue)) {
                    double leftNodeValue_ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000000) >>> 9 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue);
                    DoubleData s3_ = this.double_cache;
                    if (s3_ != null) {
                        {
                            JSRightShiftNode rightShift_ = this.rightShift;
                            if (rightShift_ != null) {
                                return doDouble(leftNodeValue_, rightNodeValue_, rightShift_, s3_.leftInt32_, s3_.rightUInt32_);
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b100010) != 0 /* is SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] */) {
                    {
                        JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                        if (overloadedOperatorNode__ != null) {
                            if ((hasOverloadedOperators(leftNodeValue) || hasOverloadedOperators(rightNodeValue))) {
                                return doOverloaded(leftNodeValue, rightNodeValue, overloadedOperatorNode__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                    GenericData s5_ = this.generic_cache;
                    if (s5_ != null) {
                        {
                            JSRightShiftNode rightShift_1 = this.rightShift;
                            if (rightShift_1 != null) {
                                if ((!(hasOverloadedOperators(leftNodeValue))) && (!(hasOverloadedOperators(rightNodeValue)))) {
                                    Node node__ = (s5_);
                                    return JSRightShiftNode.doGeneric(leftNodeValue, rightNodeValue, node__, rightShift_1, s5_.leftToNumeric_, s5_.rightToNumeric_, INLINED_GENERIC_MIXED_NUMERIC_TYPES_);
                                }
                            }
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111110) == 0 /* only-active SpecializationActive[JSRightShiftNode.doInteger(int, int)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
            return execute_int_int0(state_0, frameValue);
        } else if ((state_0 & 0b110111) == 0 /* only-active SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
            return execute_int_double1(state_0, frameValue);
        } else if ((state_0 & 0b101111) == 0 /* only-active SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
            return execute_double_double2(state_0, frameValue);
        } else {
            return execute_generic3(state_0, frameValue);
        }
    }

    private Object execute_int_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSRightShiftNode.doInteger(int, int)] */;
        return doInteger(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_int_double1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        double rightNodeValue_;
        try {
            if ((state_0 & 0b110000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] */;
        if ((!(JSBinaryNode.largerThan2e32(rightNodeValue_)))) {
            return doIntDouble(leftNodeValue_, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) ? (Object) rightNodeValue_int : (Object) rightNodeValue_));
    }

    private Object execute_double_double2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int leftNodeValue_int = 0;
        double leftNodeValue_;
        try {
            if ((state_0 & 0b110000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                leftNodeValue_ = super.leftNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                leftNodeValue_int = super.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else {
                Object leftNodeValue__ = super.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000000) >>> 9 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        double rightNodeValue_;
        try {
            if ((state_0 & 0b110000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(((state_0 & 0b101000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) ? (Object) leftNodeValue_int : (Object) leftNodeValue_), ex.getResult());
        }
        assert (state_0 & 0b10000) != 0 /* is SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] */;
        DoubleData s3_ = this.double_cache;
        if (s3_ != null) {
            {
                JSRightShiftNode rightShift_ = this.rightShift;
                if (rightShift_ != null) {
                    return doDouble(leftNodeValue_, rightNodeValue_, rightShift_, s3_.leftInt32_, s3_.rightUInt32_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(((state_0 & 0b101000000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) ? (Object) leftNodeValue_int : (Object) leftNodeValue_), ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) ? (Object) rightNodeValue_int : (Object) rightNodeValue_));
    }

    private Object execute_generic3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object leftNodeValue_ = super.leftNode.execute(frameValue);
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        if ((state_0 & 0b111111) != 0 /* is SpecializationActive[JSRightShiftNode.doInteger(int, int)] || SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] || SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] || SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] || SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSRightShiftNode.doInteger(int, int)] */ && leftNodeValue_ instanceof Integer) {
                int leftNodeValue__ = (int) leftNodeValue_;
                if (rightNodeValue_ instanceof Integer) {
                    int rightNodeValue__ = (int) rightNodeValue_;
                    return doInteger(leftNodeValue__, rightNodeValue__);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] */ && leftNodeValue_ instanceof BigInt) {
                BigInt leftNodeValue__ = (BigInt) leftNodeValue_;
                if (rightNodeValue_ instanceof BigInt) {
                    BigInt rightNodeValue__ = (BigInt) rightNodeValue_;
                    {
                        JSLeftShiftNode leftShift__ = this.bigInt_leftShift_;
                        if (leftShift__ != null) {
                            return doBigInt(leftNodeValue__, rightNodeValue__, leftShift__);
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] || SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_)) {
                double rightNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] */ && leftNodeValue_ instanceof Integer) {
                    int leftNodeValue__ = (int) leftNodeValue_;
                    if ((!(JSBinaryNode.largerThan2e32(rightNodeValue__)))) {
                        return doIntDouble(leftNodeValue__, rightNodeValue__);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000000) >>> 9 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue_)) {
                    double leftNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000000) >>> 9 /* get-int ImplicitCast[type=double, index=0] */, leftNodeValue_);
                    DoubleData s3_ = this.double_cache;
                    if (s3_ != null) {
                        {
                            JSRightShiftNode rightShift_ = this.rightShift;
                            if (rightShift_ != null) {
                                return doDouble(leftNodeValue__, rightNodeValue__, rightShift_, s3_.leftInt32_, s3_.rightUInt32_);
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b100010) != 0 /* is SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] */) {
                    {
                        JSOverloadedBinaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                        if (overloadedOperatorNode__ != null) {
                            if ((hasOverloadedOperators(leftNodeValue_) || hasOverloadedOperators(rightNodeValue_))) {
                                return doOverloaded(leftNodeValue_, rightNodeValue_, overloadedOperatorNode__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                    GenericData s5_ = this.generic_cache;
                    if (s5_ != null) {
                        {
                            JSRightShiftNode rightShift_1 = this.rightShift;
                            if (rightShift_1 != null) {
                                if ((!(hasOverloadedOperators(leftNodeValue_))) && (!(hasOverloadedOperators(rightNodeValue_)))) {
                                    Node node__ = (s5_);
                                    return JSRightShiftNode.doGeneric(leftNodeValue_, rightNodeValue_, node__, rightShift_1, s5_.leftToNumeric_, s5_.rightToNumeric_, INLINED_GENERIC_MIXED_NUMERIC_TYPES_);
                                }
                            }
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110010) != 0 /* is SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] || SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] || SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        int leftNodeValue_;
        try {
            leftNodeValue_ = super.leftNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = super.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        if ((state_0 & 0b1000) == 0 /* only-active SpecializationActive[JSRightShiftNode.doInteger(int, int)] */ && ((state_0 & 0b1001) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] */)) {
            return executeInt_int4(state_0, frameValue, leftNodeValue_);
        } else if ((state_0 & 0b1) == 0 /* only-active SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] */ && ((state_0 & 0b1001) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] */)) {
            return executeInt_double5(state_0, frameValue, leftNodeValue_);
        } else {
            return executeInt_generic6(state_0, frameValue, leftNodeValue_);
        }
    }

    private int executeInt_int4(int state_0__, VirtualFrame frameValue, int leftNodeValue_) throws UnexpectedResultException {
        int state_0 = state_0__;
        int rightNodeValue_;
        try {
            rightNodeValue_ = super.rightNode.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[JSRightShiftNode.doInteger(int, int)] */;
        return doInteger(leftNodeValue_, rightNodeValue_);
    }

    private int executeInt_double5(int state_0__, VirtualFrame frameValue, int leftNodeValue_) throws UnexpectedResultException {
        int state_0 = state_0__;
        int rightNodeValue_int = 0;
        double rightNodeValue_;
        try {
            if ((state_0 & 0b110000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_ = super.rightNode.executeDouble(frameValue);
            } else if ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                rightNodeValue_int = super.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else {
                Object rightNodeValue__ = super.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] */;
        if ((!(JSBinaryNode.largerThan2e32(rightNodeValue_)))) {
            return doIntDouble(leftNodeValue_, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, ((state_0 & 0b101000000) == 0 /* only-active ImplicitCast[type=double, index=1] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) ? (Object) rightNodeValue_int : (Object) rightNodeValue_)));
    }

    private int executeInt_generic6(int state_0__, VirtualFrame frameValue, int leftNodeValue_) throws UnexpectedResultException {
        int state_0 = state_0__;
        Object rightNodeValue_ = super.rightNode.execute(frameValue);
        if ((state_0 & 0b1001) != 0 /* is SpecializationActive[JSRightShiftNode.doInteger(int, int)] || SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSRightShiftNode.doInteger(int, int)] */ && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__ = (int) rightNodeValue_;
                return doInteger(leftNodeValue_, rightNodeValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_)) {
                double rightNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, rightNodeValue_);
                if ((!(JSBinaryNode.largerThan2e32(rightNodeValue__)))) {
                    return doIntDouble(leftNodeValue_, rightNodeValue__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b110110) == 0 /* only-active SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] */ && ((state_0 & 0b111111) != 0  /* is-not SpecializationActive[JSRightShiftNode.doInteger(int, int)] && SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] && SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] && SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] && SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] && SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */)) {
                this.executeInt(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */ && leftNodeValue instanceof Integer) {
            int leftNodeValue_ = (int) leftNodeValue;
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (int) rightNodeValue;
                state_0 = state_0 | 0b1 /* add SpecializationActive[JSRightShiftNode.doInteger(int, int)] */;
                this.state_0_ = state_0;
                return doInteger(leftNodeValue_, rightNodeValue_);
            }
        }
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */ && leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_ = (BigInt) leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt) rightNodeValue;
                JSLeftShiftNode leftShift__ = this.insert((JSLeftShiftNode.create()));
                Objects.requireNonNull(leftShift__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.bigInt_leftShift_ = leftShift__;
                state_0 = state_0 | 0b100 /* add SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)] */;
                this.state_0_ = state_0;
                return doBigInt(leftNodeValue_, rightNodeValue_, leftShift__);
            }
        }
        {
            int doubleCast1;
            if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue)) != 0) {
                double rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */ && leftNodeValue instanceof Integer) {
                    int leftNodeValue_ = (int) leftNodeValue;
                    if ((!(JSBinaryNode.largerThan2e32(rightNodeValue_)))) {
                        state_0 = (state_0 | (doubleCast1 << 6) /* set-int ImplicitCast[type=double, index=1] */);
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[JSRightShiftNode.doIntDouble(int, double)] */;
                        this.state_0_ = state_0;
                        return doIntDouble(leftNodeValue_, rightNodeValue_);
                    }
                }
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */) {
                    int doubleCast0;
                    if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                        double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                        DoubleData s3_ = this.insert(new DoubleData());
                        JSRightShiftNode rightShift_;
                        JSRightShiftNode rightShift__shared = this.rightShift;
                        if (rightShift__shared != null) {
                            rightShift_ = rightShift__shared;
                        } else {
                            rightShift_ = s3_.insert((JSRightShiftNode.create()));
                            if (rightShift_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.rightShift == null) {
                            this.rightShift = rightShift_;
                        }
                        JSToInt32Node leftInt32__ = s3_.insert((JSToInt32Node.create()));
                        Objects.requireNonNull(leftInt32__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s3_.leftInt32_ = leftInt32__;
                        JSToUInt32Node rightUInt32__ = s3_.insert((JSToUInt32Node.create()));
                        Objects.requireNonNull(rightUInt32__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s3_.rightUInt32_ = rightUInt32__;
                        VarHandle.storeStoreFence();
                        this.double_cache = s3_;
                        state_0 = (state_0 | (doubleCast0 << 9) /* set-int ImplicitCast[type=double, index=0] */);
                        state_0 = (state_0 | (doubleCast1 << 6) /* set-int ImplicitCast[type=double, index=1] */);
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] */;
                        this.state_0_ = state_0;
                        return doDouble(leftNodeValue_, rightNodeValue_, rightShift_, leftInt32__, rightUInt32__);
                    }
                }
            }
        }
        if ((hasOverloadedOperators(leftNodeValue) || hasOverloadedOperators(rightNodeValue))) {
            JSOverloadedBinaryNode overloadedOperatorNode__ = this.insert((JSOverloadedBinaryNode.createNumeric(getOverloadedOperatorName())));
            Objects.requireNonNull(overloadedOperatorNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.overloaded_overloadedOperatorNode_ = overloadedOperatorNode__;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[JSRightShiftNode.doOverloaded(Object, Object, JSOverloadedBinaryNode)] */;
            this.state_0_ = state_0;
            return doOverloaded(leftNodeValue, rightNodeValue, overloadedOperatorNode__);
        }
        {
            Node node__ = null;
            if ((!(hasOverloadedOperators(leftNodeValue))) && (!(hasOverloadedOperators(rightNodeValue)))) {
                GenericData s5_ = this.insert(new GenericData());
                node__ = (s5_);
                JSRightShiftNode rightShift_1;
                JSRightShiftNode rightShift_1_shared = this.rightShift;
                if (rightShift_1_shared != null) {
                    rightShift_1 = rightShift_1_shared;
                } else {
                    rightShift_1 = s5_.insert((JSRightShiftNode.create()));
                    if (rightShift_1 == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.rightShift == null) {
                    this.rightShift = rightShift_1;
                }
                JSToNumericNode leftToNumeric__ = s5_.insert((JSToNumericNode.create()));
                Objects.requireNonNull(leftToNumeric__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s5_.leftToNumeric_ = leftToNumeric__;
                JSToNumericNode rightToNumeric__ = s5_.insert((JSToNumericNode.create()));
                Objects.requireNonNull(rightToNumeric__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s5_.rightToNumeric_ = rightToNumeric__;
                VarHandle.storeStoreFence();
                this.generic_cache = s5_;
                this.bigInt_leftShift_ = null;
                this.double_cache = null;
                state_0 = state_0 & 0xffffffe2 /* remove SpecializationActive[JSRightShiftNode.doInteger(int, int)], SpecializationActive[JSRightShiftNode.doBigInt(BigInt, BigInt, JSLeftShiftNode)], SpecializationActive[JSRightShiftNode.doIntDouble(int, double)], SpecializationActive[JSRightShiftNode.doDouble(double, double, JSRightShiftNode, JSToInt32Node, JSToUInt32Node)] */;
                state_0 = state_0 | 0b10 /* add SpecializationActive[JSRightShiftNode.doGeneric(Object, Object, Node, JSRightShiftNode, JSToNumericNode, JSToNumericNode, InlinedBranchProfile)] */;
                this.state_0_ = state_0;
                return JSRightShiftNode.doGeneric(leftNodeValue, rightNodeValue, node__, rightShift_1, leftToNumeric__, rightToNumeric__, INLINED_GENERIC_MIXED_NUMERIC_TYPES_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {super.leftNode, super.rightNode}, leftNodeValue, rightNodeValue);
    }

    @NeverDefault
    public static JSRightShiftNode create(JavaScriptNode left, JavaScriptNode right) {
        return new JSRightShiftNodeGen(left, right);
    }

    @GeneratedBy(JSRightShiftNode.class)
    @DenyReplace
    private static final class DoubleData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link JSRightShiftNode#doDouble}
         *   Parameter: {@link JSToInt32Node} leftInt32</pre> */
        @Child JSToInt32Node leftInt32_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSRightShiftNode#doDouble}
         *   Parameter: {@link JSToUInt32Node} rightUInt32</pre> */
        @Child JSToUInt32Node rightUInt32_;

        DoubleData() {
        }

    }
    @GeneratedBy(JSRightShiftNode.class)
    @DenyReplace
    private static final class GenericData extends Node implements SpecializationDataNode {

        /**
         * State Info: <pre>
         *   0: InlinedCache
         *        Specialization: {@link JSRightShiftNode#doGeneric}
         *        Parameter: {@link InlinedBranchProfile} mixedNumericTypes
         *        Inline method: {@link InlinedBranchProfile#inline}
         * </pre> */
        @CompilationFinal @UnsafeAccessedField private int generic_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSRightShiftNode#doGeneric}
         *   Parameter: {@link JSToNumericNode} leftToNumeric</pre> */
        @Child JSToNumericNode leftToNumeric_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSRightShiftNode#doGeneric}
         *   Parameter: {@link JSToNumericNode} rightToNumeric</pre> */
        @Child JSToNumericNode rightToNumeric_;

        GenericData() {
        }

        private static Lookup lookup_() {
            return MethodHandles.lookup();
        }

    }
}
