// CheckStyle: start generated
package com.oracle.truffle.js.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(ValueLibrary.class)
final class ValueLibraryGen extends LibraryFactory<ValueLibrary> {

    private static final Class<ValueLibrary> LIBRARY_CLASS = ValueLibraryGen.lazyLibraryClass();
    private static final Message IS_PROXY = new MessageImpl("isProxy", 0, false, boolean.class, Object.class);
    private static final Message IS_PROMISE = new MessageImpl("isPromise", 1, false, boolean.class, Object.class);
    private static final Message IS_ARRAY_BUFFER = new MessageImpl("isArrayBuffer", 2, false, boolean.class, Object.class);
    private static final Message TO_STRING = new MessageImpl("toString", 3, false, TruffleString.class, Object.class);
    private static final Message TO_NUMBER = new MessageImpl("toNumber", 4, false, Number.class, Object.class);
    private static final Message TO_BOOLEAN = new MessageImpl("toBoolean", 5, false, boolean.class, Object.class);
    private static final ValueLibraryGen INSTANCE = new ValueLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(ValueLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(ValueLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private ValueLibraryGen() {
        super(ValueLibraryGen.LIBRARY_CLASS, List.of(ValueLibraryGen.IS_PROXY, ValueLibraryGen.IS_PROMISE, ValueLibraryGen.IS_ARRAY_BUFFER, ValueLibraryGen.TO_STRING, ValueLibraryGen.TO_NUMBER, ValueLibraryGen.TO_BOOLEAN));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return ValueLibrary.class;
    }

    @Override
    protected Lookup getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    protected ValueLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected ValueLibrary createDelegate(ValueLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        ValueLibrary lib = (ValueLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                return lib.isProxy(receiver);
            case 1 :
                return lib.isPromise(receiver);
            case 2 :
                return lib.isArrayBuffer(receiver);
            case 3 :
                return lib.toString(receiver);
            case 4 :
                return lib.toNumber(receiver);
            case 5 :
                return lib.toBoolean(receiver);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected ValueLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected ValueLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<ValueLibrary> lazyLibraryClass() {
        try {
            return (Class<ValueLibrary>) Class.forName("com.oracle.truffle.js.api.ValueLibrary", false, ValueLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(ValueLibrary.class)
    private static final class Default extends LibraryExport<ValueLibrary> {

        private Default() {
            super(ValueLibrary.class, Object.class, false, false, 0);
        }

        @Override
        protected ValueLibrary createUncached(Object receiver) {
            ValueLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected ValueLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(ValueLibrary.class)
        private static final class Cached extends ValueLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isProxy(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isProxy((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean isPromise(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPromise((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean isArrayBuffer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isArrayBuffer((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public TruffleString toString(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.toString((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public Number toNumber(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.toNumber((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean toBoolean(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.toBoolean((dynamicDispatch_.cast(receiver)));
            }

        }
        @GeneratedBy(ValueLibrary.class)
        @DenyReplace
        private static final class Uncached extends ValueLibrary implements UnadoptableNode {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @TruffleBoundary
            @Override
            public boolean isProxy(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isProxy(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean isPromise(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPromise(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean isArrayBuffer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isArrayBuffer(receiver);
            }

            @TruffleBoundary
            @Override
            public TruffleString toString(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.toString(receiver);
            }

            @TruffleBoundary
            @Override
            public Number toNumber(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.toNumber(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean toBoolean(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.toBoolean(receiver);
            }

        }
    }
    @GeneratedBy(ValueLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(ValueLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(ValueLibrary.class)
    private static final class Proxy extends ValueLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isProxy(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, ValueLibraryGen.IS_PROXY);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean isPromise(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, ValueLibraryGen.IS_PROMISE);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean isArrayBuffer(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, ValueLibraryGen.IS_ARRAY_BUFFER);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public TruffleString toString(Object receiver_) {
            try {
                return (TruffleString) lib.send(receiver_, ValueLibraryGen.TO_STRING);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Number toNumber(Object receiver_) {
            try {
                return (Number) lib.send(receiver_, ValueLibraryGen.TO_NUMBER);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean toBoolean(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, ValueLibraryGen.TO_BOOLEAN);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(ValueLibrary.class)
    private static final class Delegate extends ValueLibrary {

        @Child private ValueLibrary delegateLibrary;

        Delegate(ValueLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isProxy(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isProxy(delegate);
            } else {
                return this.delegateLibrary.isProxy(receiver_);
            }
        }

        @Override
        public boolean isPromise(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isPromise(delegate);
            } else {
                return this.delegateLibrary.isPromise(receiver_);
            }
        }

        @Override
        public boolean isArrayBuffer(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isArrayBuffer(delegate);
            } else {
                return this.delegateLibrary.isArrayBuffer(receiver_);
            }
        }

        @Override
        public TruffleString toString(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 3)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).toString(delegate);
            } else {
                return this.delegateLibrary.toString(receiver_);
            }
        }

        @Override
        public Number toNumber(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 4)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).toNumber(delegate);
            } else {
                return this.delegateLibrary.toNumber(receiver_);
            }
        }

        @Override
        public boolean toBoolean(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 5)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).toBoolean(delegate);
            } else {
                return this.delegateLibrary.toBoolean(receiver_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(ValueLibrary.class)
    private static final class CachedToUncachedDispatch extends ValueLibrary {

        @TruffleBoundary
        @Override
        public boolean isProxy(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isProxy(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public boolean isPromise(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isPromise(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public boolean isArrayBuffer(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isArrayBuffer(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public TruffleString toString(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).toString(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Number toNumber(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).toNumber(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public boolean toBoolean(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).toBoolean(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(ValueLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends ValueLibrary implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public boolean isProxy(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isProxy(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean isPromise(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isPromise(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean isArrayBuffer(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isArrayBuffer(receiver_);
        }

        @TruffleBoundary
        @Override
        public TruffleString toString(Object receiver_) {
            return INSTANCE.getUncached(receiver_).toString(receiver_);
        }

        @TruffleBoundary
        @Override
        public Number toNumber(Object receiver_) {
            return INSTANCE.getUncached(receiver_).toNumber(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean toBoolean(Object receiver_) {
            return INSTANCE.getUncached(receiver_).toBoolean(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(ValueLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(ValueLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

    }
    @GeneratedBy(ValueLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(ValueLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

    }
    @GeneratedBy(ValueLibrary.class)
    private abstract static class CachedDispatch extends ValueLibrary {

        @Child ValueLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(ValueLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop
        @Override
        public boolean isProxy(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    ValueLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isProxy(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public boolean isPromise(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    ValueLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isPromise(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public boolean isArrayBuffer(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    ValueLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isArrayBuffer(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public TruffleString toString(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    ValueLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.toString(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Number toNumber(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    ValueLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.toNumber(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public boolean toBoolean(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    ValueLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.toBoolean(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                ValueLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        ValueLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
