// CheckStyle: start generated
package com.oracle.truffle.js.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.js.api.PromiseLibrary.State;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(PromiseLibrary.class)
final class PromiseLibraryGen extends LibraryFactory<PromiseLibrary> {

    private static final Class<PromiseLibrary> LIBRARY_CLASS = PromiseLibraryGen.lazyLibraryClass();
    private static final Message IS_PROMISE = new MessageImpl("isPromise", 0, false, boolean.class, Object.class);
    private static final Message GET_STATE = new MessageImpl("getState", 1, false, State.class, Object.class);
    private static final Message MARK_HANDLED = new MessageImpl("markHandled", 2, false, void.class, Object.class);
    private static final PromiseLibraryGen INSTANCE = new PromiseLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(PromiseLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(PromiseLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private PromiseLibraryGen() {
        super(PromiseLibraryGen.LIBRARY_CLASS, List.of(PromiseLibraryGen.IS_PROMISE, PromiseLibraryGen.GET_STATE, PromiseLibraryGen.MARK_HANDLED));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return PromiseLibrary.class;
    }

    @Override
    protected Lookup getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    protected PromiseLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected PromiseLibrary createDelegate(PromiseLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        PromiseLibrary lib = (PromiseLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                return lib.isPromise(receiver);
            case 1 :
                return lib.getState(receiver);
            case 2 :
                lib.markHandled(receiver);
                return null;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected PromiseLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected PromiseLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<PromiseLibrary> lazyLibraryClass() {
        try {
            return (Class<PromiseLibrary>) Class.forName("com.oracle.truffle.js.api.PromiseLibrary", false, PromiseLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(PromiseLibrary.class)
    private static final class Default extends LibraryExport<PromiseLibrary> {

        private Default() {
            super(PromiseLibrary.class, Object.class, false, false, 0);
        }

        @Override
        protected PromiseLibrary createUncached(Object receiver) {
            PromiseLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected PromiseLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(PromiseLibrary.class)
        private static final class Cached extends PromiseLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isPromise(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPromise((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public State getState(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getState((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public void markHandled(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.markHandled((dynamicDispatch_.cast(receiver)));
                return;
            }

        }
        @GeneratedBy(PromiseLibrary.class)
        @DenyReplace
        private static final class Uncached extends PromiseLibrary implements UnadoptableNode {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @TruffleBoundary
            @Override
            public boolean isPromise(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPromise(receiver);
            }

            @TruffleBoundary
            @Override
            public State getState(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.getState(receiver);
            }

            @TruffleBoundary
            @Override
            public void markHandled(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                super.markHandled(receiver);
                return;
            }

        }
    }
    @GeneratedBy(PromiseLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(PromiseLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(PromiseLibrary.class)
    private static final class Proxy extends PromiseLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isPromise(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, PromiseLibraryGen.IS_PROMISE);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public State getState(Object receiver_) throws UnsupportedMessageException {
            try {
                return (State) lib.send(receiver_, PromiseLibraryGen.GET_STATE);
            } catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public void markHandled(Object receiver_) throws UnsupportedMessageException {
            try {
                lib.send(receiver_, PromiseLibraryGen.MARK_HANDLED);
                return;
            } catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(PromiseLibrary.class)
    private static final class Delegate extends PromiseLibrary {

        @Child private PromiseLibrary delegateLibrary;

        Delegate(PromiseLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isPromise(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isPromise(delegate);
            } else {
                return this.delegateLibrary.isPromise(receiver_);
            }
        }

        @Override
        public State getState(Object receiver_) throws UnsupportedMessageException {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getState(delegate);
            } else {
                return this.delegateLibrary.getState(receiver_);
            }
        }

        @Override
        public void markHandled(Object receiver_) throws UnsupportedMessageException {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).markHandled(delegate);
                return;
            } else {
                this.delegateLibrary.markHandled(receiver_);
                return;
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(PromiseLibrary.class)
    private static final class CachedToUncachedDispatch extends PromiseLibrary {

        @TruffleBoundary
        @Override
        public boolean isPromise(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isPromise(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public State getState(Object receiver_) throws UnsupportedMessageException {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getState(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public void markHandled(Object receiver_) throws UnsupportedMessageException {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).markHandled(receiver_);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(PromiseLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends PromiseLibrary implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public boolean isPromise(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isPromise(receiver_);
        }

        @TruffleBoundary
        @Override
        public State getState(Object receiver_) throws UnsupportedMessageException {
            return INSTANCE.getUncached(receiver_).getState(receiver_);
        }

        @TruffleBoundary
        @Override
        public void markHandled(Object receiver_) throws UnsupportedMessageException {
            INSTANCE.getUncached(receiver_).markHandled(receiver_);
            return;
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(PromiseLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(PromiseLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

    }
    @GeneratedBy(PromiseLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(PromiseLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

    }
    @GeneratedBy(PromiseLibrary.class)
    private abstract static class CachedDispatch extends PromiseLibrary {

        @Child PromiseLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(PromiseLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop
        @Override
        public boolean isPromise(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    PromiseLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isPromise(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public State getState(Object receiver_) throws UnsupportedMessageException {
            do {
                CachedDispatch current = this;
                do {
                    PromiseLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getState(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public void markHandled(Object receiver_) throws UnsupportedMessageException {
            do {
                CachedDispatch current = this;
                do {
                    PromiseLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.markHandled(receiver_);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                PromiseLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        PromiseLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
