/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSLanguageOptions;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSURLDecoder;
import com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSModuleData;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.polyglot.io.ByteSequence;

public class DefaultESModuleLoader
implements JSModuleLoader {
    public static final String DOT = ".";
    public static final String SLASH = "/";
    public static final String DOT_SLASH = "./";
    public static final String DOT_DOT_SLASH = "../";
    private static final String DATA_URI_SOURCE_NAME_PREFIX = "data-uri";
    protected final JSRealm realm;
    protected final Map<String, AbstractModuleRecord> moduleMap = new HashMap<String, AbstractModuleRecord>();

    public static DefaultESModuleLoader create(JSRealm realm) {
        return new DefaultESModuleLoader(realm);
    }

    protected DefaultESModuleLoader(JSRealm realm) {
        this.realm = realm;
    }

    protected URI asURI(String specifier) {
        assert (specifier != null);
        if (specifier.indexOf(58) == -1) {
            return null;
        }
        try {
            URI uri = new URI(specifier);
            return uri.isAbsolute() ? uri : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public AbstractModuleRecord resolveImportedModule(ScriptOrModule referrer, Module.ModuleRequest moduleRequest) {
        URI refURI = null;
        String refPath = null;
        String refPathOrName = null;
        if (referrer != null) {
            Source referrerSource = referrer.getSource();
            refURI = DefaultESModuleLoader.isNonFileURLSource(referrerSource) ? referrerSource.getURI() : null;
            refPath = referrerSource.getPath();
            refPathOrName = refPath != null ? refPath : referrerSource.getName();
        }
        try {
            TruffleFile moduleFile;
            String canonicalPath;
            TruffleString specifierTS = moduleRequest.specifier();
            String specifier = Strings.toJavaString(specifierTS);
            if (specifier.startsWith("data:")) {
                return this.loadModuleFromDataURL(referrer, moduleRequest, specifier);
            }
            URI maybeUri = this.asURI(specifier);
            TruffleString maybeCustomPath = this.realm.getCustomEsmPathMapping(refPath == null ? null : Strings.fromJavaString(refPath), specifierTS);
            TruffleLanguage.Env env = this.realm.getEnv();
            if (maybeCustomPath != null) {
                canonicalPath = maybeCustomPath.toJavaStringUncached();
                moduleFile = DefaultESModuleLoader.getCanonicalFileIfExists(env.getPublicTruffleFile(canonicalPath), env);
            } else {
                if (refURI != null || maybeUri != null && !DefaultESModuleLoader.isFileURI(maybeUri)) {
                    URI moduleURI = maybeUri != null ? maybeUri : DefaultESModuleLoader.resolveSibling(refURI, specifier);
                    return this.loadModuleFromURL(referrer, moduleRequest, moduleURI);
                }
                if (refPath == null) {
                    moduleFile = maybeUri != null ? env.getPublicTruffleFile(maybeUri) : env.getPublicTruffleFile(specifier);
                } else {
                    TruffleFile refFile = env.getPublicTruffleFile(refPath);
                    if (maybeUri != null) {
                        String uriFile = env.getPublicTruffleFile(maybeUri).getCanonicalFile(new LinkOption[0]).getPath();
                        moduleFile = refFile.resolveSibling(uriFile);
                    } else {
                        moduleFile = !env.isFileIOAllowed() || this.bareSpecifierDirectLookup(specifier) ? env.getPublicTruffleFile(specifier) : refFile.resolveSibling(specifier);
                    }
                }
                canonicalPath = null;
            }
            return this.loadModuleFromFile(referrer, moduleRequest, moduleFile, canonicalPath);
        }
        catch (FileSystemException fsex) {
            throw this.createErrorFromFileSystemException(fsex, refPathOrName);
        }
        catch (IOException | IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
            throw Errors.createErrorFromException(e);
        }
    }

    private JSException createErrorFromFileSystemException(FileSystemException fsex, String refPath) {
        String fileName = fsex.getFile();
        if (this.realm.getContext().getLanguageOptions().testV8Mode()) {
            String message = "d8: Error reading module from " + fileName;
            if (refPath != null) {
                message = message + " imported by " + refPath;
            }
            return Errors.createError(message, fsex);
        }
        String reason = fsex.getReason();
        String message = null;
        if (reason == null) {
            if (fsex instanceof NoSuchFileException) {
                message = "Cannot find module";
            } else if (fsex instanceof AccessDeniedException) {
                message = "Cannot access module";
            }
        }
        message = DefaultESModuleLoader.buildErrorMessage(message, fileName, refPath, reason);
        return Errors.createError(message, fsex);
    }

    private static String buildErrorMessage(String causeMessage, String fileName, String refPath, String reason) {
        Object message = causeMessage;
        if (message == null) {
            message = "Error reading module";
        }
        message = (String)message + " '" + fileName + "'";
        if (refPath != null) {
            message = (String)message + " imported from " + refPath;
        }
        if (reason != null) {
            message = (String)message + ": " + reason;
        }
        return message;
    }

    private static JSException createErrorUnsupportedPhase(ScriptOrModule referrer, Module.ModuleRequest moduleRequest) {
        String refPath = referrer != null ? referrer.getSource().getName() : null;
        return Errors.createError(DefaultESModuleLoader.buildErrorMessage(null, moduleRequest.specifier().toJavaStringUncached(), refPath, String.valueOf((Object)moduleRequest.phase()) + " phase imports not supported for this type of module"));
    }

    private boolean bareSpecifierDirectLookup(String specifier) {
        JSLanguageOptions options = this.realm.getContext().getLanguageOptions();
        if (options.esmBareSpecifierRelativeLookup()) {
            return false;
        }
        return !specifier.startsWith(SLASH) && !specifier.startsWith(DOT_SLASH) && !specifier.startsWith(DOT_DOT_SLASH);
    }

    private static boolean isFileURI(URI uri) {
        return uri.isAbsolute() && "file".equals(uri.getScheme());
    }

    private static boolean isNonFileURLSource(Source source) {
        return source.getURL() != null && !"file".equals(source.getURL().getProtocol());
    }

    protected AbstractModuleRecord loadModuleFromURL(ScriptOrModule referrer, Module.ModuleRequest moduleRequest, URI moduleURI) throws IOException {
        assert (!DefaultESModuleLoader.isFileURI(moduleURI)) : moduleURI;
        String canonicalPath = moduleURI.toString();
        AbstractModuleRecord existingModule = this.moduleMap.get(canonicalPath);
        if (existingModule != null) {
            return existingModule;
        }
        TruffleLanguage.Env env = this.realm.getEnv();
        if (env.isFileIOAllowed()) {
            try {
                TruffleFile moduleFile = env.getPublicTruffleFile(moduleURI);
                return this.loadModuleFromFile(referrer, moduleRequest, moduleFile, canonicalPath);
            }
            catch (IllegalArgumentException | UnsupportedOperationException moduleFile) {
                // empty catch block
            }
        }
        if (!env.isSocketIOAllowed()) {
            throw new AccessDeniedException(canonicalPath, null, "Socket IO is not allowed");
        }
        URL url = DefaultESModuleLoader.uriToURL(moduleURI);
        String mimeType = this.findMimeType(url);
        String language = DefaultESModuleLoader.findLanguage(mimeType);
        Source source = Source.newBuilder((String)language, (URL)url).mimeType(mimeType).build();
        return this.loadModuleFromSource(referrer, moduleRequest, source, mimeType, canonicalPath);
    }

    private static URL uriToURL(URI moduleURI) throws MalformedURLException {
        return moduleURI.toURL();
    }

    protected AbstractModuleRecord loadModuleFromFile(ScriptOrModule referrer, Module.ModuleRequest moduleRequest, TruffleFile moduleFile, String maybeCanonicalPath) throws IOException {
        String canonicalPath;
        TruffleFile canonicalFile;
        TruffleLanguage.Env env = this.realm.getEnv();
        if (maybeCanonicalPath == null) {
            canonicalFile = DefaultESModuleLoader.getCanonicalFileIfExists(moduleFile, env);
            canonicalPath = canonicalFile.getPath();
        } else {
            canonicalFile = moduleFile;
            canonicalPath = maybeCanonicalPath;
        }
        AbstractModuleRecord existingModule = this.moduleMap.get(canonicalPath);
        if (existingModule != null) {
            return existingModule;
        }
        String mimeType = this.findMimeType(canonicalFile);
        String language = DefaultESModuleLoader.findLanguage(mimeType);
        Source source = Source.newBuilder((String)language, (TruffleFile)canonicalFile).name(Strings.toJavaString(moduleRequest.specifier())).mimeType(mimeType).build();
        return this.loadModuleFromSource(referrer, moduleRequest, source, mimeType, canonicalPath);
    }

    private AbstractModuleRecord loadModuleFromSource(ScriptOrModule referrer, Module.ModuleRequest moduleRequest, Source source, String mimeType, String canonicalPath) {
        Map<TruffleString, TruffleString> attributes = moduleRequest.attributes();
        TruffleString assertedType = attributes.get(JSContext.getTypeImportAttribute());
        if (!DefaultESModuleLoader.doesModuleTypeMatchAssertionType(assertedType, mimeType)) {
            throw Errors.createTypeError("Invalid module type was asserted");
        }
        JSModuleRecord newModule = switch (mimeType) {
            case "application/json" -> this.realm.getContext().getEvaluator().parseJSONModule(this.realm, source);
            case "application/wasm" -> {
                if (this.realm.getContextOptions().isWebAssembly()) {
                    yield this.realm.getContext().getEvaluator().parseWasmModuleSource(this.realm, source);
                }
                throw DefaultESModuleLoader.createErrorUnsupportedPhase(referrer, moduleRequest);
            }
            default -> {
                JSModuleData parsedModule = this.realm.getContext().getEvaluator().envParseModule(this.realm, source);
                yield new JSModuleRecord(parsedModule, this);
            }
        };
        this.moduleMap.put(canonicalPath, newModule);
        if (referrer != null) {
            referrer.rememberImportedModuleSource(moduleRequest.specifier(), source);
        }
        return newModule;
    }

    private AbstractModuleRecord loadModuleFromDataURL(ScriptOrModule referrer, Module.ModuleRequest moduleRequest, String specifier) {
        Source source;
        Charset charset;
        int commaPos;
        assert (specifier.startsWith("data:")) : specifier;
        int startPos = "data:".length();
        String input = specifier;
        URI.create(input);
        int fragmentPos = specifier.indexOf(35, startPos);
        if (fragmentPos != -1) {
            input = specifier.substring(0, fragmentPos);
        }
        if ((commaPos = input.indexOf(44, startPos)) < 0) {
            throw new IllegalArgumentException("Invalid data URL");
        }
        int mimeTypeStart = startPos;
        int mimeTypeEnd = commaPos;
        int encodedBodyStart = commaPos + 1;
        int encodedBodyEnd = input.length();
        boolean base64 = false;
        int lastSemicolon = input.lastIndexOf(59, mimeTypeEnd);
        if (lastSemicolon >= mimeTypeStart && DefaultESModuleLoader.regionEqualsIgnoreCase(input, lastSemicolon + 1, mimeTypeEnd, "base64")) {
            base64 = true;
            mimeTypeEnd = lastSemicolon;
        }
        int firstSemicolon = DefaultESModuleLoader.indexOf(input, ';', mimeTypeStart, mimeTypeEnd);
        int parametersStart = -1;
        int parametersEnd = -1;
        if (firstSemicolon >= 0) {
            parametersStart = firstSemicolon + 1;
            parametersEnd = mimeTypeEnd;
            mimeTypeEnd = firstSemicolon;
        }
        String mimeType = input.substring(mimeTypeStart, mimeTypeEnd);
        mimeType = this.filterSupportedMimeType(mimeType, "application/javascript+module");
        String language = DefaultESModuleLoader.findLanguage(mimeType);
        String sourceName = switch (mimeType) {
            case "application/json" -> "data-uri.json";
            case "application/wasm" -> "data-uri.wasm";
            default -> "data-uri.mjs";
        };
        boolean useByteSource = mimeType.equals("application/wasm");
        if (useByteSource) {
            charset = StandardCharsets.ISO_8859_1;
        } else {
            charset = StandardCharsets.US_ASCII;
            String charsetName = DefaultESModuleLoader.findMimeTypeParameter(input, parametersStart, parametersEnd, "charset");
            if (charsetName != null) {
                charset = DefaultESModuleLoader.charsetForNameWithFallback(charsetName, charset);
            }
        }
        String encodedBody = specifier.substring(encodedBodyStart, encodedBodyEnd);
        if (base64) {
            byte[] decodedBytes = Base64.getDecoder().decode(encodedBody);
            if (useByteSource) {
                source = Source.newBuilder((String)language, (ByteSequence)ByteSequence.create((byte[])decodedBytes), (String)sourceName).mimeType(mimeType).build();
            } else {
                String decoded = new String(decodedBytes, charset);
                source = Source.newBuilder((String)language, (CharSequence)decoded, (String)sourceName).mimeType(mimeType).build();
            }
        } else {
            String decoded = JSURLDecoder.decodePercentEncoding(encodedBody, charset);
            if (useByteSource) {
                byte[] decodedBytes = decoded.getBytes(StandardCharsets.ISO_8859_1);
                source = Source.newBuilder((String)language, (ByteSequence)ByteSequence.create((byte[])decodedBytes), (String)sourceName).mimeType(mimeType).build();
            } else {
                source = Source.newBuilder((String)language, (CharSequence)decoded, (String)sourceName).mimeType(mimeType).build();
            }
        }
        return this.loadModuleFromSource(referrer, moduleRequest, source, mimeType, specifier);
    }

    private static boolean regionEqualsIgnoreCase(String input, int start, int end, String match) {
        return end - start == match.length() && input.regionMatches(true, start, match, 0, match.length());
    }

    private static int indexOf(String input, char ch, int start, int end) {
        int index = input.indexOf(ch, start);
        return index < end ? index : -1;
    }

    private static Charset charsetForNameWithFallback(String charsetName, Charset fallback) {
        try {
            if (Charset.isSupported(charsetName)) {
                return Charset.forName(charsetName);
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            // empty catch block
        }
        return fallback;
    }

    private static String findMimeTypeParameter(String input, int inputStart, int inputEnd, String paramName) {
        int paramStart = inputStart;
        while (paramStart < inputEnd) {
            int valueStart;
            int valueEnd;
            int nextParamStart;
            int paramLimit = DefaultESModuleLoader.indexOf(input, ';', paramStart, inputEnd);
            if (paramLimit == -1) {
                paramLimit = inputEnd;
                nextParamStart = inputEnd;
            } else {
                nextParamStart = paramLimit + 1;
            }
            int equalPos = DefaultESModuleLoader.indexOf(input, '=', paramStart, paramLimit);
            if (equalPos != -1 && DefaultESModuleLoader.regionEqualsIgnoreCase(input, paramStart, equalPos, paramName) && (valueEnd = paramLimit) - (valueStart = equalPos + 1) > 0) {
                return input.substring(valueStart, valueEnd);
            }
            paramStart = nextParamStart;
        }
        return null;
    }

    private String findMimeType(TruffleFile moduleFile) {
        String foundMimeType;
        String defaultMimeType = "application/javascript+module";
        if (moduleFile == null) {
            return "application/javascript+module";
        }
        try {
            foundMimeType = Source.findMimeType((TruffleFile)moduleFile);
        }
        catch (IOException | SecurityException e) {
            foundMimeType = null;
        }
        if (foundMimeType == null) {
            foundMimeType = DefaultESModuleLoader.findMimeTypeFromExtension(moduleFile.getName());
        }
        return this.filterSupportedMimeType(foundMimeType, "application/javascript+module");
    }

    private String findMimeType(URL moduleUrl) {
        String foundMimeType;
        String defaultMimeType = "application/javascript+module";
        if (moduleUrl == null) {
            return "application/javascript+module";
        }
        try {
            foundMimeType = Source.findMimeType((URL)moduleUrl);
        }
        catch (IOException | SecurityException e) {
            foundMimeType = null;
        }
        if (foundMimeType == null && moduleUrl.getPath() != null) {
            foundMimeType = DefaultESModuleLoader.findMimeTypeFromExtension(moduleUrl.getPath());
        }
        return this.filterSupportedMimeType(foundMimeType, "application/javascript+module");
    }

    private String filterSupportedMimeType(String foundMimeType, String defaultMimeType) {
        String mimeType = defaultMimeType;
        if ("application/json".equals(foundMimeType)) {
            if (this.realm.getContextOptions().isJsonModules()) {
                mimeType = "application/json";
            }
        } else if ("application/wasm".equals(foundMimeType)) {
            mimeType = "application/wasm";
        }
        return mimeType;
    }

    private static String findMimeTypeFromExtension(String moduleName) {
        if (moduleName.endsWith(".json")) {
            return "application/json";
        }
        if (moduleName.endsWith(".wasm")) {
            return "application/wasm";
        }
        return null;
    }

    private static String findLanguage(String mimeType) {
        String language = "js";
        if ("application/wasm".equals(mimeType)) {
            language = "wasm";
        }
        return language;
    }

    private static boolean doesModuleTypeMatchAssertionType(TruffleString assertedType, String mimeType) {
        if (assertedType == null) {
            return true;
        }
        if (Strings.equals(Strings.JSON, assertedType)) {
            return mimeType.equals("application/json");
        }
        return false;
    }

    @Override
    public AbstractModuleRecord addLoadedModule(Module.ModuleRequest moduleRequest, AbstractModuleRecord moduleRecord) {
        String canonicalPath = this.getCanonicalPath(moduleRecord.getSource());
        return this.moduleMap.putIfAbsent(canonicalPath, moduleRecord);
    }

    private String getCanonicalPath(Source source) {
        String canonicalPath;
        if (DefaultESModuleLoader.isNonFileURLSource(source)) {
            return source.getURI().toString();
        }
        String path = source.getPath();
        if (path == null) {
            canonicalPath = source.getName();
        } else {
            try {
                TruffleLanguage.Env env = this.realm.getEnv();
                if (env.getFileNameSeparator().equals("\\") && path.startsWith(SLASH)) {
                    path = path.substring(1);
                }
                TruffleFile moduleFile = env.getPublicTruffleFile(path);
                if (env.isFileIOAllowed() && moduleFile.exists(new LinkOption[0])) {
                    try {
                        canonicalPath = moduleFile.getCanonicalFile(new LinkOption[0]).getPath();
                    }
                    catch (NoSuchFileException ex) {
                        canonicalPath = path;
                    }
                } else {
                    canonicalPath = path;
                }
            }
            catch (IOException | IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
                throw Errors.createErrorFromException(e);
            }
        }
        return canonicalPath;
    }

    private static TruffleFile getCanonicalFileIfExists(TruffleFile file, TruffleLanguage.Env env) throws IOException {
        if (env.isFileIOAllowed() && file.exists(new LinkOption[0])) {
            try {
                return file.getCanonicalFile(new LinkOption[0]);
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
        return file;
    }

    private static URI resolveSibling(URI refURI, String specifier) {
        URI uri = URI.create(specifier);
        if (uri.isAbsolute()) {
            return uri;
        }
        if (refURI.isOpaque() && "jar".equals(refURI.getScheme())) {
            String schemeSpecificPart = refURI.getRawSchemeSpecificPart();
            int pathStart = schemeSpecificPart.indexOf("!/") + 1;
            String newPath = URI.create(schemeSpecificPart.substring(pathStart)).resolve(uri).getRawPath();
            assert (newPath.startsWith(SLASH)) : newPath;
            return URI.create(refURI.getScheme() + ":" + schemeSpecificPart.substring(0, pathStart) + newPath);
        }
        return refURI.resolve(uri);
    }
}

