/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.time.LocalDate;
import java.time.LocalTime;

@ExportLibrary(value=InteropLibrary.class)
public final class JSTemporalPlainDateTimeObject
extends JSTemporalCalendarHolder {
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final int milliseconds;
    private final int microseconds;
    private final int nanoseconds;
    private final int year;
    private final int month;
    private final int day;

    protected JSTemporalPlainDateTimeObject(Shape shape, JSDynamicObject proto, int year, int month, int day, int hours, int minutes, int seconds, int milliseconds, int microseconds, int nanoseconds, Object calendar) {
        super(shape, proto, calendar);
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
        this.microseconds = microseconds;
        this.nanoseconds = nanoseconds;
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public int getHour() {
        return this.hours;
    }

    public int getMinute() {
        return this.minutes;
    }

    public int getSecond() {
        return this.seconds;
    }

    public int getMillisecond() {
        return this.milliseconds;
    }

    public int getMicrosecond() {
        return this.microseconds;
    }

    public int getNanosecond() {
        return this.nanoseconds;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    @ExportMessage
    boolean isTime() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalTime asTime() {
        int ns = this.milliseconds * 1000000 + this.microseconds * 1000 + this.nanoseconds;
        return LocalTime.of(this.hours, this.minutes, this.seconds, ns);
    }

    @ExportMessage
    boolean isDate() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalDate asDate() {
        return LocalDate.of(this.year, this.month, this.day);
    }

    @Override
    public TruffleString getClassName() {
        return JSTemporalPlainDateTime.TO_STRING_TAG;
    }
}

