/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;

public final class Boundaries {
    private Boundaries() {
    }

    @CompilerDirectives.TruffleBoundary
    public static String stringFormat(String format, Object ... params) {
        return String.format(format, params);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean characterIsUpperCase(char ch) {
        return Character.isUpperCase(ch);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equals(Object a, Object b) {
        return a.equals(b);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static <K, V> Map.Entry<K, V> mapEntry(K key, V value) {
        return Map.entry(key, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V mapPut(Map<K, V> map, K key, V value) {
        return map.put(key, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V mapPutIfAbsent(Map<K, V> map, K key, V value) {
        return map.putIfAbsent(key, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> boolean mapContainsKey(Map<K, V> map, K key) {
        return map.containsKey(key);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V mapGet(Map<K, V> map, K key) {
        return map.get(key);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V mapRemove(Map<K, V> map, K key) {
        return map.remove(key);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> T listGet(List<T> list, int index) {
        return list.get(index);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> int listSize(List<T> list) {
        return list.size();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> void listAdd(List<T> list, T element) {
        list.add(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> void listAddAll(List<T> list, List<T> addList) {
        list.addAll(addList);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> boolean listContains(List<T> list, T element) {
        return list.contains(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean listContainsUnchecked(List<?> list, Object element) {
        return list.contains(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> Object[] listToArray(List<T> list) {
        return list.toArray();
    }

    @CompilerDirectives.TruffleBoundary
    public static String[] listToStringArray(List<String> list) {
        return list.toArray(new String[0]);
    }

    public static <T> List<T> listToEditable(List<T> list) {
        if (list instanceof ArrayList) {
            return list;
        }
        return Boundaries.listEditableCopy(list);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> List<T> listEditableCopy(List<T> list) {
        return new ArrayList<T>(list);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> EconomicSet<T> economicSetCreate() {
        return EconomicSet.create();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> boolean economicSetAdd(EconomicSet<T> economicSet, T element) {
        return economicSet.add(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> boolean economicSetContains(EconomicSet<T> economicSet, T element) {
        return economicSet.contains(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> EconomicMap<K, V> economicMapCreate() {
        return EconomicMap.create();
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V economicMapPut(EconomicMap<K, V> map, K key, V value) {
        return (V)map.put(key, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> boolean economicMapContainsKey(EconomicMap<K, V> map, K key) {
        return map.containsKey(key);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V economicMapGet(EconomicMap<K, V> map, K key) {
        return (V)map.get(key);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static byte[] byteBufferArray(ByteBuffer buffer) {
        return buffer.array();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void byteBufferPutSlice(ByteBuffer dst, int dstPos, ByteBuffer src, int srcPos, int srcLimit) {
        dst.put(dstPos, src, srcPos, srcLimit - srcPos);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static ByteBuffer byteBufferSlice(ByteBuffer buf, int pos, int limit) {
        return buf.slice(pos, limit - pos);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void byteBufferGet(ByteBuffer src, int srcPos, byte[] dst, int dstPos, int length) {
        src.get(srcPos, dst, dstPos, length);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static void byteBufferPutArray(ByteBuffer dst, int dstPos, byte[] src, int srcPos, int srcLength) {
        dst.put(dstPos, src, srcPos, srcLength);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static ByteBuffer byteBufferWrap(byte[] array) {
        return ByteBuffer.wrap(array);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean setContains(Set<?> set, Object element) {
        return set.contains(element);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> void queueAdd(Queue<? super T> queue, T request) {
        queue.add(request);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> void arraySort(T[] array, Comparator<? super T> comparator) {
        try {
            Arrays.sort(array, comparator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void arraySort(int[] array) {
        Arrays.sort(array);
    }

    @CompilerDirectives.TruffleBoundary
    public static void arraySort(long[] array) {
        Arrays.sort(array);
    }

    @CompilerDirectives.TruffleBoundary
    public static void arraySort(double[] array) {
        Arrays.sort(array);
    }
}

