/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.model.resources;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.graalvm.buildtools.model.resources.ClassPathEntryAnalyzer;
import org.graalvm.buildtools.utils.FileUtils;

class ClassPathDirectoryAnalyzer
extends ClassPathEntryAnalyzer {
    private final Path root;

    ClassPathDirectoryAnalyzer(Path root, Function<String, Boolean> resourceFilter) {
        super(resourceFilter);
        this.root = root;
    }

    @Override
    protected List<String> initialize() throws IOException {
        DirectoryVisitor visitor = new DirectoryVisitor();
        Files.walkFileTree(this.root, visitor);
        return visitor.hasNativeImageResourceFile ? Collections.emptyList() : visitor.resources;
    }

    private class DirectoryVisitor
    extends SimpleFileVisitor<Path> {
        List<String> resources = new ArrayList<String>();
        boolean hasNativeImageResourceFile;
        boolean inNativeImageDir;

        private DirectoryVisitor() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            String relativePath = this.relativePathOf(dir);
            if ("META-INF/native-image".equals(relativePath)) {
                this.inNativeImageDir = true;
            }
            return FileVisitResult.CONTINUE;
        }

        private String relativePathOf(Path path) {
            return FileUtils.normalizePathSeparators(ClassPathDirectoryAnalyzer.this.root.relativize(path).toString());
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            String relativePath = this.relativePathOf(dir);
            if ("META-INF/native-image".equals(relativePath)) {
                this.inNativeImageDir = false;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (this.inNativeImageDir && this.relativePathOf(file).endsWith("resource-config.json")) {
                this.hasNativeImageResourceFile = true;
                return FileVisitResult.TERMINATE;
            }
            ClassPathDirectoryAnalyzer.this.maybeAddResource(ClassPathDirectoryAnalyzer.this.root.relativize(file).toString(), this.resources);
            return FileVisitResult.CONTINUE;
        }
    }
}

