/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.agent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graalvm.buildtools.agent.AgentMode;
import org.graalvm.buildtools.agent.DisabledAgentMode;

public class AgentConfiguration
implements Serializable {
    private final Collection<String> callerFilterFiles;
    private final Collection<String> accessFilterFiles;
    private final boolean builtinCallerFilter;
    private final boolean builtinHeuristicFilter;
    private final boolean experimentalPredefinedClasses;
    private final boolean experimentalUnsafeAllocationTracing;
    private final boolean trackReflectionMetadata;
    private final AgentMode agentMode;

    public AgentConfiguration(Collection<String> callerFilterFiles, Collection<String> accessFilterFiles, boolean builtinCallerFilter, boolean builtinHeuristicFilter, boolean experimentalPredefinedClasses, boolean experimentalUnsafeAllocationTracing, boolean trackReflectionMetadata, AgentMode agentMode) {
        this.callerFilterFiles = callerFilterFiles;
        this.accessFilterFiles = accessFilterFiles;
        this.builtinCallerFilter = builtinCallerFilter;
        this.builtinHeuristicFilter = builtinHeuristicFilter;
        this.experimentalPredefinedClasses = experimentalPredefinedClasses;
        this.experimentalUnsafeAllocationTracing = experimentalUnsafeAllocationTracing;
        this.trackReflectionMetadata = trackReflectionMetadata;
        this.agentMode = agentMode;
    }

    public List<String> getAgentCommandLine() {
        ArrayList<String> cmdLine = new ArrayList<String>(this.agentMode.getAgentCommandLine());
        AgentConfiguration.appendOptionToValues("caller-filter-file=", this.callerFilterFiles, cmdLine);
        AgentConfiguration.appendOptionToValues("access-filter-file=", this.accessFilterFiles, cmdLine);
        cmdLine.add("builtin-caller-filter=" + this.builtinCallerFilter);
        cmdLine.add("builtin-heuristic-filter=" + this.builtinHeuristicFilter);
        cmdLine.add("experimental-class-define-support=" + this.experimentalPredefinedClasses);
        cmdLine.add("experimental-unsafe-allocation-support=" + this.experimentalUnsafeAllocationTracing);
        cmdLine.add("track-reflection-metadata=" + this.trackReflectionMetadata);
        return cmdLine;
    }

    public Collection<String> getAgentFiles() {
        ArrayList<String> files = new ArrayList<String>(this.callerFilterFiles.size() + this.accessFilterFiles.size());
        files.addAll(this.callerFilterFiles);
        files.addAll(this.accessFilterFiles);
        files.addAll(this.agentMode.getInputFiles());
        return files;
    }

    public boolean isEnabled() {
        return !(this.agentMode instanceof DisabledAgentMode);
    }

    public static void appendOptionToValues(String option, Collection<String> values, Collection<String> target) {
        values.stream().map(value -> option + value).forEach(target::add);
    }

    public AgentMode getAgentMode() {
        return this.agentMode;
    }
}

