/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.toolchain.ToolchainManager;
import org.graalvm.buildtools.maven.AbstractNativeMojo;
import org.graalvm.buildtools.maven.config.ExcludeConfigConfiguration;
import org.graalvm.buildtools.utils.NativeImageConfigurationUtils;
import org.graalvm.buildtools.utils.NativeImageUtils;
import org.graalvm.buildtools.utils.SharedConstants;

public abstract class AbstractNativeImageMojo
extends AbstractNativeMojo {
    protected static final String NATIVE_IMAGE_META_INF = "META-INF/native-image";
    protected static final String NATIVE_IMAGE_PROPERTIES_FILENAME = "native-image.properties";
    protected static final String NATIVE_IMAGE_DRY_RUN = "nativeDryRun";
    @Parameter(defaultValue="${plugin}", readonly=true)
    protected PluginDescriptor plugin;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${mojoExecution}")
    protected MojoExecution mojoExecution;
    @Parameter(property="plugin.artifacts", required=true, readonly=true)
    protected List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    protected File outputDirectory;
    @Parameter(property="mainClass")
    protected String mainClass;
    @Parameter(property="imageName", defaultValue="${project.artifactId}")
    protected String imageName;
    @Parameter(property="classpath")
    protected List<String> classpath;
    @Parameter(property="classesDirectory")
    protected File classesDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    protected File defaultClassesDirectory;
    protected final List<Path> imageClasspath = new ArrayList<Path>();
    @Parameter(property="debug", defaultValue="false")
    protected boolean debug;
    @Parameter(property="fallback", defaultValue="false")
    protected boolean fallback;
    @Parameter(property="verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="sharedLibrary", defaultValue="false")
    protected boolean sharedLibrary;
    @Parameter(property="quickBuild", defaultValue="false")
    protected boolean quickBuild;
    @Parameter(property="useArgFile")
    protected Boolean useArgFile = SharedConstants.IS_WINDOWS;
    @Parameter(property="buildArgs")
    protected List<String> buildArgs;
    @Parameter(defaultValue="${project.build.directory}/native/generated", property="resourcesConfigDirectory", required=true)
    protected File resourcesConfigDirectory;
    @Parameter(property="agentResourceDirectory")
    protected File agentResourceDirectory;
    @Parameter(property="excludeConfig")
    protected List<ExcludeConfigConfiguration> excludeConfig;
    @Parameter(property="environmentVariables")
    protected Map<String, String> environment;
    @Parameter(property="systemPropertyVariables")
    protected Map<String, String> systemProperties;
    @Parameter(property="configurationFileDirectories")
    protected List<String> configFiles;
    @Parameter(property="jvmArgs")
    protected List<String> jvmArgs;
    @Parameter(property="nativeDryRun", defaultValue="false")
    protected boolean dryRun;
    @Parameter(property="requiredVersion")
    protected String requiredVersion;
    @Component
    protected ToolchainManager toolchainManager;

    @Inject
    protected AbstractNativeImageMojo() {
    }

    protected List<String> getBuildArgs() throws MojoExecutionException {
        ArrayList<Object> actualCliArgs;
        String quickBuildEnv;
        ArrayList<Object> cliArgs = new ArrayList<Object>();
        if (this.excludeConfig != null) {
            this.excludeConfig.forEach(entry -> {
                cliArgs.add("--exclude-config");
                cliArgs.add(entry.getJarPath());
                cliArgs.add(String.format("\"%s\"", entry.getResourcePattern()));
            });
        }
        cliArgs.add("-cp");
        cliArgs.add(this.getClasspath());
        if (this.debug) {
            cliArgs.add("-g");
        }
        if (!this.fallback) {
            cliArgs.add("--no-fallback");
        }
        if (this.verbose) {
            cliArgs.add("--verbose");
        }
        if (this.sharedLibrary) {
            cliArgs.add("--shared");
        }
        if ((quickBuildEnv = System.getenv("GRAALVM_QUICK_BUILD")) != null) {
            this.logger.warn("Quick build environment variable is set.");
            boolean bl = this.quickBuild = quickBuildEnv.isEmpty() || Boolean.parseBoolean(quickBuildEnv);
        }
        if (this.quickBuild) {
            cliArgs.add("-Ob");
        }
        cliArgs.add("-o");
        cliArgs.add(this.outputDirectory.toPath().toAbsolutePath() + File.separator + this.imageName);
        if (this.systemProperties != null) {
            for (Map.Entry<String, String> entry2 : this.systemProperties.entrySet()) {
                cliArgs.add("-D" + entry2.getKey() + "=" + entry2.getValue());
            }
        }
        if (this.jvmArgs != null) {
            this.jvmArgs.forEach(jvmArg -> cliArgs.add("-J" + jvmArg));
        }
        this.maybeAddGeneratedResourcesConfig(this.buildArgs);
        this.maybeAddReachabilityMetadata(this.configFiles);
        if (this.configFiles != null && !this.configFiles.isEmpty()) {
            cliArgs.add("-H:ConfigurationFileDirectories=" + this.configFiles.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.joining(",")));
        }
        if (this.buildArgs != null && !this.buildArgs.isEmpty()) {
            for (String buildArg : this.buildArgs) {
                cliArgs.addAll(Arrays.asList(buildArg.split("\\s+")));
            }
        }
        if (this.useArgFile.booleanValue()) {
            Path tmpDir = Paths.get("target", "tmp");
            actualCliArgs = new ArrayList(NativeImageUtils.convertToArgsFile(cliArgs, (Path)tmpDir));
        } else {
            actualCliArgs = cliArgs;
        }
        if (this.mainClass != null && !this.mainClass.equals(".")) {
            actualCliArgs.add(this.mainClass);
        }
        return Collections.unmodifiableList(actualCliArgs);
    }

    protected Path processSupportedArtifacts(Artifact artifact) throws MojoExecutionException {
        return this.processArtifact(artifact, "jar", "test-jar", "war");
    }

    protected Path processArtifact(Artifact artifact, String ... artifactTypes) throws MojoExecutionException {
        File artifactFile = artifact.getFile();
        if (artifactFile == null) {
            this.logger.debug("Missing artifact file for artifact " + artifact + " (type: " + artifact.getType() + ")");
            return null;
        }
        if (Arrays.stream(artifactTypes).noneMatch(a -> a.equals(artifact.getType()))) {
            this.logger.warn("Ignoring ImageClasspath Entry '" + artifact + "' with unsupported type '" + artifact.getType() + "'");
            return null;
        }
        if (!artifactFile.exists()) {
            throw new MojoExecutionException("Missing jar-file for " + artifact + ". Ensure that " + this.plugin.getArtifactId() + " runs in package phase.");
        }
        Path jarFilePath = artifactFile.toPath();
        this.logger.debug("ImageClasspath Entry: " + artifact + " (" + jarFilePath.toUri() + ")");
        this.warnIfWrongMetaInfLayout(jarFilePath, artifact);
        return jarFilePath;
    }

    protected void addArtifactToClasspath(Artifact artifact) throws MojoExecutionException {
        Optional.ofNullable(this.processSupportedArtifacts(artifact)).ifPresent(this.imageClasspath::add);
    }

    private static FileSystem openFileSystem(URI uri) throws IOException {
        FileSystem fs;
        try {
            fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException e) {
            fs = FileSystems.getFileSystem(uri);
        }
        return fs;
    }

    protected void warnIfWrongMetaInfLayout(Path jarFilePath, Artifact artifact) throws MojoExecutionException {
        block16: {
            if (jarFilePath.toFile().isDirectory()) {
                this.logger.debug("Artifact `" + jarFilePath + "` is a directory.");
                return;
            }
            URI jarFileURI = URI.create("jar:" + jarFilePath.toUri());
            try (FileSystem jarFS = AbstractNativeImageMojo.openFileSystem(jarFileURI);){
                Path nativeImageMetaInfBase = jarFS.getPath("/META-INF/native-image", new String[0]);
                if (!Files.isDirectory(nativeImageMetaInfBase, new LinkOption[0])) break block16;
                try (Stream<Path> stream = Files.walk(nativeImageMetaInfBase, new FileVisitOption[0]);){
                    List nativeImageProperties = stream.filter(p -> p.endsWith(NATIVE_IMAGE_PROPERTIES_FILENAME)).collect(Collectors.toList());
                    for (Path nativeImageProperty : nativeImageProperties) {
                        Path relativeSubDir = nativeImageMetaInfBase.relativize(nativeImageProperty).getParent();
                        boolean valid = relativeSubDir != null && relativeSubDir.getNameCount() == 2;
                        valid = valid && relativeSubDir.getName(0).toString().equals(artifact.getGroupId());
                        if (valid = valid && relativeSubDir.getName(1).toString().equals(artifact.getArtifactId())) continue;
                        String example = "META-INF/native-image/%s/%s/native-image.properties";
                        example = String.format(example, artifact.getGroupId(), artifact.getArtifactId());
                        this.logger.warn("Properties file at '" + nativeImageProperty.toUri() + "' does not match the recommended '" + example + "' layout.");
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Artifact " + artifact + "cannot be added to image classpath", (Exception)e);
            }
        }
    }

    protected abstract List<String> getDependencyScopes();

    protected void addDependenciesToClasspath() throws MojoExecutionException {
        this.configureMetadataRepository();
        HashSet<Artifact> collected = new HashSet<Artifact>();
        for (Artifact dependency : this.project.getArtifacts()) {
            if (!this.getDependencyScopes().contains(dependency.getScope()) || !collected.add(dependency)) continue;
            this.addArtifactToClasspath(dependency);
            this.maybeAddDependencyMetadata(dependency, file -> {
                this.buildArgs.add("--exclude-config");
                this.buildArgs.add(Pattern.quote(dependency.getFile().getAbsolutePath()));
                this.buildArgs.add("^/META-INF/native-image/");
            });
        }
    }

    protected Path getMainBuildPath() throws MojoExecutionException {
        if (this.classesDirectory != null) {
            return this.classesDirectory.toPath();
        }
        Path artifactPath = this.processArtifact(this.project.getArtifact(), this.project.getPackaging());
        if (artifactPath != null) {
            return artifactPath;
        }
        return this.defaultClassesDirectory.toPath();
    }

    protected void populateApplicationClasspath() throws MojoExecutionException {
        this.imageClasspath.add(this.getMainBuildPath());
    }

    protected void populateClasspath() throws MojoExecutionException {
        if (this.classpath != null && !this.classpath.isEmpty()) {
            this.imageClasspath.addAll(this.classpath.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).collect(Collectors.toSet()));
        } else {
            this.populateApplicationClasspath();
            this.addDependenciesToClasspath();
        }
        this.imageClasspath.removeIf(entry -> !entry.toFile().exists());
    }

    protected String getClasspath() throws MojoExecutionException {
        this.populateClasspath();
        if (this.imageClasspath.isEmpty()) {
            throw new MojoExecutionException("Image classpath is empty. Check if your classpath configuration is correct.");
        }
        return this.imageClasspath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator));
    }

    protected void buildImage() throws MojoExecutionException {
        this.checkRequiredVersionIfNeeded();
        Path nativeImageExecutable = NativeImageConfigurationUtils.getNativeImage(this.logger);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(nativeImageExecutable.toString());
            processBuilder.command().addAll(this.getBuildArgs());
            if (this.environment != null) {
                processBuilder.environment().putAll(this.environment);
            }
            if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                throw new MojoExecutionException("Failed creating output directory");
            }
            processBuilder.inheritIO();
            String commandString = String.join((CharSequence)" ", processBuilder.command());
            this.logger.info("Executing: " + commandString);
            if (this.dryRun) {
                this.logger.warn("Skipped native-image building due to `nativeDryRun` being specified.");
                return;
            }
            Process imageBuildProcess = processBuilder.start();
            if (imageBuildProcess.waitFor() != 0) {
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Building image with " + nativeImageExecutable + " failed", e);
        }
    }

    protected void checkRequiredVersionIfNeeded() throws MojoExecutionException {
        if (this.requiredVersion == null) {
            return;
        }
        Path nativeImageExecutable = NativeImageConfigurationUtils.getNativeImage(this.logger);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(nativeImageExecutable.toString());
            processBuilder.command().add("--version");
            Process versionCheckProcess = processBuilder.start();
            if (versionCheckProcess.waitFor() != 0) {
                String commandString = String.join((CharSequence)" ", processBuilder.command());
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
            InputStream inputStream = versionCheckProcess.getInputStream();
            String versionToCheck = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            NativeImageUtils.checkVersion((String)this.requiredVersion, (String)versionToCheck);
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Checking GraalVM version with " + nativeImageExecutable + " failed", e);
        }
    }

    protected void maybeAddGeneratedResourcesConfig(List<String> into) {
        File[] dirs;
        Stream<File> configDirs;
        String value;
        if ((this.resourcesConfigDirectory.exists() || this.agentResourceDirectory != null) && !(value = (configDirs = Stream.concat((dirs = this.resourcesConfigDirectory.listFiles()) == null ? Stream.empty() : Arrays.stream(dirs), this.agentResourceDirectory == null ? Stream.empty() : Stream.of(this.agentResourceDirectory).filter(File::isDirectory))).map(File::getAbsolutePath).collect(Collectors.joining(","))).isEmpty()) {
            into.add("-H:ConfigurationFileDirectories=" + value);
        }
    }

    protected void maybeAddReachabilityMetadata(List<String> configDirs) {
        if (this.isMetadataRepositoryEnabled() && !this.metadataRepositoryConfigurations.isEmpty()) {
            this.metadataRepositoryConfigurations.stream().map(configuration -> configuration.getDirectory().toAbsolutePath()).map(Path::toFile).map(File::getAbsolutePath).forEach(configDirs::add);
        }
    }
}

