/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.dsl.NativeResourcesOptions;
import org.graalvm.buildtools.utils.SharedConstants;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;

public abstract class BaseNativeImageOptions
implements NativeImageOptions {
    private final String name;

    @Override
    @Internal
    public String getName() {
        return this.name;
    }

    @Override
    @Input
    public abstract Property<String> getImageName();

    @Override
    @Input
    @Optional
    public abstract Property<String> getMainClass();

    @Override
    @Input
    public abstract ListProperty<String> getBuildArgs();

    @Override
    @Input
    public abstract MapProperty<String, Object> getSystemProperties();

    @Override
    @InputFiles
    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Override
    @Input
    public abstract ListProperty<String> getJvmArgs();

    @Override
    @Input
    public abstract ListProperty<String> getRuntimeArgs();

    @Override
    @Input
    public abstract Property<Boolean> getDebug();

    @Override
    @Input
    public abstract Property<Boolean> getFallback();

    @Override
    @Input
    public abstract Property<Boolean> getVerbose();

    @Override
    @Input
    public abstract Property<Boolean> getSharedLibrary();

    @Override
    @Nested
    @Optional
    public abstract Property<JavaLauncher> getJavaLauncher();

    @Override
    @InputFiles
    public abstract ConfigurableFileCollection getConfigurationFileDirectories();

    @Override
    @Nested
    public abstract NativeResourcesOptions getResources();

    @Override
    public void resources(Action<? super NativeResourcesOptions> spec) {
        spec.execute((Object)this.getResources());
    }

    @Inject
    public BaseNativeImageOptions(String name, ObjectFactory objectFactory, ProviderFactory providers, JavaToolchainService toolchains, TaskContainer tasks, String defaultImageName) {
        this.name = name;
        this.getDebug().convention((Object)false);
        this.getFallback().convention((Object)false);
        this.getVerbose().convention((Object)false);
        this.getAgent().getEnabled().convention((Object)false);
        this.getSharedLibrary().convention((Object)false);
        this.getImageName().convention((Object)defaultImageName);
        this.getUseFatJar().convention((Object)SharedConstants.IS_WINDOWS);
    }

    private static Provider<Boolean> property(ProviderFactory providers, String name) {
        return providers.gradleProperty(name).forUseAtConfigurationTime().map(Boolean::valueOf).orElse((Object)false);
    }

    @Override
    public BaseNativeImageOptions buildArgs(Object ... buildArgs) {
        this.getBuildArgs().addAll((Iterable)Arrays.stream(buildArgs).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    @Override
    public BaseNativeImageOptions buildArgs(Iterable<?> buildArgs) {
        this.getBuildArgs().addAll((Iterable)StreamSupport.stream(buildArgs.spliterator(), false).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    @Override
    public BaseNativeImageOptions systemProperties(Map<String, ?> properties) {
        MapProperty<String, Object> map = this.getSystemProperties();
        properties.forEach((key, value) -> map.put(key, (Object)(value == null ? null : String.valueOf(value))));
        return this;
    }

    @Override
    public BaseNativeImageOptions systemProperty(String name, Object value) {
        this.getSystemProperties().put((Object)name, (Object)(value == null ? null : String.valueOf(value)));
        return this;
    }

    @Override
    public BaseNativeImageOptions classpath(Object ... paths) {
        this.getClasspath().from(paths);
        return this;
    }

    @Override
    public BaseNativeImageOptions jvmArgs(Object ... arguments) {
        this.getJvmArgs().addAll((Iterable)Arrays.stream(arguments).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    @Override
    public BaseNativeImageOptions jvmArgs(Iterable<?> arguments) {
        this.getJvmArgs().addAll((Iterable)StreamSupport.stream(arguments.spliterator(), false).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    @Override
    public BaseNativeImageOptions runtimeArgs(Object ... arguments) {
        this.getRuntimeArgs().addAll((Iterable)Arrays.stream(arguments).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    @Override
    public BaseNativeImageOptions runtimeArgs(Iterable<?> arguments) {
        this.getRuntimeArgs().addAll((Iterable)StreamSupport.stream(arguments.spliterator(), false).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }
}

