/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform.config.jupiter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Optional;
import org.graalvm.junit.platform.JUnitPlatformFeature;
import org.graalvm.junit.platform.config.core.NativeImageConfiguration;
import org.graalvm.junit.platform.config.core.PluginConfigProvider;
import org.graalvm.junit.platform.config.util.AnnotationUtils;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.IndicativeSentencesGeneration;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.aggregator.AggregateWith;
import org.junit.jupiter.params.converter.ConvertWith;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.platform.commons.support.AnnotationSupport;

public class JupiterConfigProvider
implements PluginConfigProvider {
    @Override
    public void onLoad(NativeImageConfiguration config) {
        config.initializeAtBuildTime("org.junit.jupiter.engine.config.EnumConfigurationParameterConverter", "org.junit.jupiter.engine.descriptor.ClassTestDescriptor", "org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor", "org.junit.jupiter.engine.descriptor.TestFactoryTestDescriptor", "org.junit.jupiter.engine.descriptor.JupiterTestDescriptor", "org.junit.jupiter.engine.descriptor.JupiterTestDescriptor$1", "org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor", "org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor", "org.junit.jupiter.engine.descriptor.TestTemplateTestDescriptor", "org.junit.jupiter.engine.execution.ConditionEvaluator", "org.junit.jupiter.engine.execution.ExecutableInvoker", "org.junit.jupiter.params.provider.EnumSource$Mode", "org.junit.platform.launcher.core.LauncherConfig", "org.junit.jupiter.engine.config.InstantiatingConfigurationParameterConverter");
        if (this.getMajorJDKVersion() >= 21) {
            config.initializeAtBuildTime("org.junit.jupiter.api.DisplayNameGenerator$Standard", "org.junit.jupiter.api.extension.ConditionEvaluationResult", "org.junit.jupiter.api.TestInstance$Lifecycle", "org.junit.jupiter.engine.config.CachingJupiterConfiguration", "org.junit.jupiter.engine.config.DefaultJupiterConfiguration", "org.junit.jupiter.engine.descriptor.DynamicDescendantFilter", "org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor", "org.junit.jupiter.engine.descriptor.NestedClassTestDescriptor", "org.junit.jupiter.engine.execution.InterceptingExecutableInvoker", "org.junit.jupiter.engine.execution.InterceptingExecutableInvoker$ReflectiveInterceptorCall", "org.junit.jupiter.engine.execution.InterceptingExecutableInvoker$ReflectiveInterceptorCall$VoidMethodInterceptorCall", "org.junit.jupiter.engine.execution.InvocationInterceptorChain", "org.junit.jupiter.engine.JupiterTestEngine", "org.junit.jupiter.params.provider.EnumSource$Mode$Validator");
        }
        config.registerAllClassMembersForReflection("org.junit.jupiter.engine.extension.TimeoutExtension$ExecutorResource", "org.junit.jupiter.engine.extension.TimeoutInvocationFactory$SingleThreadExecutorResource");
    }

    @Override
    public void onTestClassRegistered(Class<?> testClass, NativeImageConfiguration registry) {
        AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, ArgumentsSource.class, ArgumentsSource::value);
        AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, ExtendWith.class, ExtendWith::value);
        AnnotationUtils.forEachAnnotatedMethod(testClass, EnumSource.class, (m, annotation) -> JupiterConfigProvider.handleEnumSource(m, annotation, registry));
        JupiterConfigProvider.handleTestOrderer(testClass, registry);
        AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, DisplayNameGeneration.class, DisplayNameGeneration::value);
        AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, IndicativeSentencesGeneration.class, IndicativeSentencesGeneration::generator);
        AnnotationUtils.forEachAnnotatedMethodParameter(testClass, ConvertWith.class, annotation -> registry.registerAllClassMembersForReflection(annotation.value()));
        AnnotationUtils.forEachAnnotatedMethodParameter(testClass, AggregateWith.class, annotation -> registry.registerAllClassMembersForReflection(annotation.value()));
        AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, MethodSource.class, JupiterConfigProvider::handleMethodSource);
        AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, EnabledIf.class, JupiterConfigProvider::handleEnabledIf);
        AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, DisabledIf.class, JupiterConfigProvider::handleDisabledIf);
    }

    private static Class<?>[] handleMethodSource(MethodSource annotation) {
        return JupiterConfigProvider.handleMethodReference(annotation.value());
    }

    private static Class<?>[] handleEnabledIf(EnabledIf annotation) {
        return JupiterConfigProvider.handleMethodReference(annotation.value());
    }

    private static Class<?>[] handleDisabledIf(DisabledIf annotation) {
        return JupiterConfigProvider.handleMethodReference(annotation.value());
    }

    private static Class<?>[] handleMethodReference(String ... methodNames) {
        ArrayList classList = new ArrayList();
        for (String methodName : methodNames) {
            String[] parts = methodName.split("#");
            JUnitPlatformFeature.debug("Found method reference: %s", methodName);
            if (parts.length == 2) {
                String className = parts[0];
                JUnitPlatformFeature.debug("Processing method reference from another class: %s", className);
                try {
                    classList.add(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    JUnitPlatformFeature.debug("Failed to register method reference for reflection: %s Reason: %s", className, e);
                }
                continue;
            }
            JUnitPlatformFeature.debug("Skipping method reference as it originates in the same class as the test: %s", methodName);
        }
        return classList.toArray(new Class[0]);
    }

    public static void handleEnumSource(Method method, EnumSource source, NativeImageConfiguration registry) {
        registry.registerAllClassMembersForReflection(source.value());
        if (method.getParameterCount() > 0) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> enumParameterType = parameterTypes[0];
            if (enumParameterType.isEnum()) {
                JUnitPlatformFeature.debug("Registering method enum parameter for reflection. Method: %s Parameter: %s", method, parameterTypes[0]);
                registry.registerAllClassMembersForReflection(enumParameterType);
            } else {
                JUnitPlatformFeature.debug("First parameter of method not an enum - skipping. Method: %s", method);
            }
        } else {
            JUnitPlatformFeature.debug("Method doesn't have at least 1 parameter - skipping enum registration. Method: %s", method);
        }
    }

    private static void handleTestOrderer(Class<?> testClass, NativeImageConfiguration registry) {
        Optional annotation = AnnotationSupport.findAnnotation(testClass, TestMethodOrder.class);
        if (annotation.isPresent()) {
            TestMethodOrder testMethodOrder = (TestMethodOrder)annotation.get();
            Class clazz = testMethodOrder.value();
            registry.initializeAtBuildTime(clazz);
        }
    }
}

