/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform.config.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.graalvm.junit.platform.config.core.NativeImageConfiguration;
import org.junit.platform.commons.support.AnnotationSupport;

public class AnnotationUtils {
    public static <A extends Annotation> void forEachAnnotationOnClassMembers(Class<?> clazz, Class<A> annotationType, Consumer<A> consumer) {
        for (Annotation annotation : AnnotationUtils.getAnnotations(clazz, annotationType)) {
            consumer.accept(annotation);
        }
        AnnotationUtils.forEachMethod(clazz, method -> {
            for (Annotation annotation : AnnotationUtils.getAnnotations(method, annotationType)) {
                consumer.accept(annotation);
            }
        });
    }

    public static <A extends Annotation> void forEachAnnotatedMethod(Class<?> clazz, Class<A> annotationType, BiConsumer<Method, A> consumer) {
        AnnotationUtils.forEachMethod(clazz, method -> {
            for (Annotation annotation : AnnotationUtils.getAnnotations(method, annotationType)) {
                consumer.accept((Method)method, (Object)annotation);
            }
        });
    }

    public static <A extends Annotation> void forEachAnnotatedMethodParameter(Class<?> clazz, Class<A> annotationType, Consumer<A> consumer) {
        AnnotationUtils.forEachMethod(clazz, method -> {
            for (Parameter parameter : method.getParameters()) {
                for (Annotation annotation : AnnotationUtils.getAnnotations(parameter, annotationType)) {
                    consumer.accept(annotation);
                }
            }
        });
    }

    private static void forEachMethod(Class<?> clazz, Consumer<Method> consumer) {
        for (Method method : clazz.getDeclaredMethods()) {
            consumer.accept(method);
        }
    }

    private static <A extends Annotation> List<A> getAnnotations(AnnotatedElement element, Class<A> annotation) {
        if (annotation.getAnnotation(Repeatable.class) != null) {
            return AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)element, annotation);
        }
        Optional optionalAnnotation = AnnotationSupport.findAnnotation((AnnotatedElement)element, annotation);
        ArrayList annotationList = new ArrayList();
        optionalAnnotation.ifPresent(annotationList::add);
        return annotationList;
    }

    public static <T extends Annotation> void registerClassesFromAnnotationForReflection(Class<?> testClass, NativeImageConfiguration config, Class<T> annotation, ClassArrayProvider<T> classProvider) {
        AnnotationUtils.forEachAnnotationOnClassMembers(testClass, annotation, a -> {
            Class[] reflectivelyAccessedClasses = (Class[])classProvider.apply(a);
            config.registerAllClassMembersForReflection(reflectivelyAccessedClasses);
        });
    }

    public static <T extends Annotation> void registerClassesFromAnnotationForReflection(Class<?> testClass, NativeImageConfiguration config, Class<T> annotation, ClassProvider<T> classProvider) {
        AnnotationUtils.forEachAnnotationOnClassMembers(testClass, annotation, a -> {
            Class reflectivelyAccessedClass = (Class)classProvider.apply(a);
            config.registerAllClassMembersForReflection(reflectivelyAccessedClass);
        });
    }

    public static interface ClassArrayProvider<T extends Annotation>
    extends Function<T, Class<?>[]> {
    }

    public static interface ClassProvider<T extends Annotation>
    extends Function<T, Class<?>> {
    }
}

