/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform;

import java.io.PrintWriter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.reporting.legacy.LegacyReportingUtils;

public class PrintTestExecutionListener
implements TestExecutionListener {
    TestPlan testPlan;
    final PrintWriter out;

    public PrintTestExecutionListener() {
        this.out = new PrintWriter(System.out);
    }

    public PrintTestExecutionListener(PrintWriter out) {
        this.out = out;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.printTest(testIdentifier, "SKIPPED: " + reason);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.printTest(testIdentifier, testExecutionResult.getStatus().name());
    }

    private void printTest(TestIdentifier testIdentifier, String status) {
        if (testIdentifier.getParentId().isPresent() && !testIdentifier.isContainer()) {
            this.out.println(LegacyReportingUtils.getClassName((TestPlan)this.testPlan, (TestIdentifier)testIdentifier) + " > " + testIdentifier.getDisplayName() + " " + status + "\n");
        }
    }
}

