/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.ExtendedExtension;
import org.glassfish.tyrus.core.Frame;
import org.glassfish.tyrus.core.FramingException;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.TyrusEndpoint;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.Version;
import org.glassfish.tyrus.core.frame.CloseFrame;
import org.glassfish.tyrus.core.uri.Match;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

public class TyrusWebSocketEngine
implements WebSocketEngine {
    public static final String INCOMING_BUFFER_SIZE = "org.glassfish.tyrus.incomingBufferSize";
    private static final int BUFFER_STEP_SIZE = 256;
    private static final Logger LOGGER = Logger.getLogger("websocket");
    private static final WebSocketEngine.UpgradeInfo NOT_APPLICABLE_UPGRADE_INFO = new NoConnectionUpgradeInfo(WebSocketEngine.UpgradeStatus.NOT_APPLICABLE);
    private static final WebSocketEngine.UpgradeInfo HANDSHAKE_FAILED_UPGRADE_INFO = new NoConnectionUpgradeInfo(WebSocketEngine.UpgradeStatus.HANDSHAKE_FAILED);
    private final Set<TyrusEndpoint> endpoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ComponentProviderService componentProviderService = ComponentProviderService.create();
    private final WebSocketContainer webSocketContainer;
    private int incomingBufferSize = 0x40000B;

    public TyrusWebSocketEngine(WebSocketContainer webSocketContainer) {
        this(webSocketContainer, null);
    }

    public TyrusWebSocketEngine(WebSocketContainer webSocketContainer, Integer incomingBufferSize) {
        if (incomingBufferSize != null) {
            this.incomingBufferSize = incomingBufferSize;
        }
        this.webSocketContainer = webSocketContainer;
    }

    private static ProtocolHandler loadHandler(UpgradeRequest request) {
        for (Version version : Version.values()) {
            if (!version.validate(request)) continue;
            return version.createHandler(false);
        }
        return null;
    }

    private static void handleUnsupportedVersion(UpgradeRequest request, UpgradeResponse response) {
        response.setStatus(426);
        response.getHeaders().put("Sec-WebSocket-Version", Arrays.asList(Version.getSupportedWireProtocolVersions()));
    }

    TyrusEndpoint getEndpoint(UpgradeRequest request) {
        if (this.endpoints.isEmpty()) {
            return null;
        }
        String requestPath = request.getRequestUri();
        for (Match m : Match.getAllMatches(requestPath, this.endpoints)) {
            TyrusEndpoint endpoint = m.getTyrusEndpoit();
            for (String name : m.getParameterNames()) {
                request.getParameterMap().put(name, Arrays.asList(m.getParameterValue(name)));
            }
            if (!endpoint.upgrade(request)) continue;
            return endpoint;
        }
        return null;
    }

    @Override
    public WebSocketEngine.UpgradeInfo upgrade(UpgradeRequest request, UpgradeResponse response) {
        try {
            TyrusEndpoint endpoint = this.getEndpoint(request);
            if (endpoint != null) {
                ProtocolHandler protocolHandler = TyrusWebSocketEngine.loadHandler(request);
                if (protocolHandler == null) {
                    TyrusWebSocketEngine.handleUnsupportedVersion(request, response);
                    return HANDSHAKE_FAILED_UPGRADE_INFO;
                }
                ExtendedExtension.ExtensionContext extensionContext = new ExtendedExtension.ExtensionContext(){
                    private final Map<String, Object> properties = new HashMap<String, Object>();

                    @Override
                    public Map<String, Object> getProperties() {
                        return this.properties;
                    }
                };
                protocolHandler.handshake(endpoint, request, response, extensionContext);
                return new SuccessfulUpgradeInfo(endpoint, protocolHandler, this.incomingBufferSize, request, extensionContext);
            }
        }
        catch (HandshakeException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            response.setStatus(e.getCode());
            return HANDSHAKE_FAILED_UPGRADE_INFO;
        }
        response.setStatus(500);
        return NOT_APPLICABLE_UPGRADE_INFO;
    }

    public void setIncomingBufferSize(int incomingBufferSize) {
        this.incomingBufferSize = incomingBufferSize;
    }

    private void register(TyrusEndpoint endpoint) throws DeploymentException {
        this.checkPath(endpoint);
        this.endpoints.add(endpoint);
    }

    @Override
    public void register(Class<?> endpointClass, String contextPath) throws DeploymentException {
        EndpointConfig config;
        AnnotatedEndpoint endpoint;
        ErrorCollector collector = new ErrorCollector();
        TyrusEndpointWrapper ew = new TyrusEndpointWrapper(endpoint, config, this.componentProviderService, this.webSocketContainer, contextPath, (config = (endpoint = AnnotatedEndpoint.fromClass(endpointClass, this.componentProviderService, true, collector)).getEndpointConfig()) instanceof ServerEndpointConfig ? ((ServerEndpointConfig)config).getConfigurator() : null);
        if (!collector.isEmpty()) {
            throw collector.composeComprehensiveException();
        }
        this.register(new TyrusEndpoint(ew));
    }

    @Override
    public void register(ServerEndpointConfig serverConfig, String contextPath) throws DeploymentException {
        TyrusEndpointWrapper ew;
        Class<?> endpointClass = serverConfig.getEndpointClass();
        boolean isEndpointClass = false;
        do {
            if (!(endpointClass = endpointClass.getSuperclass()).equals(Endpoint.class)) continue;
            isEndpointClass = true;
        } while (!endpointClass.equals(Object.class));
        if (isEndpointClass) {
            ew = new TyrusEndpointWrapper(serverConfig.getEndpointClass(), (EndpointConfig)serverConfig, this.componentProviderService, this.webSocketContainer, contextPath, serverConfig.getConfigurator());
        } else {
            EndpointConfig config;
            AnnotatedEndpoint endpoint;
            ErrorCollector collector = new ErrorCollector();
            ew = new TyrusEndpointWrapper(endpoint, config, this.componentProviderService, this.webSocketContainer, contextPath, (config = (endpoint = AnnotatedEndpoint.fromClass(serverConfig.getEndpointClass(), this.componentProviderService, true, collector)).getEndpointConfig()) instanceof ServerEndpointConfig ? ((ServerEndpointConfig)config).getConfigurator() : null);
            if (!collector.isEmpty()) {
                throw collector.composeComprehensiveException();
            }
        }
        this.register(new TyrusEndpoint(ew));
    }

    private void checkPath(TyrusEndpoint endpoint) throws DeploymentException {
        for (TyrusEndpoint tyrusEndpoint : this.endpoints) {
            if (!Match.isEquivalent(endpoint.getPath(), tyrusEndpoint.getPath())) continue;
            throw new DeploymentException(String.format("Found equivalent paths. Added path: '%s' is equivalent with '%s'.", endpoint.getPath(), tyrusEndpoint.getPath()));
        }
    }

    public void unregister(TyrusEndpoint endpoint) {
        this.endpoints.remove(endpoint);
    }

    static class TyrusConnection
    implements Connection {
        private final ReadHandler readHandler;
        private final Writer writer;
        private final Connection.CloseListener closeListener;
        private final TyrusWebSocket socket;
        private final ExtendedExtension.ExtensionContext extensionContext;
        private final TyrusEndpoint endpoint;

        TyrusConnection(TyrusEndpoint endpoint, ProtocolHandler protocolHandler, int incomingBufferSize, Writer writer, Connection.CloseListener closeListener, UpgradeRequest upgradeRequest, ExtendedExtension.ExtensionContext extensionContext) {
            protocolHandler.setWriter(writer);
            TyrusWebSocket socket = endpoint.createSocket(protocolHandler);
            socket.onConnect(upgradeRequest);
            this.socket = socket;
            this.readHandler = new TyrusReadHandler(protocolHandler, socket, endpoint, incomingBufferSize, extensionContext);
            this.writer = writer;
            this.closeListener = closeListener;
            this.extensionContext = extensionContext;
            this.endpoint = endpoint;
        }

        @Override
        public ReadHandler getReadHandler() {
            return this.readHandler;
        }

        @Override
        public Writer getWriter() {
            return this.writer;
        }

        @Override
        public Connection.CloseListener getCloseListener() {
            return this.closeListener;
        }

        @Override
        public void close(CloseReason reason) {
            if (this.socket.isConnected()) {
                this.socket.close(reason.getCloseCode().getCode(), reason.getReasonPhrase());
                for (Extension extension : this.endpoint.getSupportedExtensions()) {
                    if (!(extension instanceof ExtendedExtension)) continue;
                    try {
                        ((ExtendedExtension)extension).destroy(this.extensionContext);
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    private static class SuccessfulUpgradeInfo
    implements WebSocketEngine.UpgradeInfo {
        private final TyrusEndpoint endpoint;
        private final ProtocolHandler protocolHandler;
        private final int incomingBufferSize;
        private final UpgradeRequest upgradeRequest;
        private final ExtendedExtension.ExtensionContext extensionContext;

        SuccessfulUpgradeInfo(TyrusEndpoint endpoint, ProtocolHandler protocolHandler, int incomingBufferSize, UpgradeRequest upgradeRequest, ExtendedExtension.ExtensionContext extensionContext) {
            this.endpoint = endpoint;
            this.protocolHandler = protocolHandler;
            this.incomingBufferSize = incomingBufferSize;
            this.upgradeRequest = upgradeRequest;
            this.extensionContext = extensionContext;
        }

        @Override
        public WebSocketEngine.UpgradeStatus getStatus() {
            return WebSocketEngine.UpgradeStatus.SUCCESS;
        }

        @Override
        public Connection createConnection(Writer writer, Connection.CloseListener closeListener) {
            return new TyrusConnection(this.endpoint, this.protocolHandler, this.incomingBufferSize, writer, closeListener, this.upgradeRequest, this.extensionContext);
        }
    }

    private static class NoConnectionUpgradeInfo
    implements WebSocketEngine.UpgradeInfo {
        private final WebSocketEngine.UpgradeStatus status;

        NoConnectionUpgradeInfo(WebSocketEngine.UpgradeStatus status) {
            this.status = status;
        }

        @Override
        public WebSocketEngine.UpgradeStatus getStatus() {
            return this.status;
        }

        @Override
        public Connection createConnection(Writer writer, Connection.CloseListener closeListener) {
            return null;
        }
    }

    private static class TyrusReadHandler
    implements ReadHandler {
        private final ProtocolHandler protocolHandler;
        private final TyrusWebSocket socket;
        private final TyrusEndpoint endpoint;
        private final int incomingBufferSize;
        private final List<Extension> negotiatedExtensions;
        private final ExtendedExtension.ExtensionContext extensionContext;
        private volatile ByteBuffer buffer;

        private TyrusReadHandler(ProtocolHandler protocolHandler, TyrusWebSocket socket, TyrusEndpoint endpoint, int incomingBufferSize, ExtendedExtension.ExtensionContext extensionContext) {
            this.extensionContext = extensionContext;
            this.protocolHandler = protocolHandler;
            this.socket = socket;
            this.endpoint = endpoint;
            this.incomingBufferSize = incomingBufferSize;
            this.negotiatedExtensions = new ArrayList<Extension>();
            this.negotiatedExtensions.addAll(endpoint.getSupportedExtensions());
        }

        @Override
        public void handle(ByteBuffer data) {
            block11: {
                try {
                    if (data == null || !data.hasRemaining()) break block11;
                    if (this.buffer != null) {
                        data = Utils.appendBuffers(this.buffer, data, this.incomingBufferSize, 256);
                    } else {
                        int newSize = data.remaining();
                        if (newSize > this.incomingBufferSize) {
                            throw new IllegalArgumentException("Buffer overflow.");
                        }
                        int roundedSize = newSize % 256 > 0 ? (newSize / 256 + 1) * 256 : newSize;
                        ByteBuffer result = ByteBuffer.allocate(roundedSize > this.incomingBufferSize ? newSize : roundedSize);
                        result.flip();
                        data = Utils.appendBuffers(result, data, this.incomingBufferSize, 256);
                    }
                    while (true) {
                        Frame incomingFrame;
                        if ((incomingFrame = this.protocolHandler.unframe(data)) == null) {
                            this.buffer = data;
                            break;
                        }
                        Frame frame = incomingFrame;
                        for (Extension extension : this.negotiatedExtensions) {
                            if (!(extension instanceof ExtendedExtension)) continue;
                            try {
                                frame = ((ExtendedExtension)extension).processIncoming(this.extensionContext, frame);
                            }
                            catch (Throwable t) {
                                LOGGER.log(Level.FINE, String.format("Extension '%s' threw an exception during processIncoming method invocation: \"%s\".", extension.getName(), t.getMessage()), t);
                            }
                        }
                        this.protocolHandler.process(frame, this.socket);
                    }
                }
                catch (FramingException e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                    this.socket.onClose(new CloseFrame(new CloseReason(CloseReason.CloseCodes.getCloseCode(e.getClosingCode()), e.getMessage())));
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                    if (!this.endpoint.onError(this.socket, e)) break block11;
                    this.socket.onClose(new CloseFrame(new CloseReason(CloseReason.CloseCodes.UNEXPECTED_CONDITION, e.getMessage())));
                }
            }
        }
    }
}

