/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Utils {
    public static List<String> parseHeaderValue(String headerValue) {
        ArrayList<String> values = new ArrayList<String>();
        int state = 0;
        StringBuilder sb = new StringBuilder();
        block6: for (char c : headerValue.toCharArray()) {
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) continue block6;
                    if (c == '\"') {
                        state = 2;
                        sb.append(c);
                        continue block6;
                    }
                    sb.append(c);
                    state = 1;
                    continue block6;
                }
                case 1: {
                    if (c != ',') {
                        sb.append(c);
                        continue block6;
                    }
                    values.add(sb.toString());
                    sb = new StringBuilder();
                    state = 0;
                    continue block6;
                }
                case 2: {
                    if (c != '\"') {
                        sb.append(c);
                        continue block6;
                    }
                    sb.append(c);
                    values.add(sb.toString());
                    sb = new StringBuilder();
                    state = 3;
                    continue block6;
                }
                case 3: {
                    if (Character.isWhitespace(c) || c != ',') continue block6;
                    state = 0;
                    continue block6;
                }
            }
        }
        if (sb.length() > 0) {
            values.add(sb.toString());
        }
        return values;
    }

    public static byte[] getRemainingArray(ByteBuffer buffer) {
        byte[] ret = new byte[buffer.remaining()];
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            System.arraycopy(array, buffer.arrayOffset() + buffer.position(), ret, 0, ret.length);
        } else {
            buffer.get(ret);
        }
        return ret;
    }

    public static <T> String getHeaderFromList(List<T> list) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static <T> void checkNotNull(T reference, String errorMessage) {
        if (reference == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

