/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.util.Arrays;
import org.glassfish.tyrus.core.StrictUtf8;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.Utf8Utils;
import org.glassfish.tyrus.core.WebSocket;
import org.glassfish.tyrus.core.frame.Frame;

public class DataFrame {
    private String payload;
    private byte[] bytes;
    private final Frame type;
    private final boolean last;

    DataFrame(Frame type) {
        this.type = type;
        this.last = true;
    }

    public DataFrame(Frame type, String data) {
        this(type, data, true);
    }

    public DataFrame(Frame type, String data, boolean fin) {
        this.type = type;
        this.setPayload(data);
        this.last = fin;
    }

    public DataFrame(Frame type, byte[] data) {
        this(type, data, true);
    }

    public DataFrame(Frame type, byte[] data, boolean fin) {
        this.type = type;
        type.setPayload(this, data);
        this.last = fin;
    }

    public Frame getType() {
        return this.type;
    }

    public String getTextPayload() {
        return this.payload;
    }

    public final void setPayload(String payload) {
        this.payload = payload;
    }

    public void setPayload(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        if (this.payload != null) {
            this.bytes = Utf8Utils.encode(new StrictUtf8(), this.payload);
        }
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public void respond(WebSocket socket) {
        this.getType().respond(socket, this);
    }

    public String toString() {
        return "DataFrame" + "{" + "last=" + this.last + ", type=" + this.type.getClass().getSimpleName() + ", payload='" + this.getTextPayload() + '\'' + ", bytes=" + TyrusWebSocketEngine.toString(this.bytes) + '}';
    }

    public boolean isLast() {
        return this.last;
    }
}

