/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import org.glassfish.tyrus.core.FutureSendResult;
import org.glassfish.tyrus.core.RemoteEndpointWrapper;

public class SendCompletionAdapter {
    private final State state;
    private final RemoteEndpointWrapper.Async rew;

    public SendCompletionAdapter(RemoteEndpointWrapper.Async re, State state) {
        this.rew = re;
        this.state = state;
    }

    public Future<Void> send(Object msg, final SendHandler handler) {
        final Object message = msg;
        final FutureSendResult fsr = new FutureSendResult();
        this.rew.endpointWrapper.container.getExecutorService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Future<?> result = null;
                SendResult sr = null;
                try {
                    switch (SendCompletionAdapter.this.state) {
                        case TEXT: {
                            result = SendCompletionAdapter.this.rew.sendSyncText((String)message);
                            break;
                        }
                        case BINARY: {
                            result = SendCompletionAdapter.this.rew.sendSyncBinary((ByteBuffer)message);
                            break;
                        }
                        case OBJECT: {
                            result = SendCompletionAdapter.this.rew.sendSyncObject(message);
                        }
                    }
                    result.get();
                }
                catch (Throwable thw) {
                    sr = new SendResult(thw);
                    fsr.setFailure(thw);
                }
                finally {
                    if (sr == null) {
                        sr = new SendResult();
                    }
                    if (handler != null) {
                        handler.onResult(sr);
                    }
                    fsr.setDone();
                }
            }
        });
        return fsr;
    }

    static enum State {
        TEXT,
        BINARY,
        OBJECT;

    }
}

