/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.websockets;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.tyrus.websockets.DefaultWebSocket;
import org.glassfish.tyrus.websockets.Extension;
import org.glassfish.tyrus.websockets.HandShake;
import org.glassfish.tyrus.websockets.HandshakeException;
import org.glassfish.tyrus.websockets.ProtocolHandler;
import org.glassfish.tyrus.websockets.WebSocket;
import org.glassfish.tyrus.websockets.WebSocketListener;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.glassfish.tyrus.websockets.WebSocketResponse;
import org.glassfish.tyrus.websockets.draft06.ClosingFrame;

public abstract class WebSocketApplication
implements WebSocketListener {
    private final ConcurrentHashMap<WebSocket, Boolean> sockets = new ConcurrentHashMap();
    private final List<Extension> supportedExtensions = new ArrayList<Extension>();
    private final List<String> supportedProtocols = new ArrayList<String>();

    public WebSocket createSocket(ProtocolHandler handler, WebSocketRequest requestPacket, WebSocketListener ... listeners) {
        return new DefaultWebSocket(handler, requestPacket, listeners);
    }

    @Override
    public void onClose(WebSocket socket, ClosingFrame frame) {
        this.remove(socket);
        socket.close();
    }

    @Override
    public void onConnect(WebSocket socket) {
        this.add(socket);
    }

    public void onExtensionNegotiation(List<Extension> extensions) {
    }

    public final boolean upgrade(WebSocketRequest request) {
        String upgradeHeader = request.getHeader("Upgrade");
        return request.getHeaders().get("Upgrade") != null && "websocket".equalsIgnoreCase(upgradeHeader) && this.isApplicationRequest(request);
    }

    public boolean onError(WebSocket webSocket, Throwable t) {
        return true;
    }

    public abstract void onHandShakeResponse(WebSocketRequest var1, WebSocketResponse var2);

    protected abstract boolean isApplicationRequest(WebSocketRequest var1);

    public abstract String getPath();

    public List<Extension> getSupportedExtensions() {
        return this.supportedExtensions;
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        return this.supportedProtocols;
    }

    protected Set<WebSocket> getWebSockets() {
        return this.sockets.keySet();
    }

    boolean add(WebSocket socket) {
        return this.sockets.put(socket, Boolean.TRUE) == null;
    }

    boolean remove(WebSocket socket) {
        return this.sockets.remove(socket) != null;
    }

    protected void handshake(HandShake handshake) throws HandshakeException {
    }
}

