/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.server;

import jakarta.websocket.DeploymentException;
import jakarta.websocket.server.ServerEndpointConfig;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.http.util.ContentType;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.tyrus.container.grizzly.server.WebSocketAddOn;
import org.glassfish.tyrus.core.DebugContext;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.cluster.ClusterContext;
import org.glassfish.tyrus.core.monitoring.ApplicationEventListener;
import org.glassfish.tyrus.core.wsadl.model.Application;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.spi.ServerContainer;
import org.glassfish.tyrus.spi.ServerContainerFactory;
import org.glassfish.tyrus.spi.WebSocketEngine;

public class GrizzlyServerContainer
extends ServerContainerFactory {
    public static final String WORKER_THREAD_POOL_CONFIG = "org.glassfish.tyrus.container.grizzly.server.workerThreadPoolConfig";
    public static final String SELECTOR_THREAD_POOL_CONFIG = "org.glassfish.tyrus.container.grizzly.server.selectorThreadPoolConfig";

    @Override
    public ServerContainer createContainer(Map<String, Object> properties) {
        Map<String, Object> localProperties = properties == null ? Collections.emptyMap() : new HashMap<String, Object>(properties);
        return new TyrusGrizzlyServerContainer(localProperties);
    }

    static class TyrusGrizzlyServerContainer
    extends TyrusServerContainer {
        private final Map<String, Object> localProperties;
        private final WebSocketEngine engine;
        private final ApplicationEventListener applicationEventListener;
        private HttpServer server;
        private String contextPath;
        private volatile NetworkListener listener = null;

        TyrusGrizzlyServerContainer(Map<String, Object> properties) {
            super((Set)null);
            this.localProperties = properties;
            Integer incomingBufferSize = Utils.getProperty(this.localProperties, "org.glassfish.tyrus.incomingBufferSize", Integer.class);
            ClusterContext clusterContext = Utils.getProperty(this.localProperties, "org.glassfish.tyrus.core.cluster.ClusterContext", ClusterContext.class);
            Integer maxSessionsPerApp = Utils.getProperty(this.localProperties, "org.glassfish.tyrus.maxSessionsPerApp", Integer.class);
            Integer maxSessionsPerRemoteAddr = Utils.getProperty(this.localProperties, "org.glassfish.tyrus.maxSessionsPerRemoteAddr", Integer.class);
            Boolean parallelBroadcastEnabled = Utils.getProperty(this.localProperties, "org.glassfish.tyrus.server.parallelBroadcastEnabled", Boolean.class);
            DebugContext.TracingType tracingType = Utils.getProperty(this.localProperties, "org.glassfish.tyrus.server.tracingType", DebugContext.TracingType.class, DebugContext.TracingType.OFF);
            DebugContext.TracingThreshold tracingThreshold = Utils.getProperty(this.localProperties, "org.glassfish.tyrus.server.tracingThreshold", DebugContext.TracingThreshold.class, DebugContext.TracingThreshold.TRACE);
            this.applicationEventListener = Utils.getProperty(this.localProperties, "org.glassfish.tyrus.core.monitoring.ApplicationEventListener", ApplicationEventListener.class);
            this.engine = TyrusWebSocketEngine.builder(this).incomingBufferSize(incomingBufferSize).clusterContext(clusterContext).applicationEventListener(this.applicationEventListener).maxSessionsPerApp(maxSessionsPerApp).maxSessionsPerRemoteAddr(maxSessionsPerRemoteAddr).parallelBroadcastEnabled(parallelBroadcastEnabled).tracingType(tracingType).tracingThreshold(tracingThreshold).build();
        }

        @Override
        public void register(Class<?> endpointClass) throws DeploymentException {
            this.engine.register(endpointClass, this.contextPath);
        }

        @Override
        public void register(ServerEndpointConfig serverEndpointConfig) throws DeploymentException {
            this.engine.register(serverEndpointConfig, this.contextPath);
        }

        @Override
        public WebSocketEngine getWebSocketEngine() {
            return this.engine;
        }

        @Override
        public void start(String rootPath, int port) throws IOException, DeploymentException {
            Object wsadl;
            this.contextPath = rootPath;
            this.server = new HttpServer();
            ServerConfiguration config = this.server.getServerConfiguration();
            this.listener = new NetworkListener("grizzly", "0.0.0.0", port);
            this.server.addListener(this.listener);
            ThreadPoolConfig workerThreadPoolConfig = Utils.getProperty(this.localProperties, GrizzlyServerContainer.WORKER_THREAD_POOL_CONFIG, ThreadPoolConfig.class);
            ThreadPoolConfig selectorThreadPoolConfig = Utils.getProperty(this.localProperties, GrizzlyServerContainer.SELECTOR_THREAD_POOL_CONFIG, ThreadPoolConfig.class);
            if (workerThreadPoolConfig != null || selectorThreadPoolConfig != null) {
                TCPNIOTransportBuilder transportBuilder = TCPNIOTransportBuilder.newInstance();
                if (workerThreadPoolConfig != null) {
                    transportBuilder.setWorkerThreadPoolConfig(workerThreadPoolConfig);
                }
                if (selectorThreadPoolConfig != null) {
                    transportBuilder.setSelectorThreadPoolConfig(selectorThreadPoolConfig);
                }
                transportBuilder.setIOStrategy((IOStrategy)WorkerThreadIOStrategy.getInstance());
                this.server.getListener("grizzly").setTransport(transportBuilder.build());
            } else {
                this.server.getListener("grizzly").getTransport().setIOStrategy((IOStrategy)WorkerThreadIOStrategy.getInstance());
            }
            this.server.getListener("grizzly").getKeepAlive().setIdleTimeoutInSeconds(-1);
            this.server.getListener("grizzly").registerAddOn((AddOn)new WebSocketAddOn(this, this.contextPath));
            WebSocketEngine webSocketEngine = this.getWebSocketEngine();
            Object staticContentPath = this.localProperties.get("org.glassfish.tyrus.server.staticContentRoot");
            StaticHttpHandler staticHandler = null;
            if (staticContentPath != null && !staticContentPath.toString().isEmpty()) {
                staticHandler = new StaticHttpHandler(new String[]{staticContentPath.toString()});
            }
            if ((wsadl = this.localProperties.get("org.glassfish.tyrus.server.wsadl")) != null && wsadl.toString().equalsIgnoreCase("true")) {
                config.addHttpHandler((HttpHandler)new WsadlHttpHandler((TyrusWebSocketEngine)webSocketEngine, (HttpHandler)staticHandler));
            } else if (staticHandler != null) {
                config.addHttpHandler(staticHandler);
            }
            if (this.applicationEventListener != null) {
                this.applicationEventListener.onApplicationInitialized(rootPath);
            }
            this.server.start();
            super.start(rootPath, port);
        }

        @Override
        public int getPort() {
            if (this.listener != null && this.listener.getPort() > 0) {
                return this.listener.getPort();
            }
            return -1;
        }

        @Override
        public void stop() {
            super.stop();
            this.server.shutdownNow();
            if (this.applicationEventListener != null) {
                this.applicationEventListener.onApplicationDestroyed();
            }
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.localProperties;
        }
    }

    private static class WsadlHttpHandler
    extends HttpHandler {
        private final TyrusWebSocketEngine engine;
        private final HttpHandler staticHttpHandler;
        private final Lock contextLock = new ReentrantLock();
        private JAXBContext wsadlJaxbContext;

        private WsadlHttpHandler(TyrusWebSocketEngine engine, HttpHandler staticHttpHandler) {
            this.engine = engine;
            this.staticHttpHandler = staticHttpHandler;
        }

        private JAXBContext getWsadlJaxbContext() throws JAXBException {
            this.contextLock.lock();
            try {
                if (this.wsadlJaxbContext == null) {
                    this.wsadlJaxbContext = JAXBContext.newInstance((String)Application.class.getPackage().getName());
                }
                JAXBContext jAXBContext = this.wsadlJaxbContext;
                return jAXBContext;
            }
            finally {
                this.contextLock.unlock();
            }
        }

        public void service(Request request, Response response) throws Exception {
            if (request.getMethod().equals(Method.GET) && request.getRequestURI().endsWith("application.wsadl")) {
                this.getWsadlJaxbContext().createMarshaller().marshal((Object)this.engine.getWsadlApplication(), response.getWriter());
                response.setStatus(200);
                response.setContentType(ContentType.newContentType((String)"application/wsadl+xml"));
                return;
            }
            if (this.staticHttpHandler != null) {
                this.staticHttpHandler.service(request, response);
            } else {
                response.sendError(404);
            }
        }
    }
}

