/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.server.ServerApplicationConfig;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.core.DebugContext;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.monitoring.ApplicationEventListener;
import org.glassfish.tyrus.core.uri.internal.PathSegment;
import org.glassfish.tyrus.core.uri.internal.UriComponent;
import org.glassfish.tyrus.server.TyrusServerConfiguration;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.servlet.TyrusServletFilter;
import org.glassfish.tyrus.servlet.TyrusServletUpgrade;
import org.glassfish.tyrus.spi.WebSocketEngine;

@HandlesTypes(value={ServerEndpoint.class, ServerApplicationConfig.class, Endpoint.class})
public class TyrusServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(TyrusServletContainerInitializer.class.getName());
    private static final Set<Class<?>> FILTERED_CLASSES = new HashSet<Class<?>>(){
        {
            this.add(TyrusServerConfiguration.class);
        }
    };

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        classes.removeAll(FILTERED_CLASSES);
        Integer incomingBufferSize = this.getIntContextParam(ctx, "org.glassfish.tyrus.servlet.incoming-buffer-size");
        Integer maxSessionsPerApp = this.getIntContextParam(ctx, "org.glassfish.tyrus.maxSessionsPerApp");
        Integer maxSessionsPerRemoteAddr = this.getIntContextParam(ctx, "org.glassfish.tyrus.maxSessionsPerRemoteAddr");
        Boolean parallelBroadcastEnabled = this.getBooleanContextParam(ctx, "org.glassfish.tyrus.server.parallelBroadcastEnabled");
        DebugContext.TracingType tracingType = this.getEnumContextParam(ctx, "org.glassfish.tyrus.server.tracingType", DebugContext.TracingType.class, DebugContext.TracingType.OFF);
        DebugContext.TracingThreshold tracingThreshold = this.getEnumContextParam(ctx, "org.glassfish.tyrus.server.tracingThreshold", DebugContext.TracingThreshold.class, DebugContext.TracingThreshold.TRACE);
        Boolean wsadlEnabled = this.getBooleanContextParam(ctx, "org.glassfish.tyrus.server.wsadl");
        if (wsadlEnabled == null) {
            wsadlEnabled = false;
        }
        LOGGER.config("WSADL enabled: " + wsadlEnabled);
        ApplicationEventListener applicationEventListener = this.createApplicationEventListener(ctx);
        TyrusServerContainerImpl serverContainer = new TyrusServerContainerImpl(classes, applicationEventListener, incomingBufferSize, maxSessionsPerApp, maxSessionsPerRemoteAddr, parallelBroadcastEnabled, tracingType, tracingThreshold, ctx.getContextPath(), wsadlEnabled);
        ctx.setAttribute(ServerContainer.class.getName(), (Object)serverContainer);
        TyrusServletFilter filter = new TyrusServletFilter(serverContainer.getServletUpgrade());
        ctx.addListener((EventListener)((Object)filter));
        FilterRegistration.Dynamic reg = ctx.addFilter("WebSocket filter", (Filter)filter);
        reg.setAsyncSupported(true);
        reg.addMappingForUrlPatterns(null, true, new String[]{"/*"});
        LOGGER.info("Registering WebSocket filter for url pattern /*");
        if (applicationEventListener != null) {
            applicationEventListener.onApplicationInitialized(ctx.getContextPath());
        }
    }

    private Integer getIntContextParam(ServletContext ctx, String paramName) {
        String initParameter = ctx.getInitParameter(paramName);
        if (initParameter != null) {
            try {
                return Integer.parseInt(initParameter);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.CONFIG, "Invalid configuration value [" + paramName + " = " + initParameter + "], integer expected");
            }
        }
        return null;
    }

    private Boolean getBooleanContextParam(ServletContext ctx, String paramName) {
        String initParameter = ctx.getInitParameter(paramName);
        if (initParameter != null) {
            if (initParameter.equalsIgnoreCase("true")) {
                return true;
            }
            if (initParameter.equalsIgnoreCase("false")) {
                return false;
            }
            LOGGER.log(Level.CONFIG, "Invalid configuration value [" + paramName + " = " + initParameter + "], boolean expected");
            return null;
        }
        return null;
    }

    private <T extends Enum<T>> T getEnumContextParam(ServletContext ctx, String paramName, Class<T> type, T defaultValue) {
        String initParameter = ctx.getInitParameter(paramName);
        if (initParameter == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(type, initParameter.trim().toUpperCase(Locale.US));
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, "Invalid configuration value [" + paramName + " = " + initParameter + "]");
            return defaultValue;
        }
    }

    private ApplicationEventListener createApplicationEventListener(ServletContext ctx) {
        String listenerClassName = ctx.getInitParameter("org.glassfish.tyrus.core.monitoring.ApplicationEventListener");
        if (listenerClassName == null) {
            return null;
        }
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Class<?> listenerClass = Class.forName(listenerClassName, true, contextClassLoader);
            Object o = listenerClass.newInstance();
            if (o instanceof ApplicationEventListener) {
                return (ApplicationEventListener)o;
            }
            LOGGER.log(Level.WARNING, "Class " + listenerClassName + " does not implement ApplicationEventListener");
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.WARNING, "ApplicationEventListener implementation " + listenerClassName + " not found", e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.log(Level.WARNING, "ApplicationEventListener implementation " + listenerClassName + " could not have been instantiated", e);
        }
        return null;
    }

    private static class TyrusServerContainerImpl
    extends TyrusServerContainer {
        private final ApplicationEventListener applicationEventListener;
        private final Integer incomingBufferSize;
        private final Integer maxSessionsPerApp;
        private final Integer maxSessionsPerRemoteAddr;
        private final Boolean parallelBroadcastEnabled;
        private final DebugContext.TracingType tracingType;
        private final DebugContext.TracingThreshold tracingThreshold;
        private final String contextPath;
        private final WebSocketEngine engine;
        private final TyrusServletUpgrade tyrusServletUpgrade;

        private TyrusServerContainerImpl(Set<Class<?>> set, ApplicationEventListener applicationEventListener, Integer incomingBufferSize, Integer maxSessionsPerApp, Integer maxSessionsPerRemoteAddr, Boolean parallelBroadcastEnabled, DebugContext.TracingType tracingType, DebugContext.TracingThreshold tracingThreshold, String contextPath, boolean wsadlEnabled) {
            super(set);
            this.applicationEventListener = applicationEventListener;
            this.incomingBufferSize = incomingBufferSize;
            this.maxSessionsPerApp = maxSessionsPerApp;
            this.maxSessionsPerRemoteAddr = maxSessionsPerRemoteAddr;
            this.parallelBroadcastEnabled = parallelBroadcastEnabled;
            this.tracingType = tracingType;
            this.tracingThreshold = tracingThreshold;
            this.contextPath = contextPath;
            this.engine = TyrusWebSocketEngine.builder(this).applicationEventListener(applicationEventListener).incomingBufferSize(incomingBufferSize).maxSessionsPerApp(maxSessionsPerApp).maxSessionsPerRemoteAddr(maxSessionsPerRemoteAddr).parallelBroadcastEnabled(parallelBroadcastEnabled).tracingType(tracingType).tracingThreshold(tracingThreshold).build();
            this.tyrusServletUpgrade = new TyrusServletUpgrade((TyrusWebSocketEngine)this.engine, wsadlEnabled);
        }

        @Override
        public void register(Class<?> endpointClass) throws DeploymentException {
            this.engine.register(endpointClass, this.contextPath);
        }

        @Override
        public void register(ServerEndpointConfig serverEndpointConfig) throws DeploymentException {
            this.engine.register(serverEndpointConfig, this.contextPath);
        }

        @Override
        public WebSocketEngine getWebSocketEngine() {
            return this.engine;
        }

        @Override
        public void upgradeHttpToWebSocket(Object servletRequest, Object servletResponse, ServerEndpointConfig sec, Map<String, String> pathParameters) throws IOException, DeploymentException {
            final String requestUri = TyrusServerContainerImpl.computeRequestPath(sec.getPath(), pathParameters);
            HttpServletRequestWrapper httpServletRequest = new HttpServletRequestWrapper((HttpServletRequest)servletRequest){

                public String getRequestURI() {
                    return contextPath + requestUri;
                }

                public String getContextPath() {
                    return "/";
                }
            };
            try {
                this.tyrusServletUpgrade.upgrade((HttpServletRequest)httpServletRequest, (HttpServletResponse)servletResponse);
            }
            catch (ServletException e) {
                throw new DeploymentException(e.getMessage(), e);
            }
        }

        private TyrusServletUpgrade getServletUpgrade() {
            return this.tyrusServletUpgrade;
        }

        private static String computeRequestPath(String path, Map<String, String> pathParams) {
            StringBuilder resultPath = new StringBuilder();
            List<PathSegment> endpointPathSegments = UriComponent.decodePath(path, true);
            for (int i = 0; i < endpointPathSegments.size(); ++i) {
                resultPath.append('/');
                String endpointSegment = endpointPathSegments.get(i).getPath();
                if (TyrusServerContainerImpl.isVariable(endpointSegment)) {
                    String pathParam = pathParams.get(TyrusServerContainerImpl.getVariableName(endpointSegment));
                    resultPath.append(pathParam == null ? endpointSegment : pathParam);
                    continue;
                }
                resultPath.append(endpointSegment);
            }
            String result = resultPath.toString();
            return result.startsWith("//") ? result.substring(1) : result;
        }

        private static boolean isVariable(String segment) {
            return segment.startsWith("{") && segment.endsWith("}");
        }

        private static String getVariableName(String segment) {
            return segment.substring(1, segment.length() - 1);
        }
    }
}

